/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OFixCreateRecordTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    protected ORecordId ridAssigned;
    protected ORecordVersion version;
    protected byte[] content;
    protected byte recordType;
    protected ORecordId ridToAssign;

    public OFixCreateRecordTask() {
    }

    public OFixCreateRecordTask(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, ORecordId iRIDToAssign) {
        this.ridAssigned = iRid;
        this.content = iContent;
        this.version = iVersion;
        this.recordType = iRecordType;
        this.ridToAssign = iRIDToAssign;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "fixing create record %s/%s by applying rid=%s v=%s", database.getName(), this.ridAssigned.toString(), this.ridToAssign.toString(), this.version.toString());
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
        record.fill((ORID)this.ridAssigned, this.version, this.content, true);
        database.save(record);
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> fixed create record %s/%s v.%s", database.getName(), record.getIdentity().toString(), record.getRecordVersion().toString());
        return Boolean.TRUE;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.NONE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.recordType);
        out.writeUTF(this.ridAssigned.toString());
        out.writeInt(this.content.length);
        out.write(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
        out.writeUTF(this.ridToAssign.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.recordType = in.readByte();
        this.ridAssigned = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
        this.ridToAssign = new ORecordId(in.readUTF());
    }

    @Override
    public String getName() {
        return "fix_record_create";
    }
}

