/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;

public class ODistributedConfiguration {
    public static final String NEW_NODE_TAG = "<NEW_NODE>";
    private ODocument configuration;

    public ODistributedConfiguration(ODocument iConfiguration) {
        this.configuration = iConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicationActive(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument cluster;
            if (iClusterName != null && (cluster = this.getClusterConfiguration(iClusterName)).containsField("replication")) {
                return (Boolean)cluster.field("replication");
            }
            return (Boolean)this.configuration.field("replication");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHotAlignment() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Boolean value = (Boolean)this.configuration.field("hotAlignment");
            if (value != null) {
                return value;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("readQuorum");
            if (value != null) {
                return (Integer)value;
            }
            OLogManager.instance().warn((Object)this, "readQuorum setting not found in distributed-config.json", new Object[0]);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWriteQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("writeQuorum");
            if (value != null) {
                return (Integer)value;
            }
            OLogManager.instance().warn((Object)this, "writeQuorum setting not found in distributed-config.json", new Object[0]);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFailureAvailableNodesLessQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("failureAvailableNodesLessQuorum");
            if (value != null) {
                return (Boolean)value;
            }
            OLogManager.instance().warn((Object)this, "failureAvailableNodesLessQuorum setting not found in distributed-config.json", new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isReadYourWrites(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("readYourWrites");
            if (value != null) {
                return (Boolean)value;
            }
            OLogManager.instance().warn((Object)this, "readYourWrites setting not found in distributed-config.json", new Object[0]);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResyncEvery() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.configuration.field("resyncEvery");
            if (value != null) {
                return (Integer)value;
            }
            OLogManager.instance().warn((Object)this, "resyncEvery setting not found in distributed-config.json", new Object[0]);
            return 15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultPartition(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("default");
            if (value != null) {
                return (Integer)value;
            }
            OLogManager.instance().warn((Object)this, "default setting not found in distributed-config.json", new Object[0]);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPartitionStrategy(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getPartitioningConfiguration(iClusterName).field("strategy");
            if (value != null) {
                return (String)value;
            }
            OLogManager.instance().warn((Object)this, "strategy setting not found in distributed-config.json", new Object[0]);
            return "round-robin";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedConfiguration addNodeInPartition(String iClusterName, int iPartition, String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            this.getPartition(iClusterName, iPartition).add(iNode);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPartition(String iClusterName, int iPartition) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            List<List<String>> partitions = this.getPartitions(iClusterName);
            return partitions.get(iPartition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getPartitions(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument partition = this.getPartitioningConfiguration(iClusterName);
            if (partition == null) {
                return null;
            }
            return (List)partition.field("partitions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument getPartitioningConfiguration(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument cluster = this.getClusterConfiguration(iClusterName);
            return (ODocument)cluster.field("partitioning");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterConfigurationName(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            if (clusters == null) {
                throw new OConfigurationException("Cannot find 'clusters' in distributed database configuration");
            }
            return clusters.containsField(iClusterName) ? iClusterName : "*";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClusterNames() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            return clusters.fieldNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument getClusterConfiguration(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument cfg;
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            if (clusters == null) {
                throw new OConfigurationException("Cannot find 'clusters' in distributed database configuration");
            }
            if (iClusterName == null) {
                iClusterName = "*";
            }
            if ((cfg = (ODocument)clusters.field(iClusterName)) == null && !iClusterName.equals("*")) {
                cfg = (ODocument)clusters.field("*");
            }
            return cfg;
        }
    }

    public ODocument serialize() {
        return this.configuration.copy();
    }
}

