/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OFixTxTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class OTxTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    private List<OAbstractRecordReplicatedTask> tasks = new ArrayList<OAbstractRecordReplicatedTask>();

    public void add(OAbstractRecordReplicatedTask iTask) {
        this.tasks.add(iTask);
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "committing transaction against db=%s...", database.getName());
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)database);
        try {
            database.begin();
            for (OAbstractRecordReplicatedTask task : this.tasks) {
                task.execute(iServer, iManager, database);
            }
            database.commit();
        }
        catch (ONeedRetryException e) {
            return Boolean.FALSE;
        }
        catch (OTransactionException e) {
            return Boolean.FALSE;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on distirbuted transaction commit", (Throwable)e, new Object[0]);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.WRITE;
    }

    @Override
    public OFixTxTask getFixTask(ODistributedRequest iRequest, ODistributedResponse iBadResponse, ODistributedResponse iGoodResponse) {
        OFixTxTask fixTask = new OFixTxTask();
        for (OAbstractRecordReplicatedTask t : this.tasks) {
            ORecordId rid = t.getRid();
            ORecordInternal rec = (ORecordInternal)rid.getRecord();
            if (rec == null) {
                fixTask.add(new ODeleteRecordTask(rid, null));
                continue;
            }
            ORecordVersion v = rec.getRecordVersion();
            v.setRollbackMode();
            fixTask.add(new OUpdateRecordTask(rid, rec.toStream(), v, rec.getRecordType()));
        }
        return fixTask;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.tasks.size());
        for (OAbstractRecordReplicatedTask task : this.tasks) {
            out.writeObject(task);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.tasks.add((OAbstractRecordReplicatedTask)in.readObject());
        }
    }

    @Override
    public String getName() {
        return "tx";
    }

    @Override
    public String getPayload() {
        return null;
    }
}

