/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OFixUpdateRecordTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OUpdateRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    protected byte[] content;
    protected byte recordType;

    public OUpdateRecordTask() {
    }

    public OUpdateRecordTask(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType) {
        super(iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "updating record %s/%s v.%s", database.getName(), this.rid.toString(), this.version.toString());
        ORecordInternal loadedRecord = (ORecordInternal)this.rid.getRecord();
        if (loadedRecord == null) {
            throw new ORecordNotFoundException("Record " + this.rid + " was not found on update");
        }
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
        record.fill((ORID)this.rid, this.version, this.content, true);
        if (loadedRecord instanceof ODocument) {
            ((ODocument)loadedRecord).merge((ODocument)record, false, false);
            database.save(loadedRecord);
        } else {
            database.save(record);
        }
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> updated record %s/%s v.%s", database.getName(), this.rid.toString(), record.getRecordVersion().toString());
        return record.getRecordVersion();
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.WRITE;
    }

    @Override
    public OFixUpdateRecordTask getFixTask(ODistributedRequest iRequest, ODistributedResponse iBadResponse, ODistributedResponse iGoodResponse) {
        return new OFixUpdateRecordTask(this.rid, ((OUpdateRecordTask)iRequest.getTask()).content, this.version);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        out.writeInt(this.content.length);
        out.write(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
        out.write(this.recordType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
        this.recordType = in.readByte();
    }

    @Override
    public String getName() {
        return "record_update";
    }

    @Override
    public String toString() {
        if (this.version.isTemporary()) {
            return this.getName() + "(" + this.rid + " v." + (this.version.getCounter() - Integer.MIN_VALUE) + " realV." + this.version + ")";
        }
        return super.toString();
    }
}

