/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.schedule;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.orient.server.schedule.OSchedulingPattern;
import com.orientechnologies.orient.server.schedule.TimerThread;
import java.io.File;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OScheduleHandler
extends OServerPluginAbstract {
    private static int MAX_POOL_SIZE = 21;
    private ExecutorService executor = Executors.newFixedThreadPool(MAX_POOL_SIZE);
    protected String databaseName = "";
    protected String user = "admin";
    protected String pass = "admin";
    protected boolean isEnabled = false;
    private static final String BASEPATH = "${ORIENTDB_HOME}/databases/";

    public String getName() {
        return "scheduler";
    }

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("databaseName")) {
                this.databaseName = param.value;
            }
            if (param.name.equalsIgnoreCase("user")) {
                this.user = param.value;
            }
            if (param.name.equalsIgnoreCase("pass")) {
                this.pass = param.value;
            }
            if (!param.name.equalsIgnoreCase("enabled")) continue;
            this.isEnabled = Boolean.parseBoolean(param.value);
        }
    }

    @Override
    public void startup() {
        if (!this.isEnabled) {
            return;
        }
        TimerThread tThread = new TimerThread(this);
        this.executor.execute(tThread);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    public void executeSchedule(long referenceTimeMillis) {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        Map schedulers = db.getMetadata().getSchedulerListener().getSchedulers();
        for (String key : schedulers.keySet()) {
            OSchedulingPattern pattern;
            OScheduler scheduler = (OScheduler)schedulers.get(key);
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "check : " + scheduler.toString(), new Object[0]);
            }
            if (!(pattern = new OSchedulingPattern(scheduler.getSchedulingRule())).match(TimeZone.getDefault(), referenceTimeMillis) || !scheduler.isStarted()) continue;
            this.executor.execute((Runnable)scheduler);
        }
    }

    public ODatabaseDocument getDatabase() {
        ODatabaseDocument db = null;
        try {
            String url = OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(BASEPATH + this.databaseName).getPath()));
            if (this.exists(url)) {
                db = (ODatabaseDocument)new ODatabaseDocumentTx("local:" + url).open(this.user, this.pass);
            } else {
                db = null;
                OLogManager.instance().error((Object)this, "database pharos not exist", new Object[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            db = null;
            OLogManager.instance().error((Object)this, "failed to open database", new Object[0]);
        }
        return db;
    }

    private boolean exists(String path) {
        return new File(path + "/default.0.oda").exists();
    }
}

