/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.schedule;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.server.schedule.OScheduleHandler;

class TimerThread
extends Thread {
    OScheduleHandler handler;
    ODatabaseDocument db = null;

    public TimerThread(OScheduleHandler handler) {
        this.handler = handler;
    }

    @Override
    public void run() {
        OLogManager.instance().warn((Object)this, "Schedule Timer Started", new Object[0]);
        long millis = System.currentTimeMillis();
        long nextMinute = (millis / 60000L + 1L) * 60000L;
        while (true) {
            long sleepTime;
            if ((sleepTime = nextMinute - System.currentTimeMillis()) > 0L) {
                try {
                    this.safeSleep(sleepTime);
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error((Object)this, "exit timer thread " + e.getMessage(), new Object[0]);
                    break;
                }
            }
            millis = System.currentTimeMillis();
            try {
                if (!this.isInterrupted() && this.db != null) {
                    this.handler.executeSchedule(millis);
                }
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "error on execute schedule " + t.getMessage(), new Object[0]);
                if (this.db != null) {
                    this.db.close();
                }
                this.db = null;
            }
            nextMinute = (millis / 60000L + 1L) * 60000L;
            if (this.db != null) continue;
            this.db = this.handler.getDatabase();
        }
        if (this.db != null) {
            this.db.close();
        }
        OLogManager.instance().warn((Object)this, "Schedule Timer Ended", new Object[0]);
    }

    private void safeSleep(long millis) throws InterruptedException {
        long before;
        long after;
        long done = 0L;
        do {
            before = System.currentTimeMillis();
            TimerThread.sleep(millis - done);
        } while ((done += (after = System.currentTimeMillis()) - before) < millis);
    }
}

