/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ODistributedResponseManager {
    private static final String NO_RESPONSE = "waiting-for-response";
    private final ODistributedServerManager dManager;
    private final ODistributedRequest request;
    private final long sentOn;
    private final HashMap<String, Object> responses = new HashMap();
    private final boolean groupResponsesByResult;
    private final List<List<ODistributedResponse>> responseGroups = new ArrayList<List<ODistributedResponse>>();
    private final int expectedSynchronousResponses;
    private final long synchTimeout;
    private final long totalTimeout;
    private final Lock synchronousResponsesLock = new ReentrantLock();
    private final Condition synchronousResponsesArrived = this.synchronousResponsesLock.newCondition();
    private int receivedResponses = 0;
    private int quorum;
    private boolean waitForLocalNode;
    private volatile boolean receivedCurrentNode;

    public ODistributedResponseManager(ODistributedServerManager iManager, ODistributedRequest iRequest, Collection<String> expectedResponses, int iExpectedSynchronousResponses, int iQuorum, boolean iWaitForLocalNode, long iSynchTimeout, long iTotalTimeout, boolean iGroupResponsesByResult) {
        this.dManager = iManager;
        this.request = iRequest;
        this.sentOn = System.currentTimeMillis();
        this.expectedSynchronousResponses = iExpectedSynchronousResponses;
        this.quorum = iQuorum;
        this.waitForLocalNode = iWaitForLocalNode;
        this.synchTimeout = iSynchTimeout;
        this.totalTimeout = iTotalTimeout;
        this.groupResponsesByResult = iGroupResponsesByResult;
        for (String node : expectedResponses) {
            this.responses.put(node, NO_RESPONSE);
        }
        if (this.groupResponsesByResult) {
            this.responseGroups.add(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectResponse(ODistributedResponse response) {
        String executorNode = response.getExecutorNodeName();
        if (!this.responses.containsKey(executorNode)) {
            ODistributedServerLog.warn((Object)this, response.getSenderNodeName(), executorNode, ODistributedServerLog.DIRECTION.IN, "received response for request %s from unexpected node. Expected are: %s", this.request, this.getExpectedNodes());
            Orient.instance().getProfiler().updateCounter("distributed.replication.unexpectedNodeResponse", "Number of responses from unexpected nodes", 1L);
            return false;
        }
        Orient.instance().getProfiler().stopChrono("distributed.replication.responseTime", "Response time from replication messages", this.sentOn, "distributed.replication.responseTime");
        Orient.instance().getProfiler().stopChrono("distributed.replication." + executorNode + ".responseTime", "Response time from replication messages", this.sentOn, "distributed.replication.*.responseTime");
        boolean completed = false;
        List<List<ODistributedResponse>> list = this.responseGroups;
        synchronized (list) {
            this.responses.put(executorNode, response);
            ++this.receivedResponses;
            if (this.waitForLocalNode && response.isExecutedOnLocalNode()) {
                this.receivedCurrentNode = true;
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, response.getSenderNodeName(), executorNode, ODistributedServerLog.DIRECTION.IN, "received response '%s' for request %s (receivedCurrentNode=%s receivedResponses=%d)", response, this.request, this.receivedCurrentNode, this.receivedResponses);
            }
            if (this.groupResponsesByResult) {
                boolean foundBucket = false;
                for (int i = 0; i < this.responseGroups.size(); ++i) {
                    List<ODistributedResponse> sameResponse = this.responseGroups.get(i);
                    if (!sameResponse.isEmpty() && (sameResponse.get(0).getPayload() != null || response.getPayload() != null) && !sameResponse.get(0).getPayload().equals(response.getPayload())) continue;
                    sameResponse.add(response);
                    foundBucket = true;
                    break;
                }
                if (!foundBucket) {
                    ArrayList<ODistributedResponse> newBucket = new ArrayList<ODistributedResponse>();
                    this.responseGroups.add(newBucket);
                    newBucket.add(response);
                }
            }
            boolean bl = completed = this.getExpectedResponses() == this.receivedResponses;
            if (this.receivedResponses >= this.expectedSynchronousResponses && (!this.waitForLocalNode || this.receivedCurrentNode) && (completed || this.isMinimumQuorumReached(false))) {
                this.synchronousResponsesLock.lock();
                try {
                    this.synchronousResponsesArrived.signalAll();
                }
                finally {
                    this.synchronousResponsesLock.unlock();
                }
            }
        }
        return completed;
    }

    public List<ODistributedResponse> getReceivedResponses() {
        ArrayList<ODistributedResponse> parsed = new ArrayList<ODistributedResponse>();
        for (Object r : this.responses.values()) {
            if (r == NO_RESPONSE) continue;
            parsed.add((ODistributedResponse)r);
        }
        return parsed;
    }

    public void timeout() {
        this.manageConflicts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinimumQuorumReached(boolean iCheckAvailableNodes) {
        if (this.isWaitForLocalNode() && !this.isReceivedCurrentNode()) {
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), this.dManager.getLocalNodeName(), ODistributedServerLog.DIRECTION.IN, "no response received from local node about request %s", this.request);
            return false;
        }
        if (this.quorum == 0) {
            return true;
        }
        if (!this.groupResponsesByResult) {
            return this.receivedResponses >= this.quorum;
        }
        List<List<ODistributedResponse>> list = this.responseGroups;
        synchronized (list) {
            ODistributedConfiguration dbConfig;
            for (List<ODistributedResponse> group : this.responseGroups) {
                if (group.size() < this.quorum) continue;
                return true;
            }
            if (this.getReceivedResponsesCount() < this.quorum && iCheckAvailableNodes && !(dbConfig = this.dManager.getDatabaseConfiguration(this.getDatabaseName())).getFailureAvailableNodesLessQuorum("*")) {
                int availableNodes = 0;
                for (Map.Entry<String, Object> r : this.responses.entrySet()) {
                    if (!this.dManager.isNodeAvailable(r.getKey(), this.getDatabaseName())) continue;
                    ++availableNodes;
                }
                if (availableNodes < this.quorum) {
                    ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "overridden quorum (%d) for request %s because available nodes (%d) are less than quorum, received responses: %s", this.quorum, this.request, availableNodes, this.responses);
                    return true;
                }
            }
        }
        return false;
    }

    public int getBestResponsesGroup() {
        int maxCoherentResponses = 0;
        int bestGroupSoFar = 0;
        for (int i = 0; i < this.responseGroups.size(); ++i) {
            int currentGroupSize = this.responseGroups.get(i).size();
            if (currentGroupSize <= maxCoherentResponses) continue;
            maxCoherentResponses = currentGroupSize;
            bestGroupSoFar = i;
        }
        return bestGroupSoFar;
    }

    public List<ODistributedResponse> getConflictResponses() {
        ArrayList<ODistributedResponse> servers = new ArrayList<ODistributedResponse>();
        int bestGroupSoFar = this.getBestResponsesGroup();
        for (int i = 0; i < this.responseGroups.size(); ++i) {
            if (i == bestGroupSoFar) continue;
            for (ODistributedResponse r : this.responseGroups.get(i)) {
                servers.add(r);
            }
        }
        return servers;
    }

    public long getMessageId() {
        return this.request.getId();
    }

    public long getSentOn() {
        return this.sentOn;
    }

    public int getExpectedResponses() {
        return this.responses.size();
    }

    public Set<String> getExpectedNodes() {
        return this.responses.keySet();
    }

    public int getMissingResponses() {
        return this.getExpectedResponses() - this.receivedResponses;
    }

    public List<String> getRespondingNodes() {
        ArrayList<String> respondedNodes = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
            if (entry.getValue() == NO_RESPONSE) continue;
            respondedNodes.add(entry.getKey());
        }
        return respondedNodes;
    }

    public List<String> getMissingNodes() {
        ArrayList<String> missingNodes = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
            if (entry.getValue() != NO_RESPONSE) continue;
            missingNodes.add(entry.getKey());
        }
        return missingNodes;
    }

    public int getReceivedResponsesCount() {
        return this.receivedResponses;
    }

    public long getTotalTimeout() {
        return this.totalTimeout;
    }

    public ODistributedResponse merge(ODistributedResponse merged) {
        StringBuilder executor = new StringBuilder();
        HashSet mergedPayload = new HashSet();
        for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
            if (entry.getValue() == NO_RESPONSE) continue;
            if (executor.length() > 0) {
                executor.append(',');
            }
            executor.append(entry.getKey());
            ODistributedResponse response = (ODistributedResponse)entry.getValue();
            Object payload = response.getPayload();
            mergedPayload = (HashSet)OMultiValue.add(mergedPayload, (Object)payload);
        }
        merged.setExecutorNodeName(executor.toString());
        merged.setPayload(mergedPayload);
        return merged;
    }

    public int getExpectedSynchronousResponses() {
        return this.expectedSynchronousResponses;
    }

    public int getQuorum() {
        return this.quorum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSynchronousResponses() throws InterruptedException {
        long beginTime = System.currentTimeMillis();
        this.synchronousResponsesLock.lock();
        try {
            long currentTimeout = this.synchTimeout;
            while (currentTimeout > 0L && (this.waitForLocalNode && !this.receivedCurrentNode || this.receivedResponses < this.expectedSynchronousResponses)) {
                this.synchronousResponsesArrived.await(currentTimeout, TimeUnit.MILLISECONDS);
                if ((!this.waitForLocalNode || this.receivedCurrentNode) && this.receivedResponses >= this.expectedSynchronousResponses) break;
                long now = System.currentTimeMillis();
                long elapsed = now - beginTime;
                currentTimeout = this.synchTimeout - elapsed;
                long lastClusterChange = this.dManager.getLastClusterChangeOn();
                if (lastClusterChange <= 0L || now - lastClusterChange >= this.synchTimeout * 2L) continue;
                ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "cluster shape changed during request %s: enlarge timeout +%dms, wait again for %dms", this.request, this.synchTimeout, currentTimeout += this.synchTimeout);
            }
            boolean bl = this.receivedResponses >= this.expectedSynchronousResponses;
            return bl;
        }
        finally {
            this.synchronousResponsesLock.unlock();
            Orient.instance().getProfiler().stopChrono("distributed.replication.synchResponses", "Time to collect all the synchronous responses from distributed nodes", beginTime);
        }
    }

    public boolean isWaitForLocalNode() {
        return this.waitForLocalNode;
    }

    public boolean isReceivedCurrentNode() {
        return this.receivedCurrentNode;
    }

    public ODistributedResponse getFinalResponse() {
        this.manageConflicts();
        if (this.receivedResponses == 0) {
            throw new ODistributedException("No response received from any of nodes " + this.getExpectedNodes() + " for request " + this.request);
        }
        switch (this.request.getTask().getResultStrategy()) {
            case ANY: {
                break;
            }
            case UNION: {
                HashMap<String, Object> payloads = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
                    if (entry.getValue() == NO_RESPONSE) continue;
                    payloads.put(entry.getKey(), ((ODistributedResponse)entry.getValue()).getPayload());
                }
                ODistributedResponse response = (ODistributedResponse)this.responses.values().iterator().next();
                response.setExecutorNodeName(this.responses.keySet().toString());
                response.setPayload(payloads);
                return response;
            }
        }
        int bestResponsesGroupIndex = this.getBestResponsesGroup();
        List<ODistributedResponse> bestResponsesGroup = this.responseGroups.get(bestResponsesGroupIndex);
        return bestResponsesGroup.get(0);
    }

    public String getDatabaseName() {
        return this.request.getDatabaseName();
    }

    protected void manageConflicts() {
        if (!this.groupResponsesByResult || this.request.getTask().getQuorumType() == OAbstractRemoteTask.QUORUM_TYPE.NONE) {
            return;
        }
        if (this.dManager.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return;
        }
        int bestResponsesGroupIndex = this.getBestResponsesGroup();
        List<ODistributedResponse> bestResponsesGroup = this.responseGroups.get(bestResponsesGroupIndex);
        int maxCoherentResponses = bestResponsesGroup.size();
        int conflicts = this.getExpectedResponses() - maxCoherentResponses;
        if (this.isMinimumQuorumReached(true)) {
            if (this.responseGroups.size() == 1) {
                return;
            }
            if (this.checkNoWinnerCase(bestResponsesGroup)) {
                return;
            }
        } else {
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "detected %d node(s) in timeout or in conflict and quorum (%d) has not been reached, rolling back changes for request: %s", conflicts, this.quorum, this.request);
            this.undoRequest();
            StringBuilder msg = new StringBuilder();
            msg.append("Quorum " + this.getQuorum() + " not reached for request=" + this.request + ".");
            List<ODistributedResponse> res = this.getConflictResponses();
            if (res.isEmpty()) {
                msg.append(" No server in conflict. ");
            } else {
                msg.append(" Servers in timeout/conflict are:");
                for (ODistributedResponse r : res) {
                    msg.append("\n - ");
                    msg.append(r.getExecutorNodeName());
                    msg.append(": ");
                    msg.append(r.getPayload());
                }
                msg.append("\n");
            }
            msg.append("Received: ");
            msg.append(this.responses);
            throw new ODistributedException(msg.toString());
        }
        ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "detected %d conflicts, but the quorum (%d) has been reached. Fixing remote records. Request: %s", conflicts, this.quorum, this.request);
        this.fixNodesInConflict(bestResponsesGroup);
    }

    protected void undoRequest() {
        for (ODistributedResponse r : this.getReceivedResponses()) {
            OAbstractRemoteTask undoTask;
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "sending undo message for request=%s to server %s", this.request, r.getExecutorNodeName());
            OAbstractRemoteTask task = this.request.getTask();
            if (!(task instanceof OAbstractReplicatedTask) || (undoTask = ((OAbstractReplicatedTask)task).getUndoTask(this.request, r.getPayload())) == null) continue;
            this.dManager.sendRequest(this.request.getDatabaseName(), null, Collections.singleton(r.getExecutorNodeName()), undoTask, ODistributedRequest.EXECUTION_MODE.NO_RESPONSE);
        }
    }

    protected void fixNodesInConflict(List<ODistributedResponse> bestResponsesGroup) {
        ODistributedResponse goodResponse = bestResponsesGroup.get(0);
        for (List<ODistributedResponse> responseGroup : this.responseGroups) {
            if (responseGroup == bestResponsesGroup) continue;
            for (ODistributedResponse r : responseGroup) {
                ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "fixing response for request=%s in server %s to be: %s", this.request, r.getExecutorNodeName(), goodResponse);
                OAbstractRemoteTask fixTask = ((OAbstractReplicatedTask)this.request.getTask()).getFixTask(this.request, r.getPayload(), goodResponse.getPayload());
                if (fixTask == null) continue;
                this.dManager.sendRequest(this.request.getDatabaseName(), null, Collections.singleton(r.getExecutorNodeName()), fixTask, ODistributedRequest.EXECUTION_MODE.NO_RESPONSE);
            }
        }
    }

    protected boolean checkNoWinnerCase(List<ODistributedResponse> bestResponsesGroup) {
        int maxCoherentResponses = bestResponsesGroup.size();
        for (List<ODistributedResponse> responseGroup : this.responseGroups) {
            if (responseGroup == bestResponsesGroup || responseGroup.size() != maxCoherentResponses) continue;
            ArrayList<String> a = new ArrayList<String>();
            for (ODistributedResponse r : bestResponsesGroup) {
                a.add(r.getExecutorNodeName());
            }
            ArrayList<String> b = new ArrayList<String>();
            for (ODistributedResponse r : responseGroup) {
                b.add(r.getExecutorNodeName());
            }
            ODistributedServerLog.error((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "detected possible split brain network where 2 groups of servers A%s and B%s have different contents. Cannot decide who is the winner even if the quorum (%d) has been reached. Request: %s", a, b, this.quorum, this.request);
            return true;
        }
        return false;
    }
}

