/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.OTxSegment;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetConnect;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class OServerCommandGetDatabase
extends OServerCommandGetConnect {
    private static final String[] NAMES = new String[]{"GET|database/*"};

    public static void exportClass(ODatabaseDocumentTx db, OJSONWriter json, OClass cls) throws IOException {
        Set indexes;
        Map custom;
        json.beginObject();
        json.writeAttribute("name", (Object)cls.getName());
        json.writeAttribute("superClass", (Object)(cls.getSuperClass() != null ? cls.getSuperClass().getName() : ""));
        json.writeAttribute("alias", (Object)cls.getShortName());
        json.writeAttribute("abstract", (Object)cls.isAbstract());
        json.writeAttribute("strictmode", (Object)cls.isStrictMode());
        json.writeAttribute("clusters", (Object)cls.getClusterIds());
        json.writeAttribute("defaultCluster", (Object)cls.getDefaultClusterId());
        json.writeAttribute("clusterSelection", (Object)cls.getClusterSelection().getName());
        if (cls instanceof OClassImpl && (custom = ((OClassImpl)cls).getCustomInternal()) != null && !custom.isEmpty()) {
            json.writeAttribute("custom", (Object)custom);
        }
        try {
            json.writeAttribute("records", (Object)db.countClass(cls.getName()));
        }
        catch (OSecurityAccessException e) {
            json.writeAttribute("records", (Object)"? (Unauthorized)");
        }
        if (cls.properties() != null && cls.properties().size() > 0) {
            json.beginCollection("properties");
            for (OProperty prop : cls.properties()) {
                Map custom2;
                json.beginObject();
                json.writeAttribute("name", (Object)prop.getName());
                if (prop.getLinkedClass() != null) {
                    json.writeAttribute("linkedClass", (Object)prop.getLinkedClass().getName());
                }
                if (prop.getLinkedType() != null) {
                    json.writeAttribute("linkedType", (Object)prop.getLinkedType().toString());
                }
                json.writeAttribute("type", (Object)prop.getType().toString());
                json.writeAttribute("mandatory", (Object)prop.isMandatory());
                json.writeAttribute("readonly", (Object)prop.isReadonly());
                json.writeAttribute("notNull", (Object)prop.isNotNull());
                json.writeAttribute("min", (Object)prop.getMin());
                json.writeAttribute("max", (Object)prop.getMax());
                json.writeAttribute("collate", (Object)(prop.getCollate() != null ? prop.getCollate().getName() : "default"));
                if (prop instanceof OPropertyImpl && (custom2 = ((OPropertyImpl)prop).getCustomInternal()) != null && !custom2.isEmpty()) {
                    json.writeAttribute("custom", (Object)custom2);
                }
                json.endObject();
            }
            json.endCollection();
        }
        if (!(indexes = cls.getIndexes()).isEmpty()) {
            json.beginCollection("indexes");
            for (OIndex index : indexes) {
                json.beginObject();
                json.writeAttribute("name", (Object)index.getName());
                json.writeAttribute("type", (Object)index.getType());
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition != null && !indexDefinition.getFields().isEmpty()) {
                    json.writeAttribute("fields", (Object)indexDefinition.getFields());
                }
                json.endObject();
            }
            json.endCollection();
        }
        json.endObject();
    }

    @Override
    public void configure(OServer server) {
        super.configure(server);
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: database/<database>");
        iRequest.data.commandInfo = "Database info";
        iRequest.data.commandDetail = urlParts[1];
        this.exec(iRequest, iResponse, urlParts);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec(OHttpRequest iRequest, OHttpResponse iResponse, String[] urlParts) throws InterruptedException, IOException {
        ODatabaseDocumentTx db = null;
        try {
            if (urlParts.length > 2) {
                this.server.getDatabasePool().acquire(urlParts[1], urlParts[2], urlParts[3]);
            } else {
                db = this.getProfiledDatabaseInstance(iRequest);
            }
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer);
            json.beginObject();
            json.beginObject((Object)"server");
            json.writeAttribute("version", (Object)"1.7.1");
            if (OConstants.getBuildNumber() != null) {
                json.writeAttribute("build", (Object)OConstants.getBuildNumber());
            }
            json.writeAttribute("osName", (Object)System.getProperty("os.name"));
            json.writeAttribute("osVersion", (Object)System.getProperty("os.version"));
            json.writeAttribute("osArch", (Object)System.getProperty("os.arch"));
            json.writeAttribute("javaVendor", (Object)System.getProperty("java.vm.vendor"));
            json.writeAttribute("javaVersion", (Object)System.getProperty("java.vm.version"));
            json.endObject();
            if (db.getMetadata().getSchema().getClasses() != null) {
                json.beginCollection("classes");
                ArrayList<String> classNames = new ArrayList<String>();
                for (OClass cls : db.getMetadata().getSchema().getClasses()) {
                    classNames.add(cls.getName());
                }
                Collections.sort(classNames);
                for (String className : classNames) {
                    OClass cls = db.getMetadata().getSchema().getClass(className);
                    try {
                        OServerCommandGetDatabase.exportClass(db, json, cls);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on exporting class '" + cls + "'", (Throwable)e, new Object[0]);
                    }
                }
                json.endCollection();
            }
            if (db.getStorage() instanceof OStorageLocal) {
                json.beginCollection("dataSegments");
                for (ODataLocal data : ((OStorageLocal)db.getStorage()).getDataSegments()) {
                    if (data == null) continue;
                    json.beginObject();
                    json.writeAttribute("id", (Object)data.getId());
                    json.writeAttribute("name", (Object)data.getName());
                    json.writeAttribute("size", (Object)data.getSize());
                    json.writeAttribute("filled", (Object)data.getFilledUpTo());
                    json.writeAttribute("maxSize", (Object)data.getConfig().maxSize);
                    json.writeAttribute("files", (Object)Arrays.toString(data.getConfig().infoFiles));
                    json.endObject();
                }
                json.endCollection();
            }
            if (db.getClusterNames() != null) {
                json.beginCollection("clusters");
                for (String clusterName : db.getClusterNames()) {
                    OCluster cluster = db.getStorage().getClusterById(db.getClusterIdByName(clusterName));
                    try {
                        json.beginObject();
                        json.writeAttribute("id", (Object)cluster.getId());
                        json.writeAttribute("name", (Object)clusterName);
                        json.writeAttribute("type", (Object)cluster.getType());
                        json.writeAttribute("records", (Object)(cluster.getEntries() - cluster.getTombstonesCount()));
                        if (cluster instanceof OClusterLocal) {
                            json.writeAttribute("size", (Object)((OClusterLocal)cluster).getSize());
                            json.writeAttribute("filled", (Object)((OClusterLocal)cluster).getFilledUpTo());
                            json.writeAttribute("maxSize", (Object)((OClusterLocal)cluster).getConfig().getMaxSize());
                            json.writeAttribute("files", (Object)Arrays.toString(((OClusterLocal)cluster).getConfig().getInfoFiles()));
                        } else {
                            json.writeAttribute("size", (Object)"-");
                            json.writeAttribute("filled", (Object)"-");
                            json.writeAttribute("maxSize", (Object)"-");
                            json.writeAttribute("files", (Object)"-");
                        }
                    }
                    catch (Exception e) {
                        json.writeAttribute("records", (Object)"? (Unauthorized)");
                    }
                    json.endObject();
                }
                json.endCollection();
            }
            if (db.getStorage() instanceof OStorageLocal) {
                json.beginCollection("txSegment");
                OTxSegment txSegment = ((OStorageLocal)db.getStorage()).getTxManager().getTxSegment();
                json.beginObject();
                json.writeAttribute("size", (Object)txSegment.getSize());
                json.writeAttribute("filled", (Object)txSegment.getFilledUpTo());
                json.writeAttribute("maxSize", (Object)txSegment.getConfig().maxSize);
                json.writeAttribute("file", (Object)txSegment.getConfig().path);
                json.endObject();
                json.endCollection();
            }
            if (db.getUser() != null) {
                json.writeAttribute("currentUser", (Object)db.getUser().getName());
                json.beginCollection("users");
                for (ODocument doc : db.getMetadata().getSecurity().getAllUsers()) {
                    OUser user = new OUser(doc);
                    json.beginObject();
                    json.writeAttribute("name", (Object)user.getName());
                    json.writeAttribute("roles", (Object)(user.getRoles() != null ? Arrays.toString(user.getRoles().toArray()) : "null"));
                    json.endObject();
                }
                json.endCollection();
                json.beginCollection("roles");
                for (ODocument doc : db.getMetadata().getSecurity().getAllRoles()) {
                    ORole role = new ORole(doc);
                    json.beginObject();
                    json.writeAttribute("name", (Object)role.getName());
                    json.writeAttribute("mode", (Object)role.getMode().toString());
                    json.beginCollection("rules");
                    if (role.getRules() != null) {
                        for (Map.Entry rule : role.getRules().entrySet()) {
                            json.beginObject();
                            json.writeAttribute("name", rule.getKey());
                            json.writeAttribute("create", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_CREATE));
                            json.writeAttribute("read", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_READ));
                            json.writeAttribute("update", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_UPDATE));
                            json.writeAttribute("delete", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_DELETE));
                            json.endObject();
                        }
                    }
                    json.endCollection();
                    json.endObject();
                }
                json.endCollection();
            }
            OIndexManagerProxy idxManager = db.getMetadata().getIndexManager();
            json.beginCollection("indexes");
            for (OIndex index : idxManager.getIndexes()) {
                json.beginObject();
                try {
                    json.writeAttribute("name", (Object)index.getName());
                    json.writeAttribute("configuration", (Object)index.getConfiguration());
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Cannot serialize index configuration", (Throwable)e, new Object[0]);
                }
                json.endObject();
            }
            json.endCollection();
            json.beginObject((Object)"config");
            json.beginCollection("values");
            json.writeObjects(null, (Object[][])new Object[][]{{"name", "dateFormat", "value", db.getStorage().getConfiguration().dateFormat}, {"name", "dateTimeFormat", "value", db.getStorage().getConfiguration().dateTimeFormat}, {"name", "localeCountry", "value", db.getStorage().getConfiguration().getLocaleCountry()}, {"name", "localeLanguage", "value", db.getStorage().getConfiguration().getLocaleLanguage()}, {"name", "charSet", "value", db.getStorage().getConfiguration().getCharset()}, {"name", "timezone", "value", db.getStorage().getConfiguration().getTimeZone().getID()}, {"name", "definitionVersion", "value", db.getStorage().getConfiguration().version}, {"name", "clusterSelection", "value", db.getStorage().getConfiguration().getClusterSelection()}, {"name", "minimumClusters", "value", db.getStorage().getConfiguration().getMinimumClusters()}});
            json.endCollection();
            json.beginCollection("properties");
            if (db.getStorage().getConfiguration().properties != null) {
                for (OStorageEntryConfiguration entry : db.getStorage().getConfiguration().properties) {
                    if (entry == null) continue;
                    json.beginObject();
                    json.writeAttribute("name", (Object)entry.name);
                    json.writeAttribute("value", (Object)entry.value);
                    json.endObject();
                }
            }
            json.endCollection();
            json.endObject();
            json.endObject();
            json.flush();
            iResponse.send(200, "OK", "application/json", buffer.toString(), null);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

