/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import java.io.IOException;
import java.net.InetSocketAddress;

public class OClientConnection {
    public final int id;
    public volatile ONetworkProtocol protocol;
    public final long since;
    public volatile ODatabaseDocumentTx database;
    public volatile ODatabaseRaw rawDatabase;
    public volatile OServerUserConfiguration serverUser;
    public ONetworkProtocolData data = new ONetworkProtocolData();

    public OClientConnection(int id, ONetworkProtocol protocol) throws IOException {
        this.id = id;
        this.protocol = protocol;
        this.since = System.currentTimeMillis();
    }

    public void close() {
        if (this.database != null) {
            if (!this.database.isClosed()) {
                this.database.close();
            }
            this.database = null;
        }
    }

    public String toString() {
        return "OClientConnection [id=" + this.id + ", source=" + (this.protocol != null && this.protocol.getChannel() != null && this.protocol.getChannel().socket != null ? this.protocol.getChannel().socket.getRemoteSocketAddress() : "?") + ", since=" + this.since + "]";
    }

    public String getRemoteAddress() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.protocol.getChannel().socket.getRemoteSocketAddress();
        return remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OClientConnection other = (OClientConnection)obj;
        return this.id == other.id;
    }

    public OChannelBinary getChannel() {
        return (OChannelBinary)this.protocol.getChannel();
    }

    public ONetworkProtocol getProtocol() {
        return this.protocol;
    }
}

