/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.ODistributedCommand;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.task.OTxTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ODistributedStorage
implements OStorage,
OFreezableStorage,
OAutoshardedStorage {
    protected final OServer serverInstance;
    protected final ODistributedServerManager dManager;
    protected final OStorageEmbedded wrapped;
    protected final TimerTask purgeDeletedRecordsTask;
    protected final ConcurrentHashMap<ORecordId, OPair<Long, ORecordVersion>> deletedRecords = new ConcurrentHashMap();
    protected final AtomicLong lastOperationId = new AtomicLong();

    public ODistributedStorage(OServer iServer, final OStorageEmbedded wrapped) {
        this.serverInstance = iServer;
        this.dManager = iServer.getDistributedManager();
        this.wrapped = wrapped;
        ODistributedServerLog.info((Object)this, this.dManager != null ? this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Installing distributed storage on database '%s'", wrapped.getName());
        this.purgeDeletedRecordsTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<ORecordId, OPair<Long, ORecordVersion>>> it = ODistributedStorage.this.deletedRecords.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<ORecordId, OPair<Long, ORecordVersion>> entry = it.next();
                    try {
                        OStorageOperationResult result;
                        ORecordId rid = entry.getKey();
                        long time = (Long)entry.getValue().getKey();
                        ORecordVersion version = (ORecordVersion)entry.getValue().getValue();
                        if (now - time <= OGlobalConfiguration.DISTRIBUTED_ASYNCH_RESPONSES_TIMEOUT.getValueAsLong() * 2L || (result = wrapped.deleteRecord(rid, version, 0, null)) != null && ((Boolean)result.getResult()).booleanValue()) continue;
                        OLogManager.instance().error((Object)this, "Error on deleting record %s v.%s", new Object[]{rid, version});
                    }
                    finally {
                        it.remove();
                    }
                }
            }
        };
        Orient.instance().getTimer().schedule(this.purgeDeletedRecordsTask, OGlobalConfiguration.DISTRIBUTED_PURGE_RESPONSES_TIMER_DELAY.getValueAsLong(), OGlobalConfiguration.DISTRIBUTED_PURGE_RESPONSES_TIMER_DELAY.getValueAsLong());
    }

    public boolean isDistributed() {
        return true;
    }

    public Class<? extends OSBTreeCollectionManager> getCollectionManagerClass() {
        return this.wrapped.getCollectionManagerClass();
    }

    public Object command(OCommandRequestText iCommand) {
        ArrayList<String> servers = (ArrayList<String>)iCommand.getContext().getVariable("servers");
        if (servers == null) {
            servers = new ArrayList<String>();
            iCommand.getContext().setVariable("servers", servers);
        }
        servers.add(this.dManager.getLocalNodeName());
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.command(iCommand);
        }
        ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
        if (!dbCfg.isReplicationActive(null, this.dManager.getLocalNodeName())) {
            return this.wrapped.command(iCommand);
        }
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse((OCommandRequest)iCommand);
        OCommandExecutor exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        try {
            Object result;
            OSQLCommandTask task = new OSQLCommandTask(iCommand);
            boolean replicated = false;
            if (OScenarioThreadLocal.INSTANCE.get() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED && exec instanceof OCommandDistributedReplicateRequest) {
                replicated = ((OCommandDistributedReplicateRequest)exec).isReplicated();
            }
            Set involvedClusters = exec.getInvolvedClusters();
            if (replicated) {
                task.setResultStrategy(OAbstractRemoteTask.RESULT_STRATEGY.ANY);
                Collection<String> nodes = dbCfg.getServers(involvedClusters);
                if (iCommand instanceof ODistributedCommand) {
                    nodes.removeAll(((ODistributedCommand)iCommand).nodesToExclude());
                }
                result = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, task, ODistributedRequest.EXECUTION_MODE.RESPONSE);
            } else {
                task.setResultStrategy(OAbstractRemoteTask.RESULT_STRATEGY.UNION);
                Collection<String> nodes = dbCfg.getOneServerPerCluster(involvedClusters, this.dManager.getLocalNodeName());
                if (iCommand instanceof ODistributedCommand) {
                    nodes.removeAll(((ODistributedCommand)iCommand).nodesToExclude());
                }
                boolean executeLocally = false;
                if (exec.isIdempotent()) {
                    int maxReadQuorum;
                    if (involvedClusters.isEmpty()) {
                        maxReadQuorum = dbCfg.getReadQuorum(null);
                    } else {
                        maxReadQuorum = 0;
                        for (String cl : involvedClusters) {
                            maxReadQuorum = Math.max(maxReadQuorum, dbCfg.getReadQuorum(cl));
                        }
                    }
                    if (nodes.size() == 1 && nodes.iterator().next().equals(this.dManager.getLocalNodeName()) && maxReadQuorum <= 1) {
                        executeLocally = true;
                    }
                } else if (nodes.size() == 1 && nodes.iterator().next().equals(this.dManager.getLocalNodeName())) {
                    executeLocally = true;
                }
                if (executeLocally) {
                    return this.wrapped.command(iCommand);
                }
                result = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, task, ODistributedRequest.EXECUTION_MODE.RESPONSE);
                if (result instanceof Map && executor instanceof OCommandExecutorSQLDelegate && ((OCommandExecutorSQLDelegate)executor).getDelegate() instanceof OCommandExecutorSQLSelect) {
                    OCommandExecutorSQLSelect cmd = (OCommandExecutorSQLSelect)((OCommandExecutorSQLDelegate)executor).getDelegate();
                    if (((Map)result).size() == 1) {
                        result = ((Map)result).values().iterator().next();
                    } else if (cmd.isAnyFunctionAggregates()) {
                        Map proj = cmd.getProjections();
                        ArrayList<ODocument> list = new ArrayList<ODocument>();
                        ODocument doc = new ODocument();
                        list.add(doc);
                        boolean hasNonAggregates = false;
                        for (Map.Entry p : proj.entrySet()) {
                            if (p.getValue() instanceof OSQLFunctionRuntime) continue;
                            hasNonAggregates = true;
                            break;
                        }
                        if (hasNonAggregates) {
                            for (Map.Entry entry : ((Map)result).entrySet()) {
                                List resultSet = (List)entry.getValue();
                                for (Object r : resultSet) {
                                    if (!(r instanceof ODocument)) continue;
                                    ODocument d = (ODocument)r;
                                    for (Map.Entry p : proj.entrySet()) {
                                        if (p.getValue() instanceof OSQLFunctionRuntime) continue;
                                        doc.field((String)p.getKey(), p.getValue());
                                    }
                                }
                            }
                        }
                        ArrayList<Object> toMerge = new ArrayList<Object>();
                        for (Map.Entry p : proj.entrySet()) {
                            if (!(p.getValue() instanceof OSQLFunctionRuntime)) continue;
                            OSQLFunctionRuntime f = (OSQLFunctionRuntime)p.getValue();
                            toMerge.clear();
                            for (Map.Entry entry : ((Map)result).entrySet()) {
                                List resultSet = (List)entry.getValue();
                                for (Object r : resultSet) {
                                    if (!(r instanceof ODocument)) continue;
                                    ODocument d = (ODocument)r;
                                    toMerge.add(d.rawField((String)p.getKey()));
                                }
                            }
                            doc.field((String)p.getKey(), f.getFunction().mergeDistributedResult(toMerge));
                        }
                        result = list;
                    } else {
                        HashSet set = new HashSet();
                        for (Map.Entry entry : ((Map)result).entrySet()) {
                            Object nodeResult = entry.getValue();
                            if (nodeResult instanceof Collection) {
                                set.addAll((Collection)nodeResult);
                                continue;
                            }
                            if (!(nodeResult instanceof Exception)) continue;
                            throw (Exception)nodeResult;
                        }
                        result = new ArrayList(set);
                    }
                }
            }
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed COMMAND", (Throwable)result);
            }
            return result;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route COMMAND operation to the distributed node", e, new Object[0]);
            return null;
        }
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, ORecordId iRecordId, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<OClusterPosition> iCallback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.createRecord(iDataSegmentId, iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
        }
        Object result = null;
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            if (!dbCfg.isReplicationActive(clusterName, this.dManager.getLocalNodeName()) && dbCfg.getServers(clusterName) == null) {
                return this.wrapped.createRecord(iDataSegmentId, iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
            }
            Collection<String> nodes = dbCfg.getServers(clusterName);
            result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new OCreateRecordTask(iRecordId, iContent, iRecordVersion, iRecordType), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed CREATE_RECORD", (Throwable)result);
            }
            OPlaceholder p = (OPlaceholder)result;
            iRecordId.copyFrom(p.getIdentity());
            return new OStorageOperationResult((Object)new OPhysicalPosition(p.getIdentity().getClusterPosition(), p.getRecordVersion()));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route CREATE_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRecordId, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        if (this.deletedRecords.get(iRecordId) != null) {
            throw new ORecordNotFoundException("Record " + iRecordId + " was not found");
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            Collection<String> serverList = dbCfg.getServers(clusterName);
            if (!dbCfg.isReplicationActive(clusterName, this.dManager.getLocalNodeName()) && serverList == null) {
                return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
            }
            if (serverList.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName) <= 1) {
                return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
            }
            Collection<String> nodes = dbCfg.getServers(clusterName);
            Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new OReadRecordTask(iRecordId), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed READ_RECORD", (Throwable)result);
            }
            return new OStorageOperationResult((Object)((ORawBuffer)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route READ_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRecordId, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        if (this.deletedRecords.get(iRecordId) != null) {
            throw new ORecordNotFoundException("Record " + iRecordId + " was not found");
        }
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.updateRecord(iRecordId, iContent, iVersion, iRecordType, iMode, iCallback);
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            if (!dbCfg.isReplicationActive(clusterName, this.dManager.getLocalNodeName()) && dbCfg.getServers(clusterName) == null) {
                return this.wrapped.updateRecord(iRecordId, iContent, iVersion, iRecordType, iMode, iCallback);
            }
            OStorageOperationResult<ORawBuffer> previousContent = this.readRecord(iRecordId, null, false, null, false, OStorage.LOCKING_STRATEGY.DEFAULT);
            Collection<String> nodes = dbCfg.getServers(clusterName);
            Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new OUpdateRecordTask(iRecordId, ((ORawBuffer)previousContent.getResult()).getBuffer(), ((ORawBuffer)previousContent.getResult()).version, iContent, iVersion), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed UPDATE_RECORD", (Throwable)result);
            }
            return new OStorageOperationResult((Object)((ORecordVersion)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route UPDATE_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRecordId, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            if (!dbCfg.isReplicationActive(clusterName, this.dManager.getLocalNodeName()) && dbCfg.getServers(clusterName) == null) {
                return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
            }
            OStorageOperationResult<ORawBuffer> previousContent = this.readRecord(iRecordId, null, false, null, false, OStorage.LOCKING_STRATEGY.DEFAULT);
            Collection<String> nodes = dbCfg.getServers(clusterName);
            Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new ODeleteRecordTask(iRecordId, iVersion), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed DELETE_RECORD", (Throwable)result);
            }
            return new OStorageOperationResult((Object)true);
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route DELETE_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        throw new UnsupportedOperationException();
    }

    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        return this.wrapped.updateReplica(dataSegmentId, rid, content, recordVersion, recordType);
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.wrapped.getRecordMetadata(rid);
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.wrapped.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    public OCluster getClusterByName(String iName) {
        return this.wrapped.getClusterByName(iName);
    }

    public <T> T removeResource(String iName) {
        return (T)this.wrapped.removeResource(iName);
    }

    public <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.wrapped.getResource(iName, iCallback);
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    public void create(Map<String, Object> iProperties) {
        this.wrapped.create(iProperties);
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public void reload() {
        this.wrapped.reload();
    }

    public void delete() {
        this.wrapped.delete();
    }

    public void close() {
        this.wrapped.close();
    }

    public void close(boolean iForce, boolean onDelete) {
        this.wrapped.close(iForce, false);
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public OLevel2RecordCache getLevel2Cache() {
        return this.wrapped.getLevel2Cache();
    }

    public void commit(OTransaction iTx, Runnable callback) {
        block22: {
            if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
                this.wrapped.commit(iTx, callback);
            } else {
                try {
                    ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
                    if (!dbCfg.isReplicationActive(null, this.dManager.getLocalNodeName())) {
                        this.wrapped.commit(iTx, callback);
                        break block22;
                    }
                    OTxTask txTask = new OTxTask();
                    HashSet<String> involvedClusters = new HashSet<String>();
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                        for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                            tmpEntries.add(txEntry);
                        }
                        iTx.clearRecordEntries();
                        block9: for (ORecordOperation op : tmpEntries) {
                            OAbstractRecordReplicatedTask task;
                            ORecordInternal record = op.getRecord();
                            ORecordId rid = (ORecordId)op.record.getIdentity();
                            switch (op.type) {
                                case 3: {
                                    task = new OCreateRecordTask(rid, record.toStream(), record.getRecordVersion(), record.getRecordType());
                                    break;
                                }
                                case 1: {
                                    OStorageOperationResult previousContent = this.wrapped.readRecord(rid, null, false, null, false, OStorage.LOCKING_STRATEGY.DEFAULT);
                                    if (previousContent.getResult() == null) {
                                        throw new OTransactionException("Cannot update record '" + rid + "' because has been deleted");
                                    }
                                    task = new OUpdateRecordTask(rid, ((ORawBuffer)previousContent.getResult()).getBuffer(), ((ORawBuffer)previousContent.getResult()).version, record.toStream(), record.getRecordVersion());
                                    break;
                                }
                                case 2: {
                                    task = new ODeleteRecordTask(rid, record.getRecordVersion());
                                    break;
                                }
                                default: {
                                    continue block9;
                                }
                            }
                            involvedClusters.add(this.getClusterNameByRID(rid));
                            txTask.add(task);
                        }
                    }
                    Collection<String> nodes = dbCfg.getServers(involvedClusters);
                    Object result = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, txTask, ODistributedRequest.EXECUTION_MODE.RESPONSE);
                    if (result instanceof List) {
                        List list = (List)result;
                        for (int i = 0; i < txTask.getTasks().size(); ++i) {
                            OAbstractRecordReplicatedTask t;
                            Object o = list.get(i);
                            OAbstractRecordReplicatedTask task = txTask.getTasks().get(i);
                            if (task instanceof OCreateRecordTask) {
                                t = (OCreateRecordTask)task;
                                t.getRid().copyFrom(((OPlaceholder)o).getIdentity());
                                t.getVersion().copyFrom(((OPlaceholder)o).getRecordVersion());
                                continue;
                            }
                            if (task instanceof OUpdateRecordTask) {
                                t = (OUpdateRecordTask)task;
                                t.getVersion().copyFrom((ORecordVersion)o);
                                continue;
                            }
                            if (!(task instanceof ODeleteRecordTask)) continue;
                        }
                        break block22;
                    }
                    if (result instanceof Throwable) {
                        if (ODistributedServerLog.isDebugEnabled()) {
                            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "distributed transaction error: %s", result, result.toString());
                        }
                        if (result instanceof OTransactionException || result instanceof ONeedRetryException) {
                            throw (RuntimeException)result;
                        }
                        throw new OTransactionException("Error on committing distributed transaction", (Throwable)result);
                    }
                    if (ODistributedServerLog.isDebugEnabled()) {
                        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "distributed transaction error, received unknown response type: %s", result);
                    }
                    throw new OTransactionException("Error on committing distributed transaction, received unknown response type " + result);
                }
                catch (Exception e) {
                    this.handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
                }
            }
        }
    }

    public void rollback(OTransaction iTx) {
        this.wrapped.rollback(iTx);
    }

    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public int getClusters() {
        return this.wrapped.getClusters();
    }

    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterType, iClusterName, iLocation, iDataSegmentName, false, iParameters);
    }

    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterType, iClusterName, iRequestedId, iLocation, iDataSegmentName, forceListBased, iParameters);
    }

    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.wrapped.dropCluster(iClusterName, iTruncate);
    }

    public boolean dropCluster(int iId, boolean iTruncate) {
        return this.wrapped.dropCluster(iId, iTruncate);
    }

    public int addDataSegment(String iDataSegmentName) {
        return this.wrapped.addDataSegment(iDataSegmentName);
    }

    public int addDataSegment(String iSegmentName, String iDirectory) {
        return this.wrapped.addDataSegment(iSegmentName, iDirectory);
    }

    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.wrapped.count(iClusterId, countTombstones);
    }

    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        return this.wrapped.count(iClusterIds, countTombstones);
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public long countRecords() {
        return this.wrapped.countRecords();
    }

    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    public String getClusterTypeByName(String iClusterName) {
        return this.wrapped.getClusterTypeByName(iClusterName);
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String getURL() {
        return this.wrapped.getURL();
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public void synch() {
        this.wrapped.synch();
    }

    public int getUsers() {
        return this.wrapped.getUsers();
    }

    public int addUser() {
        return this.wrapped.addUser();
    }

    public int removeUser() {
        return this.wrapped.removeUser();
    }

    public OClusterPosition[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    public <V> V callInRecordLock(Callable<V> iCallable, ORID rid, boolean iExclusiveLock) {
        return (V)this.wrapped.callInRecordLock(iCallable, rid, iExclusiveLock);
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        return this.wrapped.getDataSegmentById(iDataSegmentId);
    }

    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.wrapped.getDataSegmentIdByName(iDataSegmentName);
    }

    public boolean dropDataSegment(String iName) {
        return this.wrapped.dropDataSegment(iName);
    }

    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.wrapped.checkForClusterPermissions(iClusterName);
    }

    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.higherPhysicalPositions(currentClusterId, entry);
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.floorPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.lowerPhysicalPositions(currentClusterId, entry);
    }

    public OSharedResourceAdaptiveExternal getLock() {
        return this.wrapped.getLock();
    }

    public OStorage getUnderlying() {
        return this.wrapped;
    }

    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.wrapped.getComponentsFactory();
    }

    public String getType() {
        return "distributed";
    }

    public void freeze(boolean throwException) {
        this.getFreezableStorage().freeze(throwException);
    }

    public void release() {
        this.getFreezableStorage().release();
    }

    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        this.wrapped.backup(out, options, callable, iListener, compressionLevel, bufferSize);
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.wrapped.restore(in, options, callable, iListener);
    }

    public long getLastOperationId() {
        return this.lastOperationId.get();
    }

    public void setLastOperationId(long lastOperationId) {
        this.lastOperationId.set(lastOperationId);
    }

    public void pushDeletedRecord(ORecordId rid, ORecordVersion version) {
        this.deletedRecords.putIfAbsent(rid, (OPair<Long, ORecordVersion>)new OPair((Comparable)Long.valueOf(System.currentTimeMillis()), (Object)version));
    }

    public boolean resurrectDeletedRecord(ORecordId rid) {
        return this.deletedRecords.remove(rid) != null;
    }

    public String getClusterNameByRID(ORecordId iRid) {
        OCluster cluster = this.getClusterById(iRid.clusterId);
        return cluster != null ? cluster.getName() : "*";
    }

    public String getStorageId() {
        return this.dManager.getLocalNodeName() + "." + this.getName();
    }

    public String getNodeId() {
        return this.dManager.getLocalNodeName();
    }

    protected void handleDistributedException(String iMessage, Exception e, Object ... iParams) {
        OLogManager.instance().error((Object)this, iMessage, (Throwable)e, iParams);
        Throwable t = e.getCause();
        if (t != null) {
            if (t instanceof OException) {
                throw (OException)t;
            }
            if (t.getCause() instanceof OException) {
                throw (OException)t.getCause();
            }
        }
        throw new OStorageException(String.format(iMessage, iParams), (Throwable)e);
    }

    private OFreezableStorage getFreezableStorage() {
        if (this.wrapped instanceof OFreezableStorage) {
            return (OFreezableStorage)this.wrapped;
        }
        throw new UnsupportedOperationException("Storage engine " + this.wrapped.getType() + " does not support freeze operation");
    }
}

