/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OFixTxTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class OTxTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    private List<OAbstractRecordReplicatedTask> tasks = new ArrayList<OAbstractRecordReplicatedTask>();

    public void add(OAbstractRecordReplicatedTask iTask) {
        this.tasks.add(iTask);
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "committing transaction against db=%s...", database.getName());
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)database);
        try {
            database.begin();
            ArrayList<Object> results = new ArrayList<Object>();
            for (OAbstractRecordReplicatedTask task : this.tasks) {
                results.add(task.execute(iServer, iManager, database));
            }
            database.commit();
            for (int i = 0; i < results.size(); ++i) {
                OAbstractRecordReplicatedTask t;
                Object o = results.get(i);
                OAbstractRecordReplicatedTask task = this.tasks.get(i);
                if (task instanceof OCreateRecordTask) {
                    t = (OCreateRecordTask)task;
                    results.set(i, new OPlaceholder(task.getRid(), task.getVersion()));
                    continue;
                }
                if (task instanceof OUpdateRecordTask) {
                    t = (OUpdateRecordTask)task;
                    results.set(i, task.getVersion());
                    continue;
                }
                if (!(task instanceof ODeleteRecordTask)) continue;
            }
            return results;
        }
        catch (ONeedRetryException e) {
            return e;
        }
        catch (OTransactionException e) {
            return e;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on distributed transaction commit", (Throwable)e, new Object[0]);
            return e;
        }
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.WRITE;
    }

    @Override
    public OFixTxTask getFixTask(ODistributedRequest iRequest, Object iBadResponse, Object iGoodResponse) {
        if (!(iBadResponse instanceof List)) {
            ODistributedServerLog.debug((Object)this, this.getNodeSource(), null, ODistributedServerLog.DIRECTION.NONE, "error on creating fix-task for request: '%s' because bad response is not expected type: %s", iRequest, iBadResponse);
            return null;
        }
        if (!(iGoodResponse instanceof List)) {
            ODistributedServerLog.debug((Object)this, this.getNodeSource(), null, ODistributedServerLog.DIRECTION.NONE, "error on creating fix-task for request: '%s' because good response is not expected type: %s", iRequest, iBadResponse);
            return null;
        }
        OFixTxTask fixTask = new OFixTxTask();
        for (int i = 0; i < this.tasks.size(); ++i) {
            OAbstractRecordReplicatedTask t = this.tasks.get(i);
            OAbstractRemoteTask task = t.getFixTask(iRequest, ((List)iBadResponse).get(i), ((List)iGoodResponse).get(i));
            if (task == null) continue;
            fixTask.add(task);
        }
        return fixTask;
    }

    @Override
    public OAbstractRemoteTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        if (!(iBadResponse instanceof List)) {
            ODistributedServerLog.debug((Object)this, this.getNodeSource(), null, ODistributedServerLog.DIRECTION.NONE, "error on creating undo-task for request: '%s' because bad response is not expected type: %s", iRequest, iBadResponse);
            return null;
        }
        OFixTxTask fixTask = new OFixTxTask();
        for (int i = 0; i < this.tasks.size(); ++i) {
            OAbstractRecordReplicatedTask t = this.tasks.get(i);
            fixTask.add(t.getUndoTask(iRequest, ((List)iBadResponse).get(i)));
        }
        return fixTask;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.tasks.size());
        for (OAbstractRecordReplicatedTask task : this.tasks) {
            out.writeObject(task);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.tasks.add((OAbstractRecordReplicatedTask)in.readObject());
        }
    }

    @Override
    public String getName() {
        return "tx";
    }

    @Override
    public String getPayload() {
        return null;
    }

    public List<OAbstractRecordReplicatedTask> getTasks() {
        return this.tasks;
    }
}

