/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import java.io.IOException;
import java.net.Socket;
import java.util.Set;
import java.util.logging.Level;

public abstract class OBinaryNetworkProtocolAbstract
extends ONetworkProtocol {
    protected final Level logClientExceptions = Level.parse(OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL.getValueAsString());
    protected final boolean logClientFullStackTrace = OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE.getValueAsBoolean();
    protected OChannelBinaryServer channel;
    protected int requestType;
    protected int clientTxId;
    protected boolean okSent;

    public OBinaryNetworkProtocolAbstract(String iThreadName) {
        super(Orient.instance().getThreadGroup(), iThreadName);
    }

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        this.server = iServer;
        this.channel = new OChannelBinaryServer(iSocket, iConfig);
    }

    @Override
    public int getVersion() {
        return 21;
    }

    public void shutdown() {
        this.channel.close();
    }

    @Override
    public OChannel getChannel() {
        return this.channel;
    }

    public void writeIdentifiable(OIdentifiable o) throws IOException {
        if (o == null) {
            this.channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            this.channel.writeShort((short)-3);
            this.channel.writeRID((ORID)o);
        } else {
            this.writeRecord((ORecordInternal)o.getRecord());
        }
    }

    @Override
    public String getType() {
        return "binary";
    }

    protected abstract boolean executeRequest() throws IOException;

    protected abstract void sendError(int var1, Throwable var2) throws IOException;

    protected void onBeforeRequest() throws IOException {
    }

    protected void onAfterRequest() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        this.requestType = -1;
        this.clientTxId = 0;
        this.okSent = false;
        long timer = 0L;
        try {
            this.requestType = this.channel.readByte();
            this.clientTxId = this.channel.readInt();
            timer = Orient.instance().getProfiler().startChrono();
            this.onBeforeRequest();
            try {
                if (!this.executeRequest()) {
                    OLogManager.instance().error((Object)this, "Request not supported. Code: " + this.requestType, new Object[0]);
                    this.channel.clearInput();
                    this.sendErrorOrDropConnection(this.clientTxId, (Throwable)new ONetworkProtocolException("Request not supported. Code: " + this.requestType));
                }
            }
            finally {
                this.onAfterRequest();
            }
        }
        catch (IOException e) {
            this.handleConnectionError(this.channel, e);
            this.sendShutdown();
        }
        catch (OException e) {
            this.sendErrorOrDropConnection(this.clientTxId, e);
        }
        catch (RuntimeException e) {
            this.sendErrorOrDropConnection(this.clientTxId, e);
        }
        catch (Throwable t) {
            this.sendErrorOrDropConnection(this.clientTxId, t);
        }
        finally {
            Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        }
    }

    protected void sendOk(int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
        this.okSent = true;
    }

    protected void sendErrorOrDropConnection(int iClientTxId, Throwable t) throws IOException {
        if (this.okSent) {
            this.handleConnectionError(this.channel, t);
            this.sendShutdown();
        } else {
            this.sendError(iClientTxId, t);
        }
    }

    protected void checkStorageExistence(String iDatabaseName) {
        for (OStorage stg : Orient.instance().getStorages()) {
            if (stg instanceof OStorageProxy || !stg.getName().equalsIgnoreCase(iDatabaseName) || !stg.exists()) continue;
            throw new ODatabaseException("Database named '" + iDatabaseName + "' already exists: " + stg);
        }
    }

    protected ODatabaseDocumentTx createDatabase(ODatabaseDocumentTx iDatabase, String dbUser, String dbPasswd) {
        if (iDatabase.exists()) {
            throw new ODatabaseException("Database '" + iDatabase.getURL() + "' already exists");
        }
        iDatabase.create();
        if (dbUser != null) {
            OUser oUser = iDatabase.getMetadata().getSecurity().getUser(dbUser);
            if (oUser == null) {
                iDatabase.getMetadata().getSecurity().createUser(dbUser, dbPasswd, new String[]{"admin"});
            } else {
                oUser.setPassword(dbPasswd);
                oUser.save();
            }
        }
        OLogManager.instance().info((Object)this, "Created database '%s' of type '%s'", new Object[]{iDatabase.getName(), iDatabase.getStorage() instanceof OStorageLocalAbstract ? iDatabase.getStorage().getType() : "memory"});
        return iDatabase;
    }

    protected ODatabaseDocumentTx getDatabaseInstance(String dbName, String dbType, String storageType) {
        String path;
        OStorage stg = Orient.instance().getStorage(dbName);
        if (stg != null) {
            path = stg.getURL();
        } else if (storageType.equals("local") || storageType.equals("plocal")) {
            path = this.server.getConfiguration().getStoragePath(dbName);
            if (path == null) {
                path = storageType + ":" + this.server.getDatabaseDirectory() + "/" + dbName;
            }
        } else if (storageType.equals("memory")) {
            path = storageType + ":" + dbName;
        } else {
            throw new IllegalArgumentException("Cannot create database: storage mode '" + storageType + "' is not supported.");
        }
        return Orient.instance().getDatabaseFactory().createDatabase(dbType, path);
    }

    protected int deleteRecord(ODatabaseRecord iDatabase, ORID rid, ORecordVersion version) {
        try {
            ORecord record = rid.getRecord();
            if (record == null) {
                return 0;
            }
            iDatabase.delete(rid, version);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected int hideRecord(ODatabaseRecord iDatabase, ORID rid) {
        try {
            iDatabase.hide(rid);
            return 1;
        }
        catch (ORecordNotFoundException e) {
            return 0;
        }
    }

    protected int cleanOutRecord(ODatabaseRecord iDatabase, ORID rid, ORecordVersion version) {
        iDatabase.delete(rid, version);
        return 1;
    }

    protected ORecordInternal<?> createRecord(ODatabaseRecord iDatabase, ORecordId rid, byte[] buffer, byte recordType, int dataSegmentId) {
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        record.fill((ORID)rid, OVersionFactory.instance().createVersion(), buffer, true);
        if (dataSegmentId > 0) {
            record.setDataSegmentName(iDatabase.getDataSegmentNameById(dataSegmentId));
        }
        iDatabase.save((Object)record);
        return record;
    }

    protected ORecordVersion updateRecord(ODatabaseRecord iDatabase, ORecordId rid, byte[] buffer, ORecordVersion version, byte recordType) {
        ORecordInternal currentRecord;
        ORecordInternal newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        newRecord.fill((ORID)rid, version, buffer, true);
        if (newRecord instanceof ODocument) {
            currentRecord = (ORecordInternal)iDatabase.load((ORID)rid);
            if (currentRecord == null) {
                throw new ORecordNotFoundException(rid.toString());
            }
            ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
        } else {
            currentRecord = newRecord;
        }
        currentRecord.getRecordVersion().copyFrom(version);
        iDatabase.save((Object)currentRecord);
        if (currentRecord.getIdentity().toString().equals(iDatabase.getStorage().getConfiguration().indexMgrRecordId) && !iDatabase.getStatus().equals((Object)ODatabase.STATUS.IMPORTING)) {
            iDatabase.getMetadata().getIndexManager().reload();
        }
        return currentRecord.getRecordVersion();
    }

    protected void handleConnectionError(OChannelBinaryServer channel, Throwable e) {
        try {
            channel.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeRecord(ORecordInternal<?> iRecord) throws IOException {
        this.channel.writeShort((short)0);
        this.channel.writeByte(iRecord.getRecordType());
        this.channel.writeRID(iRecord.getIdentity());
        this.channel.writeVersion(iRecord.getRecordVersion());
        try {
            byte[] stream = iRecord.toStream();
            int realLength = stream.length;
            for (int i = stream.length - 1; i > -1 && stream[i] == 32; --i) {
                --realLength;
            }
            this.channel.writeBytes(stream, realLength);
        }
        catch (Exception e) {
            this.channel.writeBytes(null);
            String message = "Error on unmarshalling record " + iRecord.getIdentity().toString() + " (" + e + ")";
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw new OSerializationException(message, (Throwable)e);
        }
    }
}

