/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartBaseInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OHttpRequest {
    public final OContextConfiguration configuration;
    public final InputStream in;
    public final ONetworkProtocolData data;
    public final ONetworkProtocolHttpAbstract executor;
    public String authorization;
    public String sessionId;
    public String url;
    public Map<String, String> parameters;
    public String httpMethod;
    public String httpVersion;
    public String contentType;
    public String contentEncoding;
    public String content;
    public OHttpMultipartBaseInputStream multipartStream;
    public String boundary;
    public String databaseName;
    public boolean isMultipart;
    public String ifMatch;
    public String authentication;
    public boolean keepAlive = true;
    protected Map<String, String> headers;

    public OHttpRequest(ONetworkProtocolHttpAbstract iExecutor, InputStream iInStream, ONetworkProtocolData iData, OContextConfiguration iConfiguration) {
        this.executor = iExecutor;
        this.in = iInStream;
        this.data = iData;
        this.configuration = iConfiguration;
    }

    public String getUser() {
        return this.authorization != null ? this.authorization.substring(0, this.authorization.indexOf(":")) : null;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public String getParameter(String iName) {
        return this.parameters != null ? this.parameters.get(iName) : null;
    }

    public void addHeader(String h) {
        int pos;
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if ((pos = h.indexOf(58)) > -1) {
            this.headers.put(h.substring(0, pos).trim().toLowerCase(), h.substring(pos + 1).trim());
        }
    }

    public String getHeader(String iName) {
        return this.headers.get(iName.toLowerCase());
    }

    public Set<Map.Entry<String, String>> getHeaders() {
        return this.headers.entrySet();
    }

    public String getRemoteAddress() {
        if (this.data.caller != null) {
            return this.data.caller;
        }
        return ((InetSocketAddress)this.executor.channel.socket.getRemoteSocketAddress()).getAddress().getHostAddress();
    }

    public String getUrl() {
        return this.url;
    }
}

