/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OChunkedResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class OHttpResponse {
    public static final String JSON_FORMAT = "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments";
    public static final char[] URL_SEPARATOR = new char[]{'/'};
    public final String httpVersion;
    private final OutputStream out;
    public String headers;
    public String[] additionalHeaders;
    public String characterSet;
    public String contentType;
    public String serverInfo;
    public String sessionId;
    public String callbackFunction;
    public String contentEncoding;
    public boolean sendStarted = false;
    public boolean keepAlive = true;

    public OHttpResponse(OutputStream iOutStream, String iHttpVersion, String[] iAdditionalHeaders, String iResponseCharSet, String iServerInfo, String iSessionId, String iCallbackFunction, boolean iKeepAlive) {
        this.out = iOutStream;
        this.httpVersion = iHttpVersion;
        this.additionalHeaders = iAdditionalHeaders;
        this.characterSet = iResponseCharSet;
        this.serverInfo = iServerInfo;
        this.sessionId = iSessionId;
        this.callbackFunction = iCallbackFunction;
        this.keepAlive = iKeepAlive;
    }

    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        this.send(iCode, iReason, iContentType, iContent, iHeaders, true);
    }

    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders, boolean iKeepAlive) throws IOException {
        String contentType;
        String content;
        if (this.sendStarted) {
            return;
        }
        this.sendStarted = true;
        if (this.callbackFunction != null) {
            content = this.callbackFunction + "(" + iContent + ")";
            contentType = "text/javascript";
        } else {
            content = iContent != null ? iContent.toString() : null;
            contentType = iContentType;
        }
        boolean empty = content == null || content.length() == 0;
        this.writeStatus(empty && iCode == 200 ? 204 : iCode, iReason);
        this.writeHeaders(contentType, iKeepAlive);
        if (iHeaders != null) {
            this.writeLine(iHeaders);
        }
        String sessId = this.sessionId != null ? this.sessionId : "-";
        this.writeLine("Set-Cookie: OSESSIONID=" + sessId + "; Path=/; HttpOnly");
        byte[] binaryContent = null;
        if (!empty) {
            binaryContent = this.contentEncoding != null && this.contentEncoding.equals("gzip") ? this.compress(content) : OBinaryProtocol.string2bytes((String)content);
        }
        this.writeLine("Content-Length: " + (empty ? 0 : binaryContent.length));
        this.writeLine(null);
        if (binaryContent != null) {
            this.out.write(binaryContent);
        }
        this.flush();
    }

    public void writeStatus(int iStatus, String iReason) throws IOException {
        this.writeLine(this.httpVersion + " " + iStatus + " " + iReason);
    }

    public void writeHeaders(String iContentType) throws IOException {
        this.writeHeaders(iContentType, true);
    }

    public void writeHeaders(String iContentType, boolean iKeepAlive) throws IOException {
        if (this.headers != null) {
            this.writeLine(this.headers);
        }
        this.writeLine("Date: " + new Date());
        this.writeLine("Content-Type: " + iContentType + "; charset=" + this.characterSet);
        this.writeLine("Server: " + this.serverInfo);
        this.writeLine("Connection: " + (this.keepAlive ? "Keep-Alive" : "close"));
        if (this.contentEncoding != null && this.contentEncoding.length() > 0) {
            this.writeLine("Content-Encoding: " + this.contentEncoding);
        }
        if (this.additionalHeaders != null) {
            for (String h : this.additionalHeaders) {
                this.writeLine(h);
            }
        }
    }

    public void writeLine(String iContent) throws IOException {
        this.writeContent(iContent);
        this.out.write(OHttpUtils.EOL);
    }

    public void writeContent(String iContent) throws IOException {
        if (iContent != null) {
            this.out.write(OBinaryProtocol.string2bytes((String)iContent));
        }
    }

    public void writeResult(Object iResult) throws InterruptedException, IOException {
        this.writeResult(iResult, null, null);
    }

    public void writeResult(Object iResult, String iFormat, String accept) throws InterruptedException, IOException {
        if (iResult == null) {
            this.send(204, "", "text/plain", null, null, true);
        } else {
            Iterator<Object> newResult = this.isJSObject(iResult) ? Collections.singleton(new ODocument().field("value", iResult)).iterator() : (iResult instanceof Map ? ((Map)iResult).entrySet().iterator() : (OMultiValue.isMultiValue((Object)iResult) && OMultiValue.getSize((Object)iResult) > 0 && !(OMultiValue.getFirstValue((Object)iResult) instanceof OIdentifiable) ? Collections.singleton(new ODocument().field("value", iResult)).iterator() : (iResult instanceof OIdentifiable ? Collections.singleton(iResult).iterator() : (iResult instanceof Iterable ? ((Iterable)iResult).iterator() : (OMultiValue.isMultiValue((Object)iResult) ? OMultiValue.getMultiValueIterator((Object)iResult) : Collections.singleton(new ODocument().field("value", iResult)).iterator())))));
            if (newResult == null) {
                this.send(204, "", "text/plain", null, null, true);
            } else {
                this.writeRecords(newResult, null, iFormat, accept);
            }
        }
    }

    public void writeRecords(Object iRecords) throws IOException {
        this.writeRecords(iRecords, null, null, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan) throws IOException {
        this.writeRecords(iRecords, iFetchPlan, null, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept) throws IOException {
        if (iRecords == null) {
            return;
        }
        final Iterator it = OMultiValue.getMultiValueIterator((Object)iRecords);
        if (accept != null && accept.contains("text/csv")) {
            this.sendStream(200, "OK", "application/json", "data.csv", new OCallable<Void, OChunkedResponse>(){

                public Void call(OChunkedResponse iArgument) {
                    LinkedHashSet<String> colNames = new LinkedHashSet<String>();
                    ArrayList<ODocument> records = new ArrayList<ODocument>();
                    while (it.hasNext()) {
                        ORecord rec;
                        Object r = it.next();
                        if (r == null || !(r instanceof OIdentifiable) || (rec = ((OIdentifiable)r).getRecord()) == null || !(rec instanceof ODocument)) continue;
                        ODocument doc = (ODocument)rec;
                        records.add(doc);
                        for (String fieldName : doc.fieldNames()) {
                            colNames.add(fieldName);
                        }
                    }
                    ArrayList orderedColumns = new ArrayList(colNames);
                    try {
                        for (int col = 0; col < orderedColumns.size(); ++col) {
                            if (col > 0) {
                                iArgument.write(44);
                            }
                            iArgument.write(((String)orderedColumns.get(col)).getBytes());
                        }
                        iArgument.write(OHttpUtils.EOL);
                        for (ODocument doc : records) {
                            for (int col = 0; col < orderedColumns.size(); ++col) {
                                Object value;
                                if (col > 0) {
                                    iArgument.write(44);
                                }
                                if ((value = doc.field((String)orderedColumns.get(col))) == null) continue;
                                if (!(value instanceof Number)) {
                                    value = "\"" + value + "\"";
                                }
                                iArgument.write(value.toString().getBytes());
                            }
                            iArgument.write(OHttpUtils.EOL);
                        }
                        iArgument.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        } else {
            iFormat = iFormat == null ? JSON_FORMAT : "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments," + iFormat;
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer, iFormat);
            json.beginObject();
            String format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
            json.beginCollection(-1, true, "result");
            this.formatMultiValue(it, buffer, format);
            json.endCollection(-1, true);
            json.endObject();
            this.send(200, "OK", "application/json", buffer.toString(), null);
        }
    }

    public void formatMultiValue(Iterator<?> iIterator, StringWriter buffer, String format) throws IOException {
        if (iIterator != null) {
            int counter = 0;
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry == null) continue;
                if (counter++ > 0) {
                    buffer.append(", ");
                }
                if (entry instanceof OIdentifiable) {
                    ORecord rec = ((OIdentifiable)entry).getRecord();
                    if (rec == null) continue;
                    try {
                        String objectJson = rec.toJSON(format);
                        buffer.append(objectJson);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error transforming record " + rec.getIdentity() + " to JSON", (Throwable)e, new Object[0]);
                    }
                    continue;
                }
                if (OMultiValue.isMultiValue(entry)) {
                    this.formatMultiValue(OMultiValue.getMultiValueIterator(entry), buffer, format);
                    continue;
                }
                buffer.append(OJSONWriter.writeValue(entry, (String)format));
            }
        }
    }

    public void writeRecord(ORecord<?> iRecord) throws IOException {
        this.writeRecord(iRecord, null, null);
    }

    public void writeRecord(ORecord<?> iRecord, String iFetchPlan, String iFormat) throws IOException {
        String format;
        if (iFormat == null) {
            iFormat = JSON_FORMAT;
        }
        String string = format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
        if (iRecord != null) {
            this.send(200, "OK", "application/json", iRecord.toJSON(format), "ETag: " + iRecord.getVersion());
        }
    }

    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.sendStream(iCode, iReason, iContentType, iContent, iSize, null);
    }

    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize, String iFileName) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        if (iSize < 0L) {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            if (iContent != null) {
                int b;
                while ((b = iContent.read()) > -1) {
                    o.write(b);
                }
            }
            byte[] content = o.toByteArray();
            iContent = new ByteArrayInputStream(content);
            iSize = content.length;
        }
        this.writeLine("Content-Length: " + iSize);
        this.writeLine(null);
        if (iContent != null) {
            int b;
            while ((b = iContent.read()) > -1) {
                this.out.write(b);
            }
        }
        this.flush();
    }

    public void sendStream(int iCode, String iReason, String iContentType, String iFileName, OCallable<Void, OChunkedResponse> iWriter) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Transfer-Encoding: binary");
        this.writeLine("Transfer-Encoding: chunked");
        if (iFileName != null) {
            this.writeLine("Content-Disposition: attachment; filename=\"" + iFileName + "\"");
        }
        this.writeLine(null);
        OChunkedResponse chunkedOutput = new OChunkedResponse(this);
        iWriter.call((Object)chunkedOutput);
        chunkedOutput.close();
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compress(String jsonStr) {
        if (jsonStr == null || jsonStr.length() == 0) {
            return null;
        }
        DeflaterOutputStream gout = null;
        ByteArrayOutputStream baos = null;
        try {
            byte[] incoming = jsonStr.getBytes("UTF-8");
            baos = new ByteArrayOutputStream();
            gout = new GZIPOutputStream((OutputStream)baos, 16384);
            gout.write(incoming);
            ((GZIPOutputStream)gout).finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (gout != null) {
                    gout.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void setHeader(String iHeader) {
        this.headers = iHeader;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flush() throws IOException {
        this.out.flush();
        if (this.keepAlive) {
            this.out.close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    private boolean isJSObject(Object iResult) {
        return iResult.getClass().getName().equals("jdk.nashorn.api.scripting.ScriptObjectMirror");
    }
}

