/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.all;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.OProcessException;
import com.orientechnologies.orient.core.processor.OProcessorManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestWrapper;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponseWrapper;
import com.orientechnologies.orient.server.network.protocol.http.OHttpSessionManager;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandProcess
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|process/*", "POST|process/*"};
    private String path = "";
    private String extension = "";

    public OServerCommandProcess(OServerCommandConfiguration iConfig) {
        for (OServerEntryConfiguration cfg : iConfig.parameters) {
            if ("path".equalsIgnoreCase(cfg.name)) {
                this.path = cfg.value;
                continue;
            }
            if (!"extension".equalsIgnoreCase(cfg.name)) continue;
            this.extension = cfg.value;
        }
        OProcessorManager.getInstance().register((Object)"composable", (Object)new OComposableProcessor().setPath(this.path).setExtension(this.extension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] parts = this.checkSyntax(iRequest.url, 3, "Syntax error: process/<database>/<template-name>[/param]*");
        iRequest.data.commandInfo = "Processes a transformation returning a JSON";
        String name = parts[2];
        ODatabaseDocumentTx db = null;
        try {
            OComposableProcessor processEngine;
            Object result;
            db = this.getProfiledDatabaseInstance(iRequest);
            String[] args = new String[parts.length - 3];
            for (int i = 3; i < parts.length; ++i) {
                args[i - 3] = parts[i];
            }
            OBasicCommandContext context = new OBasicCommandContext();
            int argIdx = 0;
            for (String arg : args) {
                context.setVariable("arg" + argIdx++, (Object)arg);
            }
            context.setVariable("session", (Object)OHttpSessionManager.getInstance().getSession(iRequest.sessionId));
            context.setVariable("request", (Object)new OHttpRequestWrapper(iRequest, args));
            context.setVariable("response", (Object)new OHttpResponseWrapper(iResponse));
            String debugMode = iRequest.getParameter("debug");
            if (debugMode != null && Boolean.parseBoolean(debugMode)) {
                context.setVariable("debugMode", (Object)Boolean.TRUE);
            }
            if ((result = (processEngine = (OComposableProcessor)OProcessorManager.getInstance().get((Object)"composable")).processFromFile(name, (OCommandContext)context, iRequest.httpMethod.equals("GET"))) instanceof ODocument) {
                result = ((ODocument)result).field("result");
            }
            iResponse.writeResult(result, "", iRequest.contentType);
        }
        catch (OProcessException e) {
            OLogManager.instance().error((Object)this, "[process] exception during process of %s", (Throwable)e, new Object[]{name});
            StringBuilder msg = new StringBuilder();
            for (Throwable currentException = e; currentException != null; currentException = (Exception)currentException.getCause()) {
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append(currentException.getMessage());
            }
            iResponse.send(400, "Bad request", "text/plain", msg.toString(), null, true);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

