/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class OServerCommandGetConnections
extends OServerCommandAuthenticatedServerAbstract {
    protected static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final String[] NAMES = new String[]{"GET|connections/*"};

    public OServerCommandGetConnections() {
        super("server.connections");
    }

    public OServerCommandGetConnections(String iName) {
        super(iName);
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] args = this.checkSyntax(iRequest.url, 1, "Syntax error: connections[/<database>]");
        iRequest.data.commandInfo = "Server status";
        StringWriter jsonBuffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)jsonBuffer);
        json.beginObject();
        String databaseName = args.length > 1 && args[1].length() > 0 ? args[1] : null;
        this.writeConnections(json, databaseName);
        json.endObject();
        iResponse.send(200, "OK", "application/json", jsonBuffer.toString(), null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeConnections(OJSONWriter json, String databaseName) throws IOException {
        json.beginCollection(1, true, "connections");
        List<OClientConnection> conns = OClientConnectionManager.instance().getConnections();
        for (OClientConnection c : conns) {
            String connectedOn;
            String lastCommandOn;
            ONetworkProtocolData data = c.data;
            if (databaseName != null && !databaseName.equals(data.lastDatabase)) continue;
            DateFormat dateFormat = dateTimeFormat;
            synchronized (dateFormat) {
                lastCommandOn = dateTimeFormat.format(new Date(data.lastCommandReceived));
                connectedOn = dateTimeFormat.format(new Date(c.since));
            }
            json.beginObject(2);
            this.writeField(json, 2, "connectionId", c.id);
            this.writeField(json, 2, "remoteAddress", c.protocol.getChannel() != null ? c.protocol.getChannel().toString() : "Disconnected");
            this.writeField(json, 2, "db", data.lastDatabase != null ? data.lastDatabase : "-");
            this.writeField(json, 2, "user", data.lastUser != null ? data.lastUser : "-");
            this.writeField(json, 2, "totalRequests", data.totalRequests);
            this.writeField(json, 2, "commandInfo", data.commandInfo);
            this.writeField(json, 2, "commandDetail", data.commandDetail);
            this.writeField(json, 2, "lastCommandOn", lastCommandOn);
            this.writeField(json, 2, "lastCommandInfo", data.lastCommandInfo);
            this.writeField(json, 2, "lastCommandDetail", data.lastCommandDetail);
            this.writeField(json, 2, "lastExecutionTime", data.lastCommandExecutionTime);
            this.writeField(json, 2, "totalWorkingTime", data.totalCommandExecutionTime);
            this.writeField(json, 2, "connectedOn", connectedOn);
            this.writeField(json, 2, "protocol", c.protocol.getType());
            this.writeField(json, 2, "clientId", data.clientId);
            StringBuilder driver = new StringBuilder();
            if (data.driverName != null) {
                driver.append(data.driverName);
                driver.append(" v");
                driver.append(data.driverVersion);
                driver.append(" Protocol v");
                driver.append(data.protocolVersion);
            }
            this.writeField(json, 2, "driver", driver.toString());
            json.endObject(2);
        }
        json.endCollection(1, false);
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private void writeField(OJSONWriter json, int iLevel, String iAttributeName, Object iAttributeValue) throws IOException {
        json.writeAttribute(iLevel, true, iAttributeName, (Object)(iAttributeValue != null ? iAttributeValue.toString() : "-"));
    }
}

