/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.concur.resource.OReentrantResourcePool;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetConnections;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;

public class OServerCommandGetServer
extends OServerCommandGetConnections {
    private static final String[] NAMES = new String[]{"GET|server"};

    public OServerCommandGetServer() {
        super("server.info");
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 1, "Syntax error: server");
        iRequest.data.commandInfo = "Server status";
        StringWriter jsonBuffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)jsonBuffer);
        json.beginObject();
        this.writeConnections(json, null);
        this.writeDatabases(json);
        this.writeStorages(json);
        this.writeProperties(json);
        json.endObject();
        iResponse.send(200, "OK", "application/json", jsonBuffer.toString(), null);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    protected void writeProperties(OJSONWriter json) throws IOException {
        json.beginCollection(2, true, "properties");
        for (OServerEntryConfiguration entry : this.server.getConfiguration().properties) {
            json.beginObject(3, true, null);
            json.writeAttribute(4, false, "name", (Object)entry.name);
            json.writeAttribute(4, false, "value", (Object)entry.value);
            json.endObject(3, true);
        }
        json.endCollection(2, true);
    }

    protected void writeStorages(OJSONWriter json) throws IOException {
        json.beginCollection(1, true, "storages");
        Collection storages = Orient.instance().getStorages();
        for (OStorage s : storages) {
            json.beginObject(2);
            this.writeField(json, 2, "name", s.getName());
            this.writeField(json, 2, "type", s.getClass().getSimpleName());
            this.writeField(json, 2, "path", s instanceof OStorageLocalAbstract ? ((OStorageLocalAbstract)s).getStoragePath().replace('\\', '/') : "");
            this.writeField(json, 2, "activeUsers", s.getUsers());
            json.endObject(2);
        }
        json.endCollection(1, false);
    }

    protected void writeDatabases(OJSONWriter json) throws IOException {
        json.beginCollection(1, true, "dbs");
        Map dbPool = this.server.getDatabasePool().getPools();
        for (Map.Entry entry : dbPool.entrySet()) {
            for (ODatabaseDocumentTx db : ((OReentrantResourcePool)entry.getValue()).getResources()) {
                json.beginObject(2);
                this.writeField(json, 2, "db", db.getName());
                this.writeField(json, 2, "user", db.getUser() != null ? db.getUser().getName() : "-");
                this.writeField(json, 2, "status", db.isClosed() ? "closed" : "open");
                this.writeField(json, 2, "type", db.getType());
                this.writeField(json, 2, "storageType", db.getStorage().getType());
                json.endObject(2);
            }
        }
        json.endCollection(1, false);
    }

    private void writeField(OJSONWriter json, int iLevel, String iAttributeName, Object iAttributeValue) throws IOException {
        json.writeAttribute(iLevel, true, iAttributeName, (Object)(iAttributeValue != null ? iAttributeValue.toString() : "-"));
    }
}

