/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.OTxSegment;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OServerCommandPostDatabase
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"POST|database/*"};

    public OServerCommandPostDatabase() {
        super("database.create");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        ODatabaseDocumentTx database;
        String type;
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: database/<db>/<type>");
        iRequest.data.commandInfo = "Create database";
        String databaseName = urlParts[1];
        String storageMode = urlParts[2];
        String url = this.getStoragePath(databaseName, storageMode);
        String string = type = urlParts.length > 3 ? urlParts[3] : "document";
        if (url != null) {
            database = Orient.instance().getDatabaseFactory().createDatabase(type, url);
            if (database.exists()) {
                throw new ODatabaseException("Database '" + database.getURL() + "' already exists");
            }
            for (OStorage stg : Orient.instance().getStorages()) {
                if (!stg.getName().equalsIgnoreCase(database.getName()) || !stg.exists()) continue;
                throw new ODatabaseException("Database named '" + database.getName() + "' already exists: " + stg);
            }
        } else {
            throw new OCommandExecutionException("The '" + storageMode + "' storage mode does not exists.");
        }
        OLogManager.instance().info((Object)this, "Creating database " + url, new Object[0]);
        database.create();
        this.sendDatabaseInfo(iRequest, iResponse, database);
        return false;
    }

    protected String getStoragePath(String databaseName, String storageMode) {
        String path;
        if (storageMode.equals("local") || storageMode.equals("plocal")) {
            path = storageMode + ":${" + "ORIENTDB_HOME" + "}/databases/" + databaseName;
        } else if (storageMode.equals("memory")) {
            path = storageMode + ":" + databaseName;
        } else {
            return null;
        }
        return path;
    }

    protected void sendDatabaseInfo(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocumentTx db) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer);
        json.beginObject();
        if (db.getMetadata().getSchema().getClasses() != null) {
            json.beginCollection(1, false, "classes");
            HashSet<String> exportedNames = new HashSet<String>();
            for (OClass cls : db.getMetadata().getSchema().getClasses()) {
                if (exportedNames.contains(cls.getName())) continue;
                try {
                    this.exportClass(db, json, cls);
                    exportedNames.add(cls.getName());
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on exporting class '" + cls + "'", (Throwable)e, new Object[0]);
                }
            }
            json.endCollection(1, true);
        }
        if (db.getStorage() instanceof OStorageLocal) {
            json.beginCollection(1, false, "dataSegments");
            for (ODataLocal data : ((OStorageLocal)db.getStorage()).getDataSegments()) {
                json.beginObject(2, true, null);
                json.writeAttribute(3, false, "id", (Object)data.getId());
                json.writeAttribute(3, false, "name", (Object)data.getName());
                json.writeAttribute(3, false, "size", (Object)data.getSize());
                json.writeAttribute(3, false, "filled", (Object)data.getFilledUpTo());
                json.writeAttribute(3, false, "maxSize", (Object)data.getConfig().maxSize);
                json.writeAttribute(3, false, "files", (Object)Arrays.toString(data.getConfig().infoFiles));
                json.endObject(2, false);
            }
            json.endCollection(1, true);
        }
        if (db.getClusterNames() != null) {
            json.beginCollection(1, false, "clusters");
            for (String clusterName : db.getClusterNames()) {
                OCluster cluster = db.getStorage().getClusterById(db.getClusterIdByName(clusterName));
                try {
                    json.beginObject(2, true, null);
                    json.writeAttribute(3, false, "id", (Object)cluster.getId());
                    json.writeAttribute(3, false, "name", (Object)clusterName);
                    json.writeAttribute(3, false, "type", (Object)cluster.getType());
                    json.writeAttribute(3, false, "records", (Object)(cluster.getEntries() - cluster.getTombstonesCount()));
                    if (cluster instanceof OClusterLocal) {
                        json.writeAttribute(3, false, "size", (Object)((OClusterLocal)cluster).getSize());
                        json.writeAttribute(3, false, "filled", (Object)((OClusterLocal)cluster).getFilledUpTo());
                        json.writeAttribute(3, false, "maxSize", (Object)((OClusterLocal)cluster).getConfig().getMaxSize());
                        json.writeAttribute(3, false, "files", (Object)Arrays.toString(((OClusterLocal)cluster).getConfig().getInfoFiles()));
                    } else {
                        json.writeAttribute(3, false, "size", (Object)"-");
                        json.writeAttribute(3, false, "filled", (Object)"-");
                        json.writeAttribute(3, false, "maxSize", (Object)"-");
                        json.writeAttribute(3, false, "files", (Object)"-");
                    }
                }
                catch (Exception e) {
                    json.writeAttribute(3, false, "records", (Object)"? (Unauthorized)");
                }
                json.endObject(2, false);
            }
            json.endCollection(1, true);
        }
        if (db.getStorage() instanceof OStorageLocal) {
            json.beginCollection(1, false, "txSegment");
            OTxSegment txSegment = ((OStorageLocal)db.getStorage()).getTxManager().getTxSegment();
            json.beginObject(2, true, null);
            json.writeAttribute(3, false, "size", (Object)txSegment.getSize());
            json.writeAttribute(3, false, "filled", (Object)txSegment.getFilledUpTo());
            json.writeAttribute(3, false, "maxSize", (Object)txSegment.getConfig().maxSize);
            json.writeAttribute(3, false, "file", (Object)txSegment.getConfig().path);
            json.endObject(2, false);
            json.endCollection(1, true);
        }
        json.writeAttribute(1, false, "currentUser", (Object)db.getUser().getName());
        json.beginCollection(1, false, "users");
        for (ODocument doc : db.getMetadata().getSecurity().getAllUsers()) {
            OUser user = new OUser(doc);
            json.beginObject(2, true, null);
            json.writeAttribute(3, false, "name", (Object)user.getName());
            json.writeAttribute(3, false, "roles", (Object)(user.getRoles() != null ? Arrays.toString(user.getRoles().toArray()) : "null"));
            json.endObject(2, false);
        }
        json.endCollection(1, true);
        json.beginCollection(1, true, "roles");
        for (ODocument doc : db.getMetadata().getSecurity().getAllRoles()) {
            ORole role = new ORole(doc);
            json.beginObject(2, true, null);
            json.writeAttribute(3, false, "name", (Object)role.getName());
            json.writeAttribute(3, false, "mode", (Object)role.getMode().toString());
            json.beginCollection(3, true, "rules");
            for (Map.Entry rule : role.getRules().entrySet()) {
                json.beginObject(4);
                json.writeAttribute(4, true, "name", rule.getKey());
                json.writeAttribute(4, false, "create", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_CREATE));
                json.writeAttribute(4, false, "read", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_READ));
                json.writeAttribute(4, false, "update", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_UPDATE));
                json.writeAttribute(4, false, "delete", (Object)role.allow((String)rule.getKey(), ORole.PERMISSION_DELETE));
                json.endObject(4, true);
            }
            json.endCollection(3, false);
            json.endObject(2, true);
        }
        json.endCollection(1, true);
        json.beginObject(1, true, (Object)"config");
        json.beginCollection(2, true, "values");
        json.writeObjects(3, true, null, (Object[][])new Object[][]{{"name", "dateFormat", "value", db.getStorage().getConfiguration().dateFormat}, {"name", "dateTimeFormat", "value", db.getStorage().getConfiguration().dateTimeFormat}, {"name", "localeCountry", "value", db.getStorage().getConfiguration().getLocaleCountry()}, {"name", "localeLanguage", "value", db.getStorage().getConfiguration().getLocaleLanguage()}, {"name", "definitionVersion", "value", db.getStorage().getConfiguration().version}});
        json.endCollection(2, true);
        json.beginCollection(2, true, "properties");
        if (db.getStorage().getConfiguration().properties != null) {
            for (OStorageEntryConfiguration entry : db.getStorage().getConfiguration().properties) {
                if (entry == null) continue;
                json.beginObject(3, true, null);
                json.writeAttribute(4, false, "name", (Object)entry.name);
                json.writeAttribute(4, false, "value", (Object)entry.value);
                json.endObject(3, true);
            }
        }
        json.endCollection(2, true);
        json.endObject(1, true);
        json.endObject();
        json.flush();
        iResponse.send(200, "OK", "application/json", buffer.toString(), null);
    }

    protected void exportClass(ODatabaseDocumentTx db, OJSONWriter json, OClass cls) throws IOException {
        Set indexes;
        json.beginObject(2, true, null);
        json.writeAttribute(3, true, "name", (Object)cls.getName());
        json.writeAttribute(3, true, "superClass", (Object)(cls.getSuperClass() != null ? cls.getSuperClass().getName() : ""));
        json.writeAttribute(3, true, "alias", (Object)cls.getShortName());
        json.writeAttribute(3, true, "clusters", (Object)cls.getClusterIds());
        json.writeAttribute(3, true, "defaultCluster", (Object)cls.getDefaultClusterId());
        json.writeAttribute(3, true, "clusterSelection", (Object)cls.getClusterSelection().getName());
        try {
            json.writeAttribute(3, false, "records", (Object)db.countClass(cls.getName()));
        }
        catch (OSecurityAccessException e) {
            json.writeAttribute(3, false, "records", (Object)"? (Unauthorized)");
        }
        if (cls.properties() != null && cls.properties().size() > 0) {
            json.beginCollection(3, true, "properties");
            for (OProperty prop : cls.properties()) {
                json.beginObject(4, true, null);
                json.writeAttribute(4, true, "name", (Object)prop.getName());
                if (prop.getLinkedClass() != null) {
                    json.writeAttribute(4, true, "linkedClass", (Object)prop.getLinkedClass().getName());
                }
                if (prop.getLinkedType() != null) {
                    json.writeAttribute(4, true, "linkedType", (Object)prop.getLinkedType().toString());
                }
                json.writeAttribute(4, true, "type", (Object)prop.getType().toString());
                json.writeAttribute(4, true, "mandatory", (Object)prop.isMandatory());
                json.writeAttribute(4, true, "readonly", (Object)prop.isReadonly());
                json.writeAttribute(4, true, "notNull", (Object)prop.isNotNull());
                json.writeAttribute(4, true, "min", (Object)prop.getMin());
                json.writeAttribute(4, true, "max", (Object)prop.getMax());
                json.endObject(3, true);
            }
            json.endCollection(1, true);
        }
        if (!(indexes = cls.getIndexes()).isEmpty()) {
            json.beginCollection(3, true, "indexes");
            for (OIndex index : indexes) {
                json.beginObject(4, true, null);
                json.writeAttribute(4, true, "name", (Object)index.getName());
                json.writeAttribute(4, true, "type", (Object)index.getType());
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition != null && !indexDefinition.getFields().isEmpty()) {
                    json.writeAttribute(4, true, "fields", (Object)indexDefinition.getFields());
                }
                json.endObject(3, true);
            }
            json.endCollection(1, true);
        }
        json.endObject(1, false);
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

