/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.io.Externalizable;

public abstract class OAbstractRemoteTask
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected transient String nodeSource;

    public abstract String getName();

    public abstract QUORUM_TYPE getQuorumType();

    public abstract Object execute(OServer var1, ODistributedServerManager var2, ODatabaseDocumentTx var3) throws Exception;

    public long getTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public long getSynchronousTimeout(int iSynchNodes) {
        return this.getTimeout() * (long)iSynchNodes;
    }

    public long getTotalTimeout(int iTotalNodes) {
        return this.getTimeout() * (long)iTotalNodes;
    }

    public RESULT_STRATEGY getResultStrategy() {
        return RESULT_STRATEGY.ANY;
    }

    public String toString() {
        return this.getName();
    }

    public String getNodeSource() {
        return this.nodeSource;
    }

    public void setNodeSource(String nodeSource) {
        this.nodeSource = nodeSource;
    }

    public boolean isRequireNodeOnline() {
        return true;
    }

    public boolean isRequiredOpenDatabase() {
        return true;
    }

    public boolean isIdempotent() {
        return false;
    }

    public static enum QUORUM_TYPE {
        NONE,
        READ,
        WRITE,
        ALL;

    }

    public static enum RESULT_STRATEGY {
        ANY,
        UNION;

    }
}

