/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OHttpNetworkCommandManager {
    private static final String URL_PART_PATTERN = "([a-zA-Z0-9%:\\\\+]*)";
    private static final String REST_PARAM_PATTERN = "\\{[a-zA-Z0-9%:]*\\}";
    private final Map<String, OServerCommand> exactCommands = new HashMap<String, OServerCommand>();
    private final Map<String, OServerCommand> wildcardCommands = new HashMap<String, OServerCommand>();
    private final Map<String, OServerCommand> restCommands = new HashMap<String, OServerCommand>();
    private final OHttpNetworkCommandManager parent;
    private final OServer server;

    public OHttpNetworkCommandManager(OServer iServer, OHttpNetworkCommandManager iParent) {
        this.server = iServer;
        this.parent = iParent;
    }

    public Object getCommand(String iName) {
        OServerCommand cmd = this.exactCommands.get(iName);
        if (cmd == null) {
            for (Map.Entry<String, OServerCommand> entry : this.restCommands.entrySet()) {
                if (!this.matches(entry.getKey(), iName)) continue;
                return entry.getValue();
            }
        }
        if (cmd == null) {
            for (Map.Entry<String, OServerCommand> entry : this.wildcardCommands.entrySet()) {
                int wildcardPos = entry.getKey().indexOf(42);
                String partLeft = entry.getKey().substring(0, wildcardPos);
                String partRight = entry.getKey().substring(wildcardPos + 1);
                if (!iName.startsWith(partLeft) || !iName.endsWith(partRight)) continue;
                cmd = entry.getValue();
                break;
            }
        }
        if (cmd == null && this.parent != null) {
            cmd = (OServerCommand)this.parent.getCommand(iName);
        }
        return cmd;
    }

    public void registerCommand(OServerCommand iServerCommandInstance) {
        for (String name : iServerCommandInstance.getNames()) {
            if (OStringSerializerHelper.contains((String)name, (char)'{')) {
                this.restCommands.put(name, iServerCommandInstance);
                continue;
            }
            if (OStringSerializerHelper.contains((String)name, (char)'*')) {
                this.wildcardCommands.put(name, iServerCommandInstance);
                continue;
            }
            this.exactCommands.put(name, iServerCommandInstance);
        }
        iServerCommandInstance.configure(this.server);
    }

    public Map<String, String> extractUrlTokens(String requestUrl) {
        HashMap<String, String> result = new HashMap<String, String>();
        String urlPattern = this.findUrlPattern(requestUrl);
        if (urlPattern == null) {
            return result;
        }
        String matcherUrl = urlPattern.replaceAll(REST_PARAM_PATTERN, URL_PART_PATTERN);
        matcherUrl = matcherUrl.substring(matcherUrl.indexOf(124) + 1);
        requestUrl = requestUrl.substring(requestUrl.indexOf(124) + 1);
        Pattern pattern = Pattern.compile(matcherUrl);
        Matcher matcher = pattern.matcher(requestUrl);
        if (matcher.find()) {
            Pattern templateUrlPattern = Pattern.compile(REST_PARAM_PATTERN);
            Matcher templateMatcher = templateUrlPattern.matcher(urlPattern);
            int i = 1;
            while (templateMatcher.find()) {
                String key = templateMatcher.group();
                key = key.substring(1);
                key = key.substring(0, key.length() - 1);
                String value = matcher.group(i++);
                result.put(key, value);
            }
        }
        return result;
    }

    protected String findUrlPattern(String requestUrl) {
        for (Map.Entry<String, OServerCommand> entry : this.restCommands.entrySet()) {
            if (!this.matches(entry.getKey(), requestUrl)) continue;
            return entry.getKey();
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.findUrlPattern(requestUrl);
    }

    private boolean matches(String urlPattern, String requestUrl) {
        String matcherUrl = urlPattern.replaceAll(REST_PARAM_PATTERN, URL_PART_PATTERN);
        if (!matcherUrl.substring(0, matcherUrl.indexOf(124) + 1).equals(requestUrl.substring(0, requestUrl.indexOf(124) + 1))) {
            return false;
        }
        matcherUrl = matcherUrl.substring(matcherUrl.indexOf(124) + 1);
        requestUrl = requestUrl.substring(requestUrl.indexOf(124) + 1);
        return requestUrl.matches(matcherUrl);
    }
}

