/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;
import java.util.Collection;
import java.util.Map;

public class OServerCommandPostBatch
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"POST|batch/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 2, "Syntax error: batch/<database>");
        iRequest.data.commandInfo = "Execute multiple requests in one shot";
        ODatabaseDocumentTx db = null;
        ODocument batch = null;
        Object lastResult = null;
        try {
            Collection operations;
            db = this.getProfiledDatabaseInstance(iRequest);
            batch = (ODocument)new ODocument().fromJSON(iRequest.content);
            Boolean tx = (Boolean)batch.field("transaction");
            if (tx == null) {
                tx = false;
            }
            try {
                operations = (Collection)batch.field("operations");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Expected 'operations' field as a collection of objects");
            }
            if (operations == null || operations.isEmpty()) {
                throw new IllegalArgumentException("Input JSON has no operations to execute");
            }
            if (tx.booleanValue()) {
                db.begin();
            }
            for (Map operation : operations) {
                String language;
                ODocument doc;
                String type = (String)operation.get("type");
                if (type.equals("c")) {
                    doc = this.getRecord(operation);
                    doc.save();
                    lastResult = doc;
                    continue;
                }
                if (type.equals("u")) {
                    doc = this.getRecord(operation);
                    doc.save();
                    lastResult = doc;
                    continue;
                }
                if (type.equals("d")) {
                    doc = this.getRecord(operation);
                    db.delete(doc.getIdentity());
                    lastResult = doc.getIdentity();
                    continue;
                }
                if (type.equals("cmd")) {
                    language = (String)operation.get("language");
                    if (language == null) {
                        throw new IllegalArgumentException("language parameter is null");
                    }
                    Object command = operation.get("command");
                    if (command == null) {
                        throw new IllegalArgumentException("command parameter is null");
                    }
                    String commandAsString = null;
                    if (command != null) {
                        if (OMultiValue.isMultiValue(command)) {
                            for (Object c : OMultiValue.getMultiValueIterable(command)) {
                                if (commandAsString == null) {
                                    commandAsString = c.toString();
                                    continue;
                                }
                                commandAsString = commandAsString + ";" + c.toString();
                            }
                        } else {
                            commandAsString = command.toString();
                        }
                    }
                    OCommandRequestText cmd = (OCommandRequestText)OCommandManager.instance().getRequester(language);
                    cmd.setText(commandAsString);
                    lastResult = db.command((OCommandRequest)cmd).execute(new Object[0]);
                    continue;
                }
                if (!type.equals("script")) continue;
                language = (String)operation.get("language");
                if (language == null) {
                    throw new IllegalArgumentException("language parameter is null");
                }
                Object script = operation.get("script");
                if (script == null) {
                    throw new IllegalArgumentException("script parameter is null");
                }
                StringBuilder text = new StringBuilder();
                if (OMultiValue.isMultiValue(script)) {
                    int i = 0;
                    for (Object o : OMultiValue.getMultiValueIterable(script)) {
                        if (o == null) continue;
                        if (i++ > 0) {
                            text.append("\n");
                        }
                        text.append(o.toString());
                    }
                } else {
                    text.append(script);
                }
                lastResult = db.command((OCommandRequest)new OCommandScript(language, text.toString())).execute(new Object[0]);
            }
            if (tx.booleanValue()) {
                db.commit();
            }
            iResponse.writeResult(lastResult);
            iResponse.send(200, "OK", "text/plain", null, null, true);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    public ODocument getRecord(Map<Object, Object> operation) {
        Object record = operation.get("record");
        ODocument doc = record instanceof Map ? new ODocument((Map)record) : (ODocument)record;
        return doc;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

