/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class OClientConnectionManager {
    private static final OClientConnectionManager instance = new OClientConnectionManager();
    protected ConcurrentMap<Integer, OClientConnection> connections = new ConcurrentHashMap<Integer, OClientConnection>();
    protected AtomicInteger connectionSerial = new AtomicInteger(0);

    public OClientConnectionManager() {
        int delay = OGlobalConfiguration.SERVER_CHANNEL_CLEAN_DELAY.getValueAsInteger();
        Orient.instance().getTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                Iterator iterator = OClientConnectionManager.this.connections.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Socket socket = ((OClientConnection)entry.getValue()).protocol == null || ((OClientConnection)entry.getValue()).protocol.getChannel() == null ? null : ((OClientConnection)entry.getValue()).protocol.getChannel().socket;
                    if (socket != null && !socket.isClosed() && !socket.isInputShutdown()) continue;
                    OLogManager.instance().debug((Object)this, "[OClientConnectionManager] found and removed pending closed channel %d (%s)", new Object[]{entry.getKey(), socket});
                    try {
                        ((OClientConnection)entry.getValue()).close();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during close of connection for close channel", (Throwable)e, new Object[0]);
                    }
                    iterator.remove();
                }
            }
        }, delay, (long)delay);
        Orient.instance().getProfiler().registerHookValue("server.connections.actives", "Number of active network connections", OProfilerMBean.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OClientConnectionManager.this.connections.size();
            }
        });
    }

    public static OClientConnectionManager instance() {
        return instance;
    }

    public OClientConnection connect(ONetworkProtocol iProtocol) throws IOException {
        OClientConnection connection = new OClientConnection(this.connectionSerial.incrementAndGet(), iProtocol);
        this.connections.put(connection.id, connection);
        OLogManager.instance().config((Object)this, "Remote client connected from: " + connection, new Object[0]);
        return connection;
    }

    public OClientConnection getConnection(int iChannelId, ONetworkProtocol protocol) {
        OClientConnection connection = (OClientConnection)this.connections.get(iChannelId);
        if (connection != null) {
            connection.protocol = protocol;
        }
        return connection;
    }

    public OClientConnection getConnection(String iAddress) {
        for (OClientConnection conn : this.connections.values()) {
            if (!iAddress.equals(conn.getRemoteAddress())) continue;
            return conn;
        }
        return null;
    }

    public void kill(int iChannelId) {
        this.kill((OClientConnection)this.connections.get(iChannelId));
    }

    public void kill(OClientConnection connection) {
        if (connection != null) {
            ONetworkProtocol protocol = connection.protocol;
            this.disconnect(connection);
            protocol.sendShutdown();
        }
    }

    public void interrupt(int iChannelId) {
        ONetworkProtocol protocol;
        OClientConnection connection = (OClientConnection)this.connections.get(iChannelId);
        if (connection != null && (protocol = connection.protocol) != null) {
            protocol.interrupt();
        }
    }

    public boolean disconnect(int iChannelId) {
        OLogManager.instance().debug((Object)this, "Disconnecting connection with id=%d", new Object[]{iChannelId});
        OClientConnection connection = (OClientConnection)this.connections.remove(iChannelId);
        if (connection != null) {
            connection.close();
            for (Map.Entry entry : this.connections.entrySet()) {
                if (!((Object)((Object)((OClientConnection)entry.getValue()).getProtocol())).equals((Object)connection.getProtocol())) continue;
                OLogManager.instance().debug((Object)this, "Disconnected connection with id=%d but are present other active channels", new Object[]{iChannelId});
                return false;
            }
            OLogManager.instance().debug((Object)this, "Disconnected connection with id=%d, no other active channels found", new Object[]{iChannelId});
            return true;
        }
        OLogManager.instance().debug((Object)this, "Cannot find connection with id=%d", new Object[]{iChannelId});
        return false;
    }

    public void disconnect(OClientConnection iConnection) {
        OLogManager.instance().debug((Object)this, "Disconnecting connection %s...", new Object[]{iConnection});
        iConnection.close();
        int totalRemoved = 0;
        for (Map.Entry<Integer, OClientConnection> entry : new HashMap<Integer, OClientConnection>(this.connections).entrySet()) {
            OClientConnection conn = entry.getValue();
            if (conn == null || !conn.equals(iConnection)) continue;
            this.connections.remove(entry.getKey());
            ++totalRemoved;
        }
        OLogManager.instance().debug((Object)this, "Disconnected connection %s found %d channels", new Object[]{iConnection, totalRemoved});
    }

    public List<OClientConnection> getConnections() {
        return new ArrayList<OClientConnection>(this.connections.values());
    }

    public int getTotal() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDistribCfg2Clients(ODocument iConfig) {
        byte[] content = iConfig.toStream();
        HashSet<String> pushed = new HashSet<String>();
        for (OClientConnection c : this.connections.values()) {
            try {
                String remoteAddress = c.getRemoteAddress();
                if (pushed.contains(remoteAddress)) {
                }
            }
            catch (Exception e) {}
            continue;
            if (!(c.protocol instanceof ONetworkProtocolBinary)) continue;
            ONetworkProtocolBinary p = (ONetworkProtocolBinary)c.protocol;
            OChannelBinary channel = (OChannelBinary)p.getChannel();
            try {
                channel.acquireWriteLock();
                try {
                    channel.writeByte((byte)3);
                    channel.writeInt(Integer.MIN_VALUE);
                    channel.writeByte((byte)80);
                    channel.writeBytes(content);
                    channel.flush();
                    pushed.add(c.getRemoteAddress());
                    OLogManager.instance().info((Object)this, "Sent updated cluster configuration to the remote client %s", new Object[]{c.getRemoteAddress()});
                }
                finally {
                    channel.releaseWriteLock();
                }
            }
            catch (IOException e) {
                this.disconnect(c);
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "Cannot push cluster configuration to the client %s", (Throwable)e, new Object[]{c.getRemoteAddress()});
                this.disconnect(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRecord2Clients(ORecordInternal<?> iRecord, OClientConnection iExcludeConnection) throws InterruptedException, IOException {
        String dbName = iRecord.getDatabase().getName();
        for (OClientConnection c : this.connections.values()) {
            if (c == iExcludeConnection) continue;
            ONetworkProtocolBinary p = (ONetworkProtocolBinary)c.protocol;
            OChannelBinaryAsynchClient channel = (OChannelBinaryAsynchClient)p.getChannel();
            if (c.database == null || !c.database.getName().equals(dbName)) continue;
            OClientConnection oClientConnection = c;
            synchronized (oClientConnection) {
                try {
                    channel.acquireWriteLock();
                    try {
                        channel.writeByte((byte)3);
                        channel.writeInt(Integer.MIN_VALUE);
                        channel.writeByte((byte)79);
                        p.writeIdentifiable((OIdentifiable)iRecord);
                    }
                    finally {
                        channel.releaseWriteLock();
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().warn((Object)this, "Cannot push record to the client %s", new Object[]{c.getRemoteAddress()});
                }
            }
        }
    }
}

