/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ODistributedConfiguration {
    public static final String NEW_NODE_TAG = "<NEW_NODE>";
    private ODocument configuration;

    public ODistributedConfiguration(ODocument iConfiguration) {
        this.configuration = iConfiguration;
    }

    public boolean upgrade() {
        boolean modified = false;
        for (String c : this.getClusterNames()) {
            ODocument clusterConfig;
            ODocument partitioning;
            if (this.getOriginalServers(c) != null || (partitioning = (ODocument)(clusterConfig = this.getClusterConfiguration(c)).removeField("partitioning")) == null) continue;
            Collection partitions = (Collection)partitioning.field("partitions");
            if (partitions != null) {
                OLogManager.instance().warn((Object)this, "Migrating distributed configuration to the new format for cluster '%s'...", new Object[]{c});
                ArrayList<String> servers = new ArrayList<String>();
                for (Object p : partitions) {
                    for (String node : (Collection)p) {
                        servers.add(node);
                    }
                }
                clusterConfig.field("servers", servers, new OType[]{OType.EMBEDDEDLIST});
            }
            modified = true;
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicationActive(String iClusterName, String iLocalNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument cluster = this.getClusterConfiguration(iClusterName);
            Collection servers = (Collection)cluster.field("servers");
            if (servers != null) {
                int otherServers = 0;
                for (String s : servers) {
                    if (s.equals(NEW_NODE_TAG) || s.equals(iLocalNode)) continue;
                    ++otherServers;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHotAlignment() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Boolean value = (Boolean)this.configuration.field("hotAlignment");
            if (value != null) {
                return value;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("readQuorum");
            if (value == null && (value = this.configuration.field("readQuorum")) == null) {
                OLogManager.instance().warn((Object)this, "readQuorum setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return 1;
            }
            return (Integer)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWriteQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("writeQuorum");
            if (value == null && (value = this.configuration.field("writeQuorum")) == null) {
                OLogManager.instance().warn((Object)this, "writeQuorum setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return 2;
            }
            return (Integer)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFailureAvailableNodesLessQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("failureAvailableNodesLessQuorum");
            if (value == null && (value = this.configuration.field("failureAvailableNodesLessQuorum")) == null) {
                OLogManager.instance().warn((Object)this, "failureAvailableNodesLessQuorum setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return false;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isReadYourWrites(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("readYourWrites");
            if (value == null && (value = this.configuration.field("readYourWrites")) == null) {
                OLogManager.instance().warn((Object)this, "readYourWrites setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return true;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOfflineMsgQueueSize() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.configuration.field("offlineMsgQueueSize");
            if (value != null) {
                return (Integer)value;
            }
            OLogManager.instance().debug((Object)this, "offlineMsgQueueSize setting not found in distributed-config.json", new Object[0]);
            return 100;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getOneServerPerCluster(Collection<String> iClusterNames, String iLocalNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (iClusterNames == null || iClusterNames.isEmpty()) {
                iClusterNames = Collections.singleton("*");
            }
            HashSet<String> partitions = new HashSet<String>(iClusterNames.size());
            block3: for (String p : iClusterNames) {
                ODocument partition = this.getClusterConfiguration(p);
                if (partition == null) {
                    return null;
                }
                List serverList = (List)partition.field("servers");
                if (serverList == null) continue;
                boolean localNodeFound = false;
                for (String s : serverList) {
                    if (!s.equals(iLocalNode)) continue;
                    partitions.add(s);
                    localNodeFound = true;
                    break;
                }
                if (localNodeFound) continue;
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG)) continue;
                    partitions.add(s);
                    continue block3;
                }
            }
            return partitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getServers(Collection<String> iClusterNames) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (iClusterNames == null || iClusterNames.isEmpty()) {
                iClusterNames = Collections.singleton("*");
            }
            HashSet<String> partitions = new HashSet<String>(iClusterNames.size());
            for (String p : iClusterNames) {
                ODocument partition = this.getClusterConfiguration(p);
                if (partition == null) {
                    return null;
                }
                List serverList = (List)partition.field("servers");
                if (serverList == null) continue;
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG)) continue;
                    partitions.add(s);
                }
            }
            return partitions;
        }
    }

    public Collection<String> getServers() {
        return this.getServers((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getServers(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument partition = this.getClusterConfiguration(iClusterName);
            if (partition == null) {
                return null;
            }
            ArrayList serverList = (ArrayList)partition.field("servers");
            if (serverList != null) {
                serverList = new ArrayList(serverList);
                serverList.remove(NEW_NODE_TAG);
            }
            return serverList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getOriginalServers(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument partition = this.getClusterConfiguration(iClusterName);
            if (partition == null) {
                return null;
            }
            return (Collection)partition.field("servers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClusterNames() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            return clusters.fieldNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument getClusterConfiguration(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument cfg;
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            if (clusters == null) {
                throw new OConfigurationException("Cannot find 'clusters' in distributed database configuration");
            }
            if (iClusterName == null) {
                iClusterName = "*";
            }
            if ((cfg = !clusters.containsField(iClusterName) ? (ODocument)clusters.field("*") : (ODocument)clusters.field(iClusterName)) == null) {
                return new ODocument();
            }
            return cfg;
        }
    }

    public ODocument serialize() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> addNewNodeInServerList(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ArrayList<String> changedPartitions = new ArrayList<String>();
            block3: for (String clusterName : this.getClusterNames()) {
                Collection<String> partitions = this.getOriginalServers(clusterName);
                if (partitions == null) continue;
                for (String node : partitions) {
                    if (!node.equalsIgnoreCase(NEW_NODE_TAG) || partitions.contains(iNode)) continue;
                    partitions.add(iNode);
                    changedPartitions.add(clusterName);
                    continue block3;
                }
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> removeNodeInServerList(String iNode, boolean iForce) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (!iForce && this.isHotAlignment()) {
                return null;
            }
            ArrayList<String> changedPartitions = new ArrayList<String>();
            for (String clusterName : this.getClusterNames()) {
                Collection<String> nodes = this.getOriginalServers(clusterName);
                if (nodes != null) {
                    for (String node : nodes) {
                        if (!node.equals(iNode)) continue;
                        nodes.remove(node);
                        changedPartitions.add(clusterName);
                        break;
                    }
                }
                if (changedPartitions.isEmpty()) continue;
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    protected void incrementVersion() {
        Integer oldVersion = (Integer)this.configuration.field("version");
        if (oldVersion == null) {
            oldVersion = 0;
        }
        this.configuration.field("version", (Object)(oldVersion + 1));
    }
}

