/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.plugin;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OService;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetStaticContent;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class OServerPluginManager
implements OService {
    private static final int CHECK_DELAY = 5000;
    private OServer server;
    private ConcurrentHashMap<String, OServerPluginInfo> activePlugins = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> loadedPlugins = new ConcurrentHashMap();
    private volatile TimerTask autoReloadTimerTask;

    public void config(OServer iServer) {
        this.server = iServer;
    }

    public void startup() {
        boolean hotReload = true;
        boolean dynamic = true;
        if (this.server.getConfiguration() != null && this.server.getConfiguration().properties != null) {
            for (OServerEntryConfiguration p : this.server.getConfiguration().properties) {
                if (p.name.equals("plugin.hotReload")) {
                    hotReload = Boolean.parseBoolean(p.value);
                    continue;
                }
                if (!p.name.equals("plugin.dynamic")) continue;
                dynamic = Boolean.parseBoolean(p.value);
            }
        }
        if (!dynamic) {
            return;
        }
        this.updatePlugins();
        if (hotReload) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    OServerPluginManager.this.updatePlugins();
                }
            };
            Orient.instance().getTimer().schedule(timerTask, 5000L, 5000L);
            this.autoReloadTimerTask = timerTask;
        }
    }

    public OServerPluginInfo getPluginByName(String iName) {
        if (iName == null) {
            return null;
        }
        return this.activePlugins.get(iName);
    }

    public String getPluginNameByFile(String iFileName) {
        return this.loadedPlugins.get(iFileName);
    }

    public OServerPluginInfo getPluginByFile(String iFileName) {
        return this.getPluginByName(this.getPluginNameByFile(iFileName));
    }

    public String[] getPluginNames() {
        return this.activePlugins.keySet().toArray(new String[this.activePlugins.size()]);
    }

    public void registerPlugin(OServerPluginInfo iPlugin) {
        String pluginName = iPlugin.getName();
        if (this.activePlugins.containsKey(pluginName)) {
            throw new IllegalStateException("Plugin '" + pluginName + "' already registered");
        }
        this.activePlugins.putIfAbsent(pluginName, iPlugin);
    }

    public Collection<OServerPluginInfo> getPlugins() {
        return this.activePlugins.values();
    }

    public void uninstallPluginByFile(String iFileName) {
        String pluginName = this.loadedPlugins.remove(iFileName);
        if (pluginName != null) {
            OLogManager.instance().info((Object)this, "Uninstalling dynamic plugin '%s'...", new Object[]{iFileName});
            OServerPluginInfo removedPlugin = this.activePlugins.remove(pluginName);
            if (removedPlugin != null) {
                removedPlugin.shutdown();
            }
        }
    }

    public void shutdown() {
        OLogManager.instance().info((Object)this, "Shutting down plugins:", new Object[0]);
        for (Map.Entry<String, OServerPluginInfo> pluginInfoEntry : this.activePlugins.entrySet()) {
            OLogManager.instance().info((Object)this, "- %s", new Object[]{pluginInfoEntry.getKey()});
            OServerPluginInfo plugin = pluginInfoEntry.getValue();
            try {
                plugin.shutdown();
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error during server plugin %s shutdown.", t, new Object[]{plugin});
            }
        }
        if (this.autoReloadTimerTask != null) {
            this.autoReloadTimerTask.cancel();
        }
    }

    public String getName() {
        return "plugin-manager";
    }

    protected String updatePlugin(File pluginFile) {
        String pluginFileName = pluginFile.getName();
        if (!(pluginFile.isDirectory() || pluginFileName.endsWith(".jar") || pluginFileName.endsWith(".zip"))) {
            return null;
        }
        OServerPluginInfo currentPluginData = this.getPluginByFile(pluginFileName);
        long fileLastModified = pluginFile.lastModified();
        if (currentPluginData != null) {
            if (fileLastModified <= currentPluginData.getLoadedOn()) {
                return pluginFileName;
            }
            try {
                currentPluginData.shutdown();
                this.activePlugins.remove(this.loadedPlugins.remove(pluginFileName));
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on shutdowning plugin '%s'...", (Throwable)e, new Object[]{pluginFileName});
            }
        }
        this.installDynamicPlugin(pluginFile);
        return pluginFileName;
    }

    protected void registerStaticDirectory(final OServerPluginInfo iPluginData) {
        Object httpListener;
        OServerCommandGetStaticContent command;
        Object pluginWWW = iPluginData.getParameter("www");
        if (pluginWWW == null) {
            pluginWWW = iPluginData.getName();
        }
        if ((command = (OServerCommandGetStaticContent)((OServerNetworkListener)(httpListener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class))).getCommand(OServerCommandGetStaticContent.class)) != null) {
            URL wwwURL = iPluginData.getClassLoader().findResource("www/");
            OCallable<Object, String> callback = wwwURL != null ? this.createStaticLinkCallback(iPluginData, wwwURL) : new OCallable<Object, String>(){

                public Object call(String iArgument) {
                    return iPluginData.getInstance().getContent(iArgument);
                }
            };
            command.registerVirtualFolder(pluginWWW.toString(), callback);
        }
    }

    protected OCallable<Object, String> createStaticLinkCallback(final OServerPluginInfo iPluginData, URL wwwURL) {
        return new OCallable<Object, String>(){

            public Object call(String iArgument) {
                String fileName = "www/" + iArgument;
                URL url = iPluginData.getClassLoader().findResource(fileName);
                if (url != null) {
                    OServerCommandGetStaticContent.OStaticContent content = new OServerCommandGetStaticContent.OStaticContent();
                    content.is = new BufferedInputStream(iPluginData.getClassLoader().getResourceAsStream(fileName));
                    content.contentSize = -1L;
                    content.type = OServerCommandGetStaticContent.getContentType(url.getFile());
                    return content;
                }
                return null;
            }
        };
    }

    protected OServerPlugin startPluginClass(URLClassLoader pluginClassLoader, String iClassName, OServerParameterConfiguration[] params) throws Exception {
        Class<?> classToLoad = Class.forName(iClassName, true, pluginClassLoader);
        OServerPlugin instance = (OServerPlugin)classToLoad.newInstance();
        Method configMethod = classToLoad.getDeclaredMethod("config", OServer.class, OServerParameterConfiguration[].class);
        configMethod.invoke((Object)instance, this.server, params);
        Method startupMethod = classToLoad.getDeclaredMethod("startup", new Class[0]);
        startupMethod.invoke((Object)instance, new Object[0]);
        return instance;
    }

    private void updatePlugins() {
        File pluginsDirectory = new File(OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}", (String)".") + "/plugins/");
        if (!pluginsDirectory.exists()) {
            pluginsDirectory.mkdirs();
        }
        File[] plugins = pluginsDirectory.listFiles();
        HashSet<String> currentDynamicPlugins = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.loadedPlugins.entrySet()) {
            currentDynamicPlugins.add(entry.getKey());
        }
        if (plugins != null) {
            for (File plugin : plugins) {
                String pluginName = this.updatePlugin(plugin);
                if (pluginName == null) continue;
                currentDynamicPlugins.remove(pluginName);
            }
        }
        for (String pluginName : currentDynamicPlugins) {
            this.uninstallPluginByFile(pluginName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installDynamicPlugin(File pluginFile) {
        String pluginName = pluginFile.getName();
        OLogManager.instance().info((Object)this, "Installing dynamic plugin '%s'...", new Object[]{pluginName});
        URLClassLoader pluginClassLoader = null;
        try {
            URL url = pluginFile.toURI().toURL();
            pluginClassLoader = new URLClassLoader(new URL[]{url});
            URL r = pluginClassLoader.findResource("plugin.json");
            if (r == null) {
                OLogManager.instance().error((Object)this, "Plugin definition file ('plugin.json') is not found for dynamic plugin '%s'", new Object[]{pluginName});
                throw new IllegalArgumentException(String.format("Plugin definition file ('plugin.json') is not found for dynamic plugin '%s'", pluginName));
            }
            InputStream pluginConfigFile = r.openStream();
            try {
                OServerPlugin pluginInstance;
                Map parameters;
                String pluginClass;
                if (pluginConfigFile == null || pluginConfigFile.available() == 0) {
                    OLogManager.instance().error((Object)this, "Error on loading 'plugin.json' file for dynamic plugin '%s'", new Object[]{pluginName});
                    throw new IllegalArgumentException(String.format("Error on loading 'plugin.json' file for dynamic plugin '%s'", pluginName));
                }
                ODocument properties = (ODocument)new ODocument().fromJSON(pluginConfigFile);
                if (properties.containsField("name")) {
                    pluginName = (String)properties.field("name");
                }
                if ((pluginClass = (String)properties.field("javaClass")) != null) {
                    parameters = (Map)properties.field("parameters");
                    ArrayList<OServerParameterConfiguration> params = new ArrayList<OServerParameterConfiguration>();
                    for (String paramName : parameters.keySet()) {
                        params.add(new OServerParameterConfiguration(paramName, (String)parameters.get(paramName)));
                    }
                    OServerParameterConfiguration[] pluginParams = params.toArray(new OServerParameterConfiguration[params.size()]);
                    pluginInstance = this.startPluginClass(pluginClassLoader, pluginClass, pluginParams);
                } else {
                    pluginInstance = null;
                    parameters = null;
                }
                OServerPluginInfo currentPluginData = new OServerPluginInfo(pluginName, (String)properties.field("version"), (String)properties.field("description"), (String)properties.field("web"), pluginInstance, parameters, pluginFile.lastModified(), pluginClassLoader);
                this.registerPlugin(currentPluginData);
                this.loadedPlugins.put(pluginFile.getName(), pluginName);
                this.registerStaticDirectory(currentPluginData);
            }
            finally {
                pluginConfigFile.close();
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on installing dynamic plugin '%s'", (Throwable)e, new Object[]{pluginName});
        }
    }
}

