/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class OAsyncCommandResultListener
extends OAbstractCommandResultListener {
    private final ONetworkProtocolBinary protocol;
    private final AtomicBoolean empty = new AtomicBoolean(true);
    private final int txId;
    private final OCommandResultListener resultListener;

    public OAsyncCommandResultListener(ONetworkProtocolBinary iNetworkProtocolBinary, int txId, OCommandResultListener resultListener) {
        this.protocol = iNetworkProtocolBinary;
        this.txId = txId;
        this.resultListener = resultListener;
    }

    public boolean result(Object iRecord) {
        if (this.empty.compareAndSet(true, false)) {
            try {
                this.protocol.sendOk(this.txId);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        try {
            this.fetchRecord(iRecord, (OFetchListener)new ORemoteFetchListener(){

                protected void sendRecord(ORecord iLinked) {
                    try {
                        if (((OAsyncCommandResultListener)OAsyncCommandResultListener.this).protocol.connection.data.protocolVersion >= 17) {
                            ((OAsyncCommandResultListener)OAsyncCommandResultListener.this).protocol.channel.writeByte((byte)2);
                            OAsyncCommandResultListener.this.protocol.writeIdentifiable((OIdentifiable)iLinked);
                        }
                    }
                    catch (IOException e) {
                        OLogManager.instance().error((Object)this, "Cannot write against channel", (Throwable)e, new Object[0]);
                    }
                }
            });
            this.protocol.channel.writeByte((byte)1);
            this.protocol.writeIdentifiable((OIdentifiable)((OIdentifiable)iRecord).getRecord());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void end() {
        super.end();
        if (this.resultListener != null) {
            this.resultListener.end();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.empty.get();
    }
}

