/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.console.DefaultConsoleReader;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.memory.ODirectMemoryStorage;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.OServerShutdownHook;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.config.OServerSocketFactoryConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.OConfigurableHooksManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.OServerSocketFactory;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import com.orientechnologies.orient.server.plugin.OServerPluginManager;
import com.orientechnologies.orient.server.security.OSecurityServerUser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;

public class OServer {
    private static final String ROOT_PASSWORD_VAR = "ORIENTDB_ROOT_PASSWORD";
    private static ThreadGroup threadGroup;
    private static Map<String, OServer> distributedServers;
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean running = true;
    protected OServerConfigurationLoaderXml configurationLoader;
    protected OServerConfiguration configuration;
    protected OContextConfiguration contextConfiguration;
    protected OServerShutdownHook shutdownHook;
    protected Map<String, Class<? extends ONetworkProtocol>> networkProtocols = new HashMap<String, Class<? extends ONetworkProtocol>>();
    protected Map<String, OServerSocketFactory> networkSocketFactories = new HashMap<String, OServerSocketFactory>();
    protected List<OServerNetworkListener> networkListeners = new ArrayList<OServerNetworkListener>();
    protected List<OServerLifecycleListener> lifecycleListeners = new ArrayList<OServerLifecycleListener>();
    protected OServerPluginManager pluginManager;
    protected OConfigurableHooksManager hookManager;
    protected ODistributedServerManager distributedManager;
    private OPartitionedDatabasePoolFactory dbPoolFactory;
    private Random random = new Random();
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String serverRootDirectory;
    private String databaseDirectory;
    private final boolean shutdownEngineOnExit;

    public OServer() throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this(true);
    }

    public OServer(boolean shutdownEngineOnExit) throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.shutdownEngineOnExit = shutdownEngineOnExit;
        this.serverRootDirectory = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}", (String)".");
        OLogManager.installCustomFormatter();
        this.defaultSettings();
        threadGroup = new ThreadGroup("OrientDB Server");
        System.setProperty("com.sun.management.jmxremote", "true");
        Orient.instance().startup();
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean() && !Orient.instance().getProfiler().isRecording()) {
            Orient.instance().getProfiler().startRecording();
        }
        this.shutdownHook = new OServerShutdownHook(this);
    }

    public static OServer getInstance(String iServerId) {
        return distributedServers.get(iServerId);
    }

    public static void registerServerInstance(String iServerId, OServer iServer) {
        distributedServers.put(iServerId, iServer);
    }

    public OServer startup() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String config = "config/orientdb-server-config.xml";
        if (System.getProperty("orientdb.config.file") != null) {
            config = System.getProperty("orientdb.config.file");
        }
        Orient.instance().startup();
        this.startup(new File(OSystemVariableResolver.resolveSystemVariables((String)config)));
        return this;
    }

    public OServer startup(File iConfigurationFile) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        return this.startup(this.loadConfigurationFromFile(iConfigurationFile));
    }

    public OServer startup(String iConfiguration) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        return this.startup(new ByteArrayInputStream(iConfiguration.getBytes()));
    }

    public OServer startup(InputStream iInputStream) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        if (iInputStream == null) {
            throw new OConfigurationException("Configuration file is null");
        }
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iInputStream);
        this.configuration = this.configurationLoader.load();
        return this.startup(this.configuration);
    }

    public OServer startup(OServerConfiguration iConfiguration) throws IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        OLogManager.instance().info((Object)this, "OrientDB Server v" + OConstants.getVersion() + " is starting up...", new Object[0]);
        Orient.instance();
        this.loadConfiguration(iConfiguration);
        if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
            System.out.println("Dumping environment after server startup...");
            OGlobalConfiguration.dumpConfiguration((PrintStream)System.out);
        }
        this.dbPoolFactory = new OPartitionedDatabasePoolFactory();
        this.dbPoolFactory.setMaxPoolSize(this.contextConfiguration.getValueAsInteger(OGlobalConfiguration.DB_POOL_MAX));
        this.databaseDirectory = (String)this.contextConfiguration.getValue("server.database.path", (Object)(this.serverRootDirectory + "/databases/"));
        this.databaseDirectory = OFileUtils.getPath((String)OSystemVariableResolver.resolveSystemVariables((String)this.databaseDirectory));
        this.databaseDirectory = this.databaseDirectory.replace("//", "/");
        if (!this.databaseDirectory.endsWith("/")) {
            this.databaseDirectory = this.databaseDirectory + "/";
        }
        Orient.instance().getProfiler().registerHookValue("system.databases", "List of databases configured in Server", OProfilerMBean.METRIC_TYPE.TEXT, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                StringBuilder dbs = new StringBuilder(64);
                for (String dbName : OServer.this.getAvailableStorageNames().keySet()) {
                    if (dbs.length() > 0) {
                        dbs.append(',');
                    }
                    dbs.append(dbName);
                }
                return dbs.toString();
            }
        });
        OLogManager.instance().info((Object)this, "Databases directory: " + new File(this.databaseDirectory).getAbsolutePath(), new Object[0]);
        return this;
    }

    public OServer activate() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onBeforeActivate();
            }
            if (this.configuration.network.sockets != null) {
                for (OServerSocketFactoryConfiguration oServerSocketFactoryConfiguration : this.configuration.network.sockets) {
                    Class<?> fClass = Class.forName(oServerSocketFactoryConfiguration.implementation);
                    OServerSocketFactory factory = (OServerSocketFactory)fClass.newInstance();
                    try {
                        factory.config(oServerSocketFactoryConfiguration.name, oServerSocketFactoryConfiguration.parameters);
                        this.networkSocketFactories.put(oServerSocketFactoryConfiguration.name, factory);
                    }
                    catch (OConfigurationException e) {
                        OLogManager.instance().error((Object)this, "Error creating socket factory", (Throwable)e, new Object[0]);
                    }
                }
            }
            for (OServerNetworkProtocolConfiguration oServerNetworkProtocolConfiguration : this.configuration.network.protocols) {
                this.networkProtocols.put(oServerNetworkProtocolConfiguration.name, Class.forName(oServerNetworkProtocolConfiguration.implementation));
            }
            for (OServerNetworkListenerConfiguration oServerNetworkListenerConfiguration : this.configuration.network.listeners) {
                this.networkListeners.add(new OServerNetworkListener(this, this.networkSocketFactories.get(oServerNetworkListenerConfiguration.socket), oServerNetworkListenerConfiguration.ipAddress, oServerNetworkListenerConfiguration.portRange, oServerNetworkListenerConfiguration.protocol, this.networkProtocols.get(oServerNetworkListenerConfiguration.protocol), oServerNetworkListenerConfiguration.parameters, oServerNetworkListenerConfiguration.commands));
            }
            try {
                this.loadStorages();
                this.loadUsers();
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on reading server configuration", (Throwable)e, OConfigurationException.class, new Object[0]);
            }
            this.registerPlugins();
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onAfterActivate();
            }
            OLogManager.instance().info((Object)this, "OrientDB Server v2.0.12 is active.", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.running = false;
            throw e;
        }
        catch (InstantiationException e) {
            this.running = false;
            throw e;
        }
        catch (IllegalAccessException e) {
            this.running = false;
            throw e;
        }
        catch (RuntimeException e) {
            this.running = false;
            throw e;
        }
        finally {
            this.startupLatch.countDown();
        }
        return this;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            this.shutdownHook.cancel();
            this.shutdownHook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        if (!this.running) {
            return false;
        }
        this.running = false;
        OLogManager.instance().info((Object)this, "OrientDB Server is shutting down...", new Object[0]);
        if (this.shutdownHook != null) {
            this.shutdownHook.cancel();
        }
        Orient.instance().getProfiler().unregisterHookValue("system.databases");
        for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
            oServerLifecycleListener.onBeforeDeactivate();
        }
        this.lock.lock();
        try {
            if (this.networkListeners.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutting down listeners:", new Object[0]);
                for (OServerNetworkListener oServerNetworkListener : this.networkListeners) {
                    OLogManager.instance().info((Object)this, "- %s", new Object[]{oServerNetworkListener});
                    try {
                        oServerNetworkListener.shutdown();
                    }
                    catch (Throwable e) {
                        OLogManager.instance().error((Object)this, "Error during shutdown of listener %s.", e, new Object[]{oServerNetworkListener});
                    }
                }
            }
            if (this.networkProtocols.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutting down protocols", new Object[0]);
                this.networkProtocols.clear();
            }
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                try {
                    oServerLifecycleListener.onAfterDeactivate();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during deactivation of server lifecycle listener %s", (Throwable)e, new Object[]{oServerLifecycleListener});
                }
            }
            if (this.pluginManager != null) {
                this.pluginManager.shutdown();
            }
            OClientConnectionManager.instance().shutdown();
        }
        finally {
            this.lock.unlock();
        }
        if (this.shutdownEngineOnExit && !Orient.isRegisterDatabaseByPath()) {
            try {
                OLogManager.instance().info((Object)this, "Shutting down databases:", new Object[0]);
                Orient.instance().shutdown();
            }
            catch (Throwable e) {
                OLogManager.instance().error((Object)this, "Error during OrientDB shutdown", e, new Object[0]);
            }
        }
        OLogManager.instance().info((Object)this, "OrientDB Server shutdown complete", new Object[0]);
        OLogManager.instance().flush();
        return true;
    }

    public String getStoragePath(String iName) {
        if (iName == null) {
            throw new IllegalArgumentException("Storage path is null");
        }
        String name = iName.indexOf(58) > -1 ? iName.substring(iName.indexOf(58) + 1) : iName;
        String dbName = Orient.isRegisterDatabaseByPath() ? this.getDatabaseDirectory() + name : name;
        String dbPath = Orient.isRegisterDatabaseByPath() ? dbName : this.getDatabaseDirectory() + name;
        OStorage stg = Orient.instance().getStorage(dbName);
        if (stg != null) {
            return stg.getURL();
        }
        String dbURL = this.configuration.getStoragePath(name);
        if (dbURL == null) {
            if (new File(OIOUtils.getPathFromDatabaseName((String)dbPath) + "/default.pcl").exists()) {
                dbURL = "plocal:" + dbPath;
            } else {
                throw new OConfigurationException("Database '" + name + "' is not configured on server (home=" + this.getDatabaseDirectory() + ")");
            }
        }
        return dbURL;
    }

    public Map<String, String> getAvailableStorageNames() {
        HashMap<String, String> storages = new HashMap<String, String>();
        if (this.configuration.storages != null && this.configuration.storages.length > 0) {
            for (OServerStorageConfiguration s : this.configuration.storages) {
                storages.put(OIOUtils.getDatabaseNameFromPath((String)s.name), s.path);
            }
        }
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(new File(rootDirectory), storages);
        for (OStorage storage : Orient.instance().getStorages()) {
            String storageUrl = storage.getURL();
            if (!(storage instanceof OAbstractPaginatedStorage) || !storage.exists() || storages.containsValue(storageUrl) || !this.isStorageOfCurrentServerInstance(storage)) continue;
            storages.put(OIOUtils.getDatabaseNameFromPath((String)storage.getName()), storageUrl);
        }
        return storages;
    }

    public String getStorageURL(String iName) {
        if (this.configuration.storages != null && this.configuration.storages.length > 0) {
            for (OServerStorageConfiguration s : this.configuration.storages) {
                if (!s.name.equals(iName)) continue;
                return s.path;
            }
        }
        HashMap<String, String> storages = new HashMap<String, String>();
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(new File(rootDirectory), storages);
        return (String)storages.get(iName);
    }

    public String getDatabaseDirectory() {
        return this.databaseDirectory;
    }

    public ThreadGroup getServerThreadGroup() {
        return threadGroup;
    }

    public OServerUserConfiguration serverLogin(String iUser, String iPassword, String iResource) {
        if (!this.authenticate(iUser, iPassword, iResource)) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance. Get the user/password from the config/orientdb-server-config.xml file");
        }
        return this.getUser(iUser);
    }

    public boolean authenticate(String iUserName, String iPassword, String iResourceToCheck) {
        OServerUserConfiguration user = this.getUser(iUserName);
        if (user != null && user.password.equals(iPassword)) {
            String[] resourceParts;
            if (user.resources.equals("*")) {
                return true;
            }
            for (String r : resourceParts = user.resources.split(",")) {
                if (!r.equals(iResourceToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAllowed(String iUserName, String iResourceToCheck) {
        OServerUserConfiguration user = this.getUser(iUserName);
        if (user != null) {
            String[] resourceParts;
            if (user.resources.equals("*")) {
                return true;
            }
            for (String r : resourceParts = user.resources.split(",")) {
                if (!r.equals(iResourceToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public OServerUserConfiguration getUser(String iUserName) {
        return this.configuration.getUser(iUserName);
    }

    public boolean existsStoragePath(String iURL) {
        return this.configuration.getStoragePath(iURL) != null;
    }

    public OServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void saveConfiguration() throws IOException {
        if (this.configurationLoader != null) {
            this.configurationLoader.save(this.configuration);
        }
    }

    public Map<String, Class<? extends ONetworkProtocol>> getNetworkProtocols() {
        return this.networkProtocols;
    }

    public List<OServerNetworkListener> getNetworkListeners() {
        return this.networkListeners;
    }

    public <RET extends OServerNetworkListener> RET getListenerByProtocol(Class<? extends ONetworkProtocol> iProtocolClass) {
        for (OServerNetworkListener l : this.networkListeners) {
            if (!iProtocolClass.isAssignableFrom(l.getProtocolType())) continue;
            return (RET)l;
        }
        return null;
    }

    public Collection<OServerPluginInfo> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public <RET extends OServerPlugin> RET getPluginByClass(Class<RET> iPluginClass) {
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.running) {
            throw new ODatabaseException("Error on plugin lookup the server didn't start correcty.");
        }
        for (OServerPluginInfo h : this.getPlugins()) {
            if (h.getInstance() == null || !h.getInstance().getClass().equals(iPluginClass)) continue;
            return (RET)h.getInstance();
        }
        return null;
    }

    public <RET extends OServerPlugin> RET getPlugin(String iName) {
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.running) {
            throw new ODatabaseException("Error on plugin lookup the server didn't start correcty.");
        }
        OServerPluginInfo p = this.pluginManager.getPluginByName(iName);
        if (p != null) {
            return (RET)p.getInstance();
        }
        return null;
    }

    public Object getVariable(String iName) {
        return this.variables.get(iName);
    }

    public OServer setVariable(String iName, Object iValue) {
        if (iValue == null) {
            this.variables.remove(iName);
        } else {
            this.variables.put(iName, iValue);
        }
        return this;
    }

    public void addUser(String iName, String iPassword, String iPermissions) throws IOException {
        if (iName == null || iName.length() == 0) {
            throw new IllegalArgumentException("User name null or empty");
        }
        if (iPermissions == null || iPermissions.length() == 0) {
            throw new IllegalArgumentException("User permissions null or empty");
        }
        this.configuration.users = this.configuration.users == null ? new OServerUserConfiguration[1] : Arrays.copyOf(this.configuration.users, this.configuration.users.length + 1);
        if (iPassword == null) {
            iPassword = OSecurityManager.instance().digest2String(String.valueOf(this.random.nextLong()), false);
        }
        this.configuration.users[this.configuration.users.length - 1] = new OServerUserConfiguration(iName, iPassword, iPermissions);
        this.saveConfiguration();
    }

    public OServer registerLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.add(iListener);
        return this;
    }

    public OServer unregisterLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.remove(iListener);
        return this;
    }

    public ODatabase<?> openDatabase(String iDbType, String iDbUrl, OToken iToken) {
        String path = this.getStoragePath(iDbUrl);
        ODatabaseDocumentTx database = Orient.instance().getDatabaseFactory().createDatabase(iDbType, path);
        if (database.isClosed()) {
            if (database.getStorage() instanceof ODirectMemoryStorage) {
                database.create();
            } else {
                database.open(iToken);
            }
        }
        return database;
    }

    public ODatabase<?> openDatabase(String iDbType, String iDbUrl, String user, String password) {
        return this.openDatabase(iDbType, iDbUrl, user, password, null);
    }

    public ODatabase<?> openDatabase(String iDbType, String iDbUrl, String user, String password, ONetworkProtocolData data) {
        ODatabaseDocumentTx database;
        block10: {
            String path = this.getStoragePath(iDbUrl);
            database = Orient.instance().getDatabaseFactory().createDatabase(iDbType, path);
            OStorage storage = database.getStorage();
            if (database.isClosed()) {
                if (database.getStorage() instanceof ODirectMemoryStorage && !storage.exists()) {
                    try {
                        database.create();
                    }
                    catch (OStorageException e) {}
                } else {
                    try {
                        database.open(user, password);
                        if (data != null) {
                            data.serverUser = false;
                            data.serverUsername = null;
                        }
                    }
                    catch (OSecurityException e) {
                        try {
                            this.serverLogin(user, password, "database.passthrough");
                        }
                        catch (OSecurityException ex) {
                            throw e;
                        }
                        database.resetInitialization();
                        database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityServerUser.class);
                        database.open(user, password);
                        if (data == null) break block10;
                        data.serverUser = true;
                        data.serverUsername = user;
                    }
                }
            }
        }
        return database;
    }

    public ODatabaseInternal openDatabase(ODatabaseInternal database) {
        if (database.isClosed()) {
            if (database.getStorage() instanceof ODirectMemoryStorage) {
                database.create();
            } else {
                OServerUserConfiguration replicatorUser = this.getUser("replicator");
                this.serverLogin(replicatorUser.name, replicatorUser.password, "database.passthrough");
                database.resetInitialization();
                database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityServerUser.class);
                database.open(replicatorUser.name, replicatorUser.password);
            }
        }
        return database;
    }

    public ODistributedServerManager getDistributedManager() {
        return this.distributedManager;
    }

    public OPartitionedDatabasePoolFactory getDatabasePoolFactory() {
        return this.dbPoolFactory;
    }

    public void setServerRootDirectory(String rootDirectory) {
        this.serverRootDirectory = rootDirectory;
    }

    protected void loadConfiguration(OServerConfiguration iConfiguration) {
        this.configuration = iConfiguration;
        this.contextConfiguration = new OContextConfiguration();
        if (iConfiguration.properties != null) {
            for (OServerEntryConfiguration prop : iConfiguration.properties) {
                this.contextConfiguration.setValue(prop.name, (Object)prop.value);
            }
        }
        this.hookManager = new OConfigurableHooksManager(iConfiguration);
    }

    protected OServerConfiguration loadConfigurationFromFile(File iFile) {
        try {
            this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iFile);
            return this.configurationLoader.load();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration from file: " + iFile, (Throwable)e, OConfigurationException.class, new Object[0]);
            return null;
        }
    }

    protected void loadUsers() throws IOException {
        if (this.configuration.users != null && this.configuration.users.length > 0) {
            for (OServerUserConfiguration u : this.configuration.users) {
                if (!u.name.equals("root")) continue;
                return;
            }
        }
        this.createDefaultServerUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStorages() {
        if (this.configuration.storages == null) {
            return;
        }
        for (OServerStorageConfiguration stg : this.configuration.storages) {
            int idx;
            if (!stg.loadOnStartup) continue;
            if (stg.userName == null) {
                stg.userName = "admin";
            }
            if (stg.userPassword == null) {
                stg.userPassword = "admin";
            }
            if ((idx = stg.path.indexOf(58)) == -1) {
                OLogManager.instance().error((Object)this, "-> Invalid path '" + stg.path + "' for database '" + stg.name + "'", new Object[0]);
                return;
            }
            String type = stg.path.substring(0, idx);
            ODatabaseDocumentTx db = null;
            try {
                db = new ODatabaseDocumentTx(stg.path);
                if (db.exists()) {
                    db.open(stg.userName, stg.userPassword);
                } else {
                    db.create();
                    if (stg.userName.equals("admin")) {
                        if (!stg.userPassword.equals("admin")) {
                            db.getMetadata().getSecurity().getUser("admin").setPassword(stg.userPassword);
                        }
                    } else {
                        db.getMetadata().getSecurity().createUser(stg.userName, stg.userPassword, new String[]{"admin"});
                        db.getMetadata().getSecurity().dropUser("admin");
                        db.close();
                        db.open(stg.userName, stg.userPassword);
                    }
                }
                OLogManager.instance().info((Object)this, "-> Loaded " + type + " database '" + stg.name + "'", new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "-> Cannot load " + type + " database '" + stg.name + "': " + e, new Object[0]);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    protected void createDefaultServerUsers() throws IOException {
        String rootPassword = OSystemVariableResolver.resolveVariable((String)ROOT_PASSWORD_VAR);
        if (rootPassword != null && (rootPassword = rootPassword.trim()).isEmpty()) {
            rootPassword = null;
        }
        if (rootPassword == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.out.println();
            System.out.println();
            System.out.println("+---------------------------------------------------------------+");
            System.out.println("|                WARNING: FIRST RUN CONFIGURATION               |");
            System.out.println("+---------------------------------------------------------------+");
            System.out.println("| This is the first time the server is running. Please type a   |");
            System.out.println("| password of your choice for the 'root' user or leave it blank |");
            System.out.println("| to auto-generate it.                                          |");
            System.out.println("|                                                               |");
            System.out.println("| To avoid this message set the environment variable or JVM     |");
            System.out.println("| setting ORIENTDB_ROOT_PASSWORD to the root password to use.   |");
            System.out.println("+---------------------------------------------------------------+");
            System.out.print("\nRoot password [BLANK=auto generate it]: ");
            DefaultConsoleReader reader = new DefaultConsoleReader();
            rootPassword = reader.readLine();
            if (rootPassword != null && (rootPassword = rootPassword.trim()).isEmpty()) {
                rootPassword = null;
            }
        }
        this.addUser("root", rootPassword, "*");
        this.addUser("guest", "guest", "connect,server.listDatabases,server.dblist");
        this.saveConfiguration();
    }

    protected void registerPlugins() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.pluginManager = new OServerPluginManager();
        this.pluginManager.config(this);
        this.pluginManager.startup();
        if (this.configuration.handlers != null) {
            for (OServerHandlerConfiguration h : this.configuration.handlers) {
                OServerPlugin handler;
                if (h.parameters != null) {
                    boolean enabled = true;
                    for (OServerParameterConfiguration p : h.parameters) {
                        if (!p.name.equals("enabled")) continue;
                        enabled = false;
                        String value = OSystemVariableResolver.resolveSystemVariables((String)p.value);
                        if (value == null || !"true".equalsIgnoreCase(value = value.trim())) continue;
                        enabled = true;
                        break;
                    }
                    if (!enabled) continue;
                }
                if ((handler = (OServerPlugin)Class.forName(h.clazz).newInstance()) instanceof ODistributedServerManager) {
                    this.distributedManager = (ODistributedServerManager)((Object)handler);
                }
                this.pluginManager.registerPlugin(new OServerPluginInfo(handler.getName(), null, null, null, handler, null, 0L, null));
                handler.config(this, h.parameters);
                handler.startup();
            }
        }
    }

    protected void defaultSettings() {
    }

    private boolean isStorageOfCurrentServerInstance(OStorage storage) {
        if (storage.getUnderlying() instanceof OLocalPaginatedStorage) {
            String rootDirectory = this.getDatabaseDirectory();
            return storage.getURL().contains(rootDirectory);
        }
        return true;
    }

    private void scanDatabaseDirectory(File directory, Map<String, String> storages) {
        File[] files;
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File db : files) {
                if (!db.isDirectory()) continue;
                File plocalFile = new File(db.getAbsolutePath() + "/default.pcl");
                String dbPath = db.getPath().replace('\\', '/');
                int lastBS = dbPath.lastIndexOf(47, dbPath.length() - 1) + 1;
                if (plocalFile.exists()) {
                    storages.put(OIOUtils.getDatabaseNameFromPath((String)dbPath.substring(lastBS)), "plocal:" + dbPath);
                    continue;
                }
                this.scanDatabaseDirectory(db, storages);
            }
        }
    }

    static {
        distributedServers = new ConcurrentHashMap<String, OServer>();
    }
}

