/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.server.distributed.ODiscardedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ODistributedResponseManager {
    public static final int ADDITIONAL_TIMEOUT_CLUSTER_SHAPE = 10000;
    private static final String NO_RESPONSE = "waiting-for-response";
    private final ODistributedServerManager dManager;
    private final ODistributedRequest request;
    private final long sentOn;
    private final HashMap<String, Object> responses = new HashMap();
    private final boolean groupResponsesByResult;
    private final List<List<ODistributedResponse>> responseGroups = new ArrayList<List<ODistributedResponse>>();
    private final int expectedSynchronousResponses;
    private final long synchTimeout;
    private final long totalTimeout;
    private final Lock synchronousResponsesLock = new ReentrantLock();
    private final Condition synchronousResponsesArrived = this.synchronousResponsesLock.newCondition();
    private final int quorum;
    private final boolean waitForLocalNode;
    private volatile int receivedResponses = 0;
    private volatile int discardedResponses = 0;
    private volatile boolean receivedCurrentNode;
    private Object responseLock = new Object();

    public ODistributedResponseManager(ODistributedServerManager iManager, ODistributedRequest iRequest, Collection<String> expectedResponses, int iExpectedSynchronousResponses, int iQuorum, boolean iWaitForLocalNode, long iSynchTimeout, long iTotalTimeout, boolean iGroupResponsesByResult) {
        this.dManager = iManager;
        this.request = iRequest;
        this.sentOn = System.currentTimeMillis();
        this.expectedSynchronousResponses = iExpectedSynchronousResponses;
        this.quorum = iQuorum;
        this.waitForLocalNode = iWaitForLocalNode;
        this.synchTimeout = iSynchTimeout;
        this.totalTimeout = iTotalTimeout;
        this.groupResponsesByResult = iGroupResponsesByResult;
        for (String node : expectedResponses) {
            this.responses.put(node, NO_RESPONSE);
        }
        if (this.groupResponsesByResult) {
            this.responseGroups.add(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectResponse(ODistributedResponse response) {
        String executorNode = response.getExecutorNodeName();
        Object object = this.responseLock;
        synchronized (object) {
            if (!this.responses.containsKey(executorNode)) {
                ODistributedServerLog.warn((Object)this, response.getSenderNodeName(), executorNode, ODistributedServerLog.DIRECTION.IN, "received response for request (%s) from unexpected node. Expected are: %s", this.request, this.getExpectedNodes());
                Orient.instance().getProfiler().updateCounter("distributed.node.unexpectedNodeResponse", "Number of responses from unexpected nodes", 1L);
                return false;
            }
            Orient.instance().getProfiler().stopChrono("distributed.node.latency", "Latency of distributed messages", this.sentOn, "distributed.node.latency");
            Orient.instance().getProfiler().stopChrono("distributed.node." + executorNode + ".latency", "Latency of distributed messages per node", this.sentOn, "distributed.node.*.latency");
            boolean completed = false;
            this.responses.put(executorNode, response);
            ++this.receivedResponses;
            if (this.waitForLocalNode && response.isExecutedOnLocalNode()) {
                this.receivedCurrentNode = true;
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, response.getSenderNodeName(), executorNode, ODistributedServerLog.DIRECTION.IN, "received response '%s' for request (%s) (receivedCurrentNode=%s receivedResponses=%d expectedSynchronousResponses=%d quorum=%d)", response, this.request, this.receivedCurrentNode, this.receivedResponses, this.expectedSynchronousResponses, this.quorum);
            }
            if (response.getPayload() instanceof ODiscardedResponse) {
                ++this.discardedResponses;
            } else if (this.groupResponsesByResult) {
                boolean foundBucket = false;
                for (int i = 0; i < this.responseGroups.size(); ++i) {
                    List<ODistributedResponse> responseGroup = this.responseGroups.get(i);
                    if (responseGroup.isEmpty()) {
                        foundBucket = true;
                    } else {
                        Object rgPayload = responseGroup.get(0).getPayload();
                        Object responsePayload = response.getPayload();
                        if (rgPayload == null && responsePayload == null) {
                            foundBucket = true;
                        } else if (rgPayload != null) {
                            if (rgPayload.equals(responsePayload)) {
                                foundBucket = true;
                            } else if (rgPayload instanceof Collection && responsePayload instanceof Collection && OMultiValue.equals((Collection)((Collection)rgPayload), (Collection)((Collection)responsePayload))) {
                                foundBucket = true;
                            }
                        }
                    }
                    if (!foundBucket) continue;
                    responseGroup.add(response);
                    break;
                }
                if (!foundBucket) {
                    ArrayList<ODistributedResponse> newBucket = new ArrayList<ODistributedResponse>();
                    this.responseGroups.add(newBucket);
                    newBucket.add(response);
                }
            }
            boolean bl = completed = this.getExpectedResponses() == this.receivedResponses;
            if (this.receivedResponses >= this.expectedSynchronousResponses && (!this.waitForLocalNode || this.receivedCurrentNode) && (completed || this.isMinimumQuorumReached(false))) {
                this.notifyWaiters();
            }
            return completed;
        }
    }

    public void notifyWaiters() {
        this.synchronousResponsesLock.lock();
        try {
            this.synchronousResponsesArrived.signalAll();
        }
        finally {
            this.synchronousResponsesLock.unlock();
        }
    }

    public long getMessageId() {
        return this.request.getId();
    }

    public long getSentOn() {
        return this.sentOn;
    }

    public ODistributedResponse merge(ODistributedResponse merged) {
        StringBuilder executor = new StringBuilder(64);
        HashSet mergedPayload = new HashSet();
        for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
            if (entry.getValue() == NO_RESPONSE) continue;
            if (executor.length() > 0) {
                executor.append(',');
            }
            executor.append(entry.getKey());
            ODistributedResponse response = (ODistributedResponse)entry.getValue();
            Object payload = response.getPayload();
            mergedPayload = (HashSet)OMultiValue.add(mergedPayload, (Object)payload);
        }
        merged.setExecutorNodeName(executor.toString());
        merged.setPayload(mergedPayload);
        return merged;
    }

    public int getExpectedSynchronousResponses() {
        return this.expectedSynchronousResponses;
    }

    public int getQuorum() {
        return this.quorum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSynchronousResponses() throws InterruptedException {
        long beginTime = System.currentTimeMillis();
        this.synchronousResponsesLock.lock();
        try {
            long currentTimeout = this.synchTimeout;
            while (currentTimeout > 0L && (this.waitForLocalNode && !this.receivedCurrentNode || this.receivedResponses < this.expectedSynchronousResponses)) {
                this.synchronousResponsesArrived.await(currentTimeout, TimeUnit.MILLISECONDS);
                if ((!this.waitForLocalNode || this.receivedCurrentNode) && this.receivedResponses >= this.expectedSynchronousResponses) break;
                if (Thread.currentThread().isInterrupted()) {
                    ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "thread has been interrupted wait for request (%s)", this.request);
                    Thread.currentThread().interrupt();
                    break;
                }
                long now = System.currentTimeMillis();
                long elapsed = now - beginTime;
                currentTimeout = this.synchTimeout - elapsed;
                int synchronizingNodes = 0;
                int missingActiveNodes = 0;
                Object object = this.responseLock;
                synchronized (object) {
                    for (Map.Entry<String, Object> curr : this.responses.entrySet()) {
                        if (curr.getValue() != NO_RESPONSE) continue;
                        ODistributedServerManager.DB_STATUS dbStatus = this.dManager.getDatabaseStatus(curr.getKey(), this.getDatabaseName());
                        switch (dbStatus) {
                            case SYNCHRONIZING: {
                                ++synchronizingNodes;
                                ++missingActiveNodes;
                                break;
                            }
                            case ONLINE: {
                                ++missingActiveNodes;
                            }
                        }
                    }
                }
                if (missingActiveNodes == 0) {
                    ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "no more active nodes to wait for request (%s): anticipate timeout (saved %d ms)", this.request, currentTimeout);
                    break;
                }
                long lastClusterChange = this.dManager.getLastClusterChangeOn();
                if (lastClusterChange > 0L && now - lastClusterChange < this.synchTimeout + 10000L) {
                    currentTimeout = this.synchTimeout;
                    ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "cluster shape changed during request (%s): enlarge timeout +%dms, wait again for %dms", this.request, this.synchTimeout, currentTimeout);
                    continue;
                }
                if (synchronizingNodes <= 0) continue;
                currentTimeout = this.synchTimeout;
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "%d nodes are in synchronization mode during request (%s): enlarge timeout +%dms, wait again for %dms", synchronizingNodes, this.request, this.synchTimeout, currentTimeout);
            }
            boolean bl = this.receivedResponses >= this.expectedSynchronousResponses;
            return bl;
        }
        finally {
            this.synchronousResponsesLock.unlock();
            Orient.instance().getProfiler().stopChrono("distributed.synchResponses", "Time to collect all the synchronous responses from distributed nodes", beginTime);
        }
    }

    public boolean isWaitForLocalNode() {
        return this.waitForLocalNode;
    }

    public boolean isReceivedCurrentNode() {
        return this.receivedCurrentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedResponse getFinalResponse() {
        Object object = this.responseLock;
        synchronized (object) {
            this.manageConflicts();
            if (this.receivedResponses == 0) {
                throw new ODistributedException("No response received from any of nodes " + this.getExpectedNodes() + " for request " + this.request);
            }
            switch (this.request.getTask().getResultStrategy()) {
                case ANY: {
                    break;
                }
                case UNION: {
                    HashMap<String, Object> payloads = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
                        if (entry.getValue() == NO_RESPONSE) continue;
                        payloads.put(entry.getKey(), ((ODistributedResponse)entry.getValue()).getPayload());
                    }
                    ODistributedResponse response = this.getReceivedResponses().iterator().next();
                    response.setExecutorNodeName(this.responses.keySet().toString());
                    response.setPayload(payloads);
                    return response;
                }
            }
            int bestResponsesGroupIndex = this.getBestResponsesGroup();
            List<ODistributedResponse> bestResponsesGroup = this.responseGroups.get(bestResponsesGroupIndex);
            return bestResponsesGroup.get(0);
        }
    }

    public String getDatabaseName() {
        return this.request.getDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout() {
        Object object = this.responseLock;
        synchronized (object) {
            this.manageConflicts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMissingNodes() {
        Object object = this.responseLock;
        synchronized (object) {
            ArrayList<String> missingNodes = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
                if (entry.getValue() != NO_RESPONSE) continue;
                missingNodes.add(entry.getKey());
            }
            return missingNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getExpectedNodes() {
        Object object = this.responseLock;
        synchronized (object) {
            return new HashSet<String>(this.responses.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRespondingNodes() {
        ArrayList<String> respondedNodes = new ArrayList<String>();
        Object object = this.responseLock;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : this.responses.entrySet()) {
                if (entry.getValue() == NO_RESPONSE) continue;
                respondedNodes.add(entry.getKey());
            }
        }
        return respondedNodes;
    }

    protected List<ODistributedResponse> getConflictResponses() {
        ArrayList<ODistributedResponse> servers = new ArrayList<ODistributedResponse>();
        int bestGroupSoFar = this.getBestResponsesGroup();
        for (int i = 0; i < this.responseGroups.size(); ++i) {
            if (i == bestGroupSoFar) continue;
            for (ODistributedResponse r : this.responseGroups.get(i)) {
                servers.add(r);
            }
        }
        return servers;
    }

    protected int getExpectedResponses() {
        return this.responses.size();
    }

    protected int getMissingResponses() {
        return this.getExpectedResponses() - this.receivedResponses;
    }

    protected int getReceivedResponsesCount() {
        return this.receivedResponses;
    }

    protected long getTotalTimeout() {
        return this.totalTimeout;
    }

    protected int getBestResponsesGroup() {
        int maxCoherentResponses = 0;
        int bestGroupSoFar = 0;
        for (int i = 0; i < this.responseGroups.size(); ++i) {
            int currentGroupSize = this.responseGroups.get(i).size();
            if (currentGroupSize <= maxCoherentResponses) continue;
            maxCoherentResponses = currentGroupSize;
            bestGroupSoFar = i;
        }
        return bestGroupSoFar;
    }

    protected boolean isMinimumQuorumReached(boolean iCheckAvailableNodes) {
        ODistributedConfiguration dbConfig;
        if (this.isWaitForLocalNode() && !this.isReceivedCurrentNode()) {
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), this.dManager.getLocalNodeName(), ODistributedServerLog.DIRECTION.IN, "no response received from local node about request %s", this.request);
            return false;
        }
        if (this.quorum == 0) {
            return true;
        }
        if (!this.groupResponsesByResult) {
            return this.receivedResponses >= this.quorum;
        }
        for (List<ODistributedResponse> group : this.responseGroups) {
            if (group.size() + this.discardedResponses < this.quorum) continue;
            return true;
        }
        if (this.receivedResponses < this.quorum && iCheckAvailableNodes && !(dbConfig = this.dManager.getDatabaseConfiguration(this.getDatabaseName())).getFailureAvailableNodesLessQuorum("*")) {
            int availableNodes = 0;
            for (Map.Entry<String, Object> r : this.responses.entrySet()) {
                if (!this.dManager.isNodeAvailable(r.getKey(), this.getDatabaseName())) continue;
                ++availableNodes;
            }
            if (availableNodes < this.quorum) {
                ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "overridden quorum (%d) for request (%s) because available nodes (%d) are less than quorum, received responses: %s", this.quorum, this.request, availableNodes, this.responses);
                return true;
            }
        }
        return false;
    }

    protected List<ODistributedResponse> getReceivedResponses() {
        ArrayList<ODistributedResponse> parsed = new ArrayList<ODistributedResponse>();
        for (Object r : this.responses.values()) {
            if (r == NO_RESPONSE) continue;
            parsed.add((ODistributedResponse)r);
        }
        return parsed;
    }

    protected void manageConflicts() {
        if (!this.groupResponsesByResult || this.request.getTask().getQuorumType() == OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE) {
            return;
        }
        if (this.dManager.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return;
        }
        int bestResponsesGroupIndex = this.getBestResponsesGroup();
        List<ODistributedResponse> bestResponsesGroup = this.responseGroups.get(bestResponsesGroupIndex);
        int maxCoherentResponses = bestResponsesGroup.size();
        int conflicts = this.getExpectedResponses() - (maxCoherentResponses + this.discardedResponses);
        if (this.isMinimumQuorumReached(true)) {
            if (this.responseGroups.size() == 1) {
                return;
            }
            if (this.checkNoWinnerCase(bestResponsesGroup)) {
                return;
            }
        } else {
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "detected %d node(s) in timeout or in conflict and quorum (%d) has not been reached, rolling back changes for request (%s)", conflicts, this.quorum, this.request);
            StringBuilder msg = new StringBuilder(256);
            msg.append("Quorum " + this.getQuorum() + " not reached for request (" + this.request + "). Elapsed=" + (System.currentTimeMillis() - this.sentOn) + "ms");
            List<ODistributedResponse> res = this.getConflictResponses();
            if (res.isEmpty()) {
                msg.append(" No server in conflict. ");
            } else {
                msg.append(" Servers in timeout/conflict are:");
                for (ODistributedResponse r : res) {
                    msg.append("\n - ");
                    msg.append(r.getExecutorNodeName());
                    msg.append(": ");
                    msg.append(r.getPayload());
                }
                msg.append("\n");
            }
            msg.append("Received: ");
            msg.append(this.responses);
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, msg.toString(), new Object[0]);
            this.undoRequest();
            throw new ODistributedException(msg.toString());
        }
        this.fixNodesInConflict(bestResponsesGroup, conflicts);
    }

    protected void undoRequest() {
        for (ODistributedResponse r : this.getReceivedResponses()) {
            OAbstractRemoteTask undoTask;
            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "sending undo message for request (%s) to server %s", this.request, r.getExecutorNodeName());
            OAbstractRemoteTask task = this.request.getTask();
            if (!(task instanceof OAbstractReplicatedTask) || (undoTask = ((OAbstractReplicatedTask)task).getUndoTask(this.request, r.getPayload())) == null) continue;
            this.dManager.sendRequest(this.request.getDatabaseName(), null, Collections.singleton(r.getExecutorNodeName()), undoTask, ODistributedRequest.EXECUTION_MODE.NO_RESPONSE);
        }
    }

    protected void fixNodesInConflict(List<ODistributedResponse> bestResponsesGroup, int conflicts) {
        ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "detected %d conflicts, but the quorum (%d) has been reached. Fixing remote records. Request (%s)", conflicts, this.quorum, this.request);
        ODistributedResponse goodResponse = bestResponsesGroup.get(0);
        for (List<ODistributedResponse> responseGroup : this.responseGroups) {
            if (responseGroup == bestResponsesGroup) continue;
            for (ODistributedResponse r : responseGroup) {
                ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "fixing response (%s) for request (%s) in server %s to be: %s", r, this.request, r.getExecutorNodeName(), goodResponse);
                OAbstractRemoteTask fixTask = ((OAbstractReplicatedTask)this.request.getTask()).getFixTask(this.request, this.request.getTask(), r.getPayload(), goodResponse.getPayload());
                if (fixTask == null) continue;
                this.dManager.sendRequest(this.request.getDatabaseName(), null, Collections.singleton(r.getExecutorNodeName()), fixTask, ODistributedRequest.EXECUTION_MODE.NO_RESPONSE);
            }
        }
    }

    protected boolean checkNoWinnerCase(List<ODistributedResponse> bestResponsesGroup) {
        int maxCoherentResponses = bestResponsesGroup.size();
        if (maxCoherentResponses < this.quorum) {
            return false;
        }
        for (List<ODistributedResponse> responseGroup : this.responseGroups) {
            if (responseGroup == bestResponsesGroup || responseGroup.size() != maxCoherentResponses) continue;
            ArrayList<String> a = new ArrayList<String>();
            Object aResponse = null;
            for (ODistributedResponse r : bestResponsesGroup) {
                a.add(r.getExecutorNodeName());
                aResponse = r.getPayload();
            }
            ArrayList<String> b = new ArrayList<String>();
            Object bResponse = null;
            for (ODistributedResponse r : responseGroup) {
                b.add(r.getExecutorNodeName());
                bResponse = r.getPayload();
            }
            StringBuilder details = new StringBuilder();
            details.append(" A=").append(aResponse);
            details.append(", B=").append(bResponse);
            ODistributedServerLog.error((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "detected possible split brain network where 2 groups of servers A%s and B%s have different contents. Cannot decide who is the winner even if the quorum (%d) has been reached. Request (%s) responses:%s", a, b, this.quorum, this.request, details);
            return true;
        }
        return false;
    }
}

