/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ODistributedAbstractPlugin
extends OServerPluginAbstract
implements ODistributedServerManager,
ODatabaseLifecycleListener {
    public static final String REPLICATOR_USER = "replicator";
    protected static final String MASTER_AUTO = "$auto";
    protected static final String PAR_DEF_DISTRIB_DB_CONFIG = "configuration.db.default";
    protected static final String FILE_DISTRIBUTED_DB_CONFIG = "distributed-config.json";
    protected OServer serverInstance;
    protected Map<String, ODocument> cachedDatabaseConfiguration = new HashMap<String, ODocument>();
    protected boolean enabled = true;
    protected String nodeName = null;
    protected File defaultDatabaseConfigFile;
    protected ConcurrentHashMap<String, ODistributedStorage> storages = new ConcurrentHashMap();

    public static Object runInDistributedMode(Callable iCall) throws Exception {
        OScenarioThreadLocal.RUN_MODE currentRunningMode = OScenarioThreadLocal.INSTANCE.get();
        if (currentRunningMode != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            OScenarioThreadLocal.INSTANCE.set(OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED);
        }
        try {
            Object v = iCall.call();
            return v;
        }
        finally {
            if (currentRunningMode != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
                OScenarioThreadLocal.INSTANCE.set(OScenarioThreadLocal.RUN_MODE.DEFAULT);
            }
        }
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.LAST;
    }

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.serverInstance = oServer;
        oServer.setVariable("ODistributedAbstractPlugin", this);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(OSystemVariableResolver.resolveSystemVariables((String)param.value))) continue;
                this.enabled = false;
                return;
            }
            if (param.name.equalsIgnoreCase("nodeName")) {
                this.nodeName = param.value;
                continue;
            }
            if (param.name.startsWith(PAR_DEF_DISTRIB_DB_CONFIG)) {
                this.setDefaultDatabaseConfigFile(param.value);
                continue;
            }
            if (!param.name.equalsIgnoreCase("conflict.resolver.impl")) continue;
        }
        if (this.serverInstance.getUser(REPLICATOR_USER) == null) {
            try {
                this.serverInstance.addUser(REPLICATOR_USER, null, "database.passthrough");
                this.serverInstance.saveConfiguration();
            }
            catch (IOException e) {
                throw new OConfigurationException("Error on creating 'replicator' user", (Throwable)e);
            }
        }
    }

    public void setDefaultDatabaseConfigFile(String iFile) {
        this.defaultDatabaseConfigFile = new File(OSystemVariableResolver.resolveSystemVariables((String)iFile));
        if (!this.defaultDatabaseConfigFile.exists()) {
            throw new OConfigurationException("Cannot find distributed database config file: " + this.defaultDatabaseConfigFile);
        }
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        for (ODistributedStorage s : this.storages.values()) {
            try {
                s.shutdownAsynchronousWorker();
                s.close();
            }
            catch (Exception exception) {}
        }
        this.storages.clear();
        Orient.instance().removeDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(ODatabaseInternal iDatabase) {
        String dbUrl = OSystemVariableResolver.resolveSystemVariables((String)iDatabase.getURL());
        if (dbUrl.startsWith("plocal:")) {
            String dbDirectory = this.serverInstance.getDatabaseDirectory();
            if (!dbUrl.substring("plocal:".length()).startsWith(dbDirectory)) {
                return;
            }
        }
        Map<String, ODocument> map = this.cachedDatabaseConfiguration;
        synchronized (map) {
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
            if (cfg == null) {
                return;
            }
            OStorage dbStorage = iDatabase.getStorage();
            if (iDatabase instanceof ODatabase && dbStorage instanceof OAbstractPaginatedStorage) {
                ODistributedStorage storage = this.storages.get(iDatabase.getURL());
                if (storage == null) {
                    storage = new ODistributedStorage(this.serverInstance, (OAbstractPaginatedStorage)dbStorage);
                    ODistributedStorage oldStorage = this.storages.putIfAbsent(iDatabase.getURL(), storage);
                    if (oldStorage != null) {
                        storage = oldStorage;
                    }
                }
                iDatabase.replaceStorage((OStorage)storage);
            }
        }
    }

    public void onCreate(ODatabaseInternal iDatabase) {
        this.onOpen(iDatabase);
    }

    public void onClose(ODatabaseInternal iDatabase) {
    }

    @Override
    public void sendShutdown() {
        super.sendShutdown();
    }

    public String getName() {
        return "cluster";
    }

    @Override
    public String getLocalNodeId() {
        return this.nodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCachedDatabaseConfiguration(String iDatabaseName, ODocument cfg, boolean iSaveToDisk) {
        Map<String, ODocument> map = this.cachedDatabaseConfiguration;
        synchronized (map) {
            Integer currVersion;
            Integer oldVersion;
            ODocument oldCfg = this.cachedDatabaseConfiguration.get(iDatabaseName);
            Integer n = oldVersion = oldCfg != null ? (Integer)oldCfg.field("version") : null;
            if (oldVersion == null) {
                oldVersion = 1;
            }
            if ((currVersion = (Integer)cfg.field("version")) == null) {
                currVersion = 1;
            }
            if (oldCfg != null && oldVersion > currVersion) {
                OLogManager.instance().warn((Object)this, "Skip saving of distributed configuration file for database '%s' because is unchanged (version %d)", new Object[]{iDatabaseName, (Integer)cfg.field("version")});
                return false;
            }
            this.cachedDatabaseConfiguration.put(iDatabaseName, cfg);
            ODistributedServerLog.warn((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "updated distributed configuration for database: %s:\n----------\n%s\n----------", iDatabaseName, cfg.toJSON("prettyPrint"));
            if (iSaveToDisk) {
                FileOutputStream f = null;
                try {
                    File file = this.getDistributedConfigFile(iDatabaseName);
                    ODistributedServerLog.info((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Saving distributed configuration file for database '%s' to: %s", iDatabaseName, file);
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    }
                    f = new FileOutputStream(file);
                    f.write(cfg.toJSON().getBytes());
                    f.flush();
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on saving distributed configuration file", e, new Object[0]);
                }
                finally {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName) {
        Map<String, ODocument> map = this.cachedDatabaseConfiguration;
        synchronized (map) {
            ODistributedConfiguration dCfg;
            ODocument cfg = this.cachedDatabaseConfiguration.get(iDatabaseName);
            if (cfg == null) {
                File specificDatabaseConfiguration = this.getDistributedConfigFile(iDatabaseName);
                cfg = this.loadDatabaseConfiguration(iDatabaseName, specificDatabaseConfiguration);
                if (cfg == null && (cfg = this.loadDatabaseConfiguration(iDatabaseName, this.defaultDatabaseConfigFile)) == null) {
                    throw new OConfigurationException("Cannot load default distributed database config file: " + this.defaultDatabaseConfigFile);
                }
                this.cachedDatabaseConfiguration.put(iDatabaseName, cfg);
            }
            if ((dCfg = new ODistributedConfiguration(cfg)).upgrade()) {
                this.updateCachedDatabaseConfiguration(iDatabaseName, dCfg.serialize(), true);
            }
            return dCfg;
        }
    }

    public File getDistributedConfigFile(String iDatabaseName) {
        return new File(this.serverInstance.getDatabaseDirectory() + iDatabaseName + "/" + FILE_DISTRIBUTED_DB_CONFIG);
    }

    public OServer getServerInstance() {
        return this.serverInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODocument loadDatabaseConfiguration(String iDatabaseName, File file) {
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        ODistributedServerLog.info((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "loaded database configuration from disk: %s", file);
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            f.read(buffer);
            ODocument doc = new ODocument().fromJSON(new String(buffer), "noMap");
            doc.field("version", (Object)0);
            this.updateCachedDatabaseConfiguration(iDatabaseName, doc, false);
            ODocument oDocument = doc;
            return oDocument;
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on loading distributed configuration file in: %s", e, file.getAbsolutePath());
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

