/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OUpdateRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    protected byte[] previousContent;
    protected ORecordVersion previousVersion;
    protected byte[] content;

    public OUpdateRecordTask() {
    }

    public OUpdateRecordTask(ORecordId iRid, byte[] iPreviousContent, ORecordVersion iPreviousVersion, byte[] iContent, ORecordVersion iVersion) {
        super(iRid, iVersion);
        this.previousContent = iPreviousContent;
        this.previousVersion = iPreviousVersion;
        this.content = iContent;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "updating record %s/%s v.%s", database.getName(), this.rid.toString(), this.version.toString());
        ORecord loadedRecord = this.rid.getRecord();
        if (loadedRecord == null) {
            throw new ORecordNotFoundException("Record " + this.rid + " was not found on update");
        }
        if (loadedRecord instanceof ODocument) {
            ODocument newDocument = new ODocument().fromStream(this.content);
            ((ODocument)loadedRecord).merge(newDocument, false, false).getRecordVersion().copyFrom(this.version);
        } else {
            ORecordInternal.fill((ORecord)loadedRecord, (ORID)this.rid, (ORecordVersion)this.version, (byte[])this.content, (boolean)true);
        }
        loadedRecord = database.save(loadedRecord);
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> updated record %s/%s v.%s", database.getName(), this.rid.toString(), loadedRecord.getRecordVersion().toString());
        return loadedRecord.getRecordVersion();
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.WRITE;
    }

    @Override
    public OUpdateRecordTask getFixTask(ODistributedRequest iRequest, OAbstractRemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse) {
        ORecordVersion versionCopy = this.version.copy();
        versionCopy.setRollbackMode();
        return new OUpdateRecordTask(this.rid, null, null, ((OUpdateRecordTask)iOriginalTask).content, versionCopy);
    }

    @Override
    public OAbstractRemoteTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        ORecordVersion versionCopy = this.previousVersion.copy();
        versionCopy.setRollbackMode();
        return new OUpdateRecordTask(this.rid, null, null, this.previousContent, versionCopy);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.content.length);
        out.write(this.content);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
    }

    public byte[] getPreviousContent() {
        return this.previousContent;
    }

    public ORecordVersion getPreviousVersion() {
        return this.previousVersion;
    }

    @Override
    public String getName() {
        return "record_update";
    }

    @Override
    public String toString() {
        if (this.version.isTemporary()) {
            return this.getName() + "(" + this.rid + " v." + (this.version.getCounter() - Integer.MIN_VALUE) + " realV." + this.version + ")";
        }
        return super.toString();
    }

    public byte[] getContent() {
        return this.content;
    }
}

