/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ODistributedConfiguration {
    public static final String NEW_NODE_TAG = "<NEW_NODE>";
    private ODocument configuration;

    public ODistributedConfiguration(ODocument iConfiguration) {
        this.configuration = iConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicationActive(String iClusterName, String iLocalNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Collection servers = (Collection)this.getClusterConfiguration(iClusterName).field("servers");
            return servers != null && !servers.isEmpty();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHotAlignment() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Boolean value = (Boolean)this.configuration.field("hotAlignment");
            if (value != null) {
                return value;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("readQuorum");
            if (value == null && (value = this.configuration.field("readQuorum")) == null) {
                OLogManager.instance().warn((Object)this, "readQuorum setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return 1;
            }
            return (Integer)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWriteQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("writeQuorum");
            if (value == null && (value = this.configuration.field("writeQuorum")) == null) {
                OLogManager.instance().warn((Object)this, "writeQuorum setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return 2;
            }
            return (Integer)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFailureAvailableNodesLessQuorum(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("failureAvailableNodesLessQuorum");
            if (value == null && (value = this.configuration.field("failureAvailableNodesLessQuorum")) == null) {
                OLogManager.instance().warn((Object)this, "failureAvailableNodesLessQuorum setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return false;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isExecutionModeSynchronous(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("executionMode");
            if (value == null && (value = this.configuration.field("executionMode")) == null) {
                return null;
            }
            if (value.toString().equalsIgnoreCase("undefined")) {
                return null;
            }
            return value.toString().equalsIgnoreCase("synchronous");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isReadYourWrites(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.getClusterConfiguration(iClusterName).field("readYourWrites");
            if (value == null && (value = this.configuration.field("readYourWrites")) == null) {
                OLogManager.instance().warn((Object)this, "readYourWrites setting not found for cluster=%s in distributed-config.json", new Object[]{iClusterName});
                return true;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOfflineMsgQueueSize() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Object value = this.configuration.field("offlineMsgQueueSize");
            if (value != null) {
                return (Integer)value;
            }
            OLogManager.instance().debug((Object)this, "offlineMsgQueueSize setting not found in distributed-config.json", new Object[0]);
            return 100;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getOneServerPerCluster(Collection<String> iClusterNames, String iLocalNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (iClusterNames == null || iClusterNames.isEmpty()) {
                iClusterNames = Collections.singleton("*");
            }
            HashSet<String> partitions = new HashSet<String>(iClusterNames.size());
            block3: for (String p : iClusterNames) {
                List serverList = (List)this.getClusterConfiguration(p).field("servers");
                if (serverList == null) continue;
                boolean localNodeFound = false;
                for (String s : serverList) {
                    if (!s.equals(iLocalNode)) continue;
                    partitions.add(s);
                    localNodeFound = true;
                    break;
                }
                if (localNodeFound) continue;
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG)) continue;
                    partitions.add(s);
                    continue block3;
                }
            }
            return partitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalCluster(Collection<String> iClusterNames, String iLocalNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (iClusterNames == null || iClusterNames.isEmpty()) {
                iClusterNames = Collections.singleton("*");
            }
            for (String p : iClusterNames) {
                String masterServer = this.getMasterServer(p);
                if (!iLocalNode.equals(masterServer)) continue;
                return p;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getServers(Collection<String> iClusterNames) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (iClusterNames == null || iClusterNames.isEmpty()) {
                iClusterNames = Collections.singleton("*");
            }
            HashSet<String> partitions = new HashSet<String>(iClusterNames.size());
            for (String p : iClusterNames) {
                List serverList = (List)this.getClusterConfiguration(p).field("servers");
                if (serverList == null) continue;
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG)) continue;
                    partitions.add(s);
                }
            }
            return partitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getServers(String iClusterName, String iExclude) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            List serverList = (List)this.getClusterConfiguration(iClusterName).field("servers");
            if (serverList != null) {
                ArrayList<String> filteredServerList = new ArrayList<String>(serverList.size());
                for (String s : serverList) {
                    if (s.equals(NEW_NODE_TAG) || iExclude != null && iExclude.equals(s)) continue;
                    filteredServerList.add(s);
                }
                return filteredServerList;
            }
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMasterServer(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            String master = null;
            List serverList = (List)this.getClusterConfiguration(iClusterName).field("servers");
            if (serverList != null && !serverList.isEmpty() && NEW_NODE_TAG.equals(master = (String)serverList.get(0)) && serverList.size() > 1) {
                master = (String)serverList.get(1);
            }
            return master;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getOriginalServers(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return (List)this.getClusterConfiguration(iClusterName).field("servers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClusterNames() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            return clusters.fieldNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument getClusterConfiguration(String iClusterName) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument cfg;
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            if (clusters == null) {
                throw new OConfigurationException("Cannot find 'clusters' in distributed database configuration");
            }
            if (iClusterName == null) {
                iClusterName = "*";
            }
            if ((cfg = !clusters.containsField(iClusterName) ? (ODocument)clusters.field("*") : (ODocument)clusters.field(iClusterName)) == null) {
                return new ODocument();
            }
            return cfg;
        }
    }

    public ODocument serialize() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> addNewNodeInServerList(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ArrayList<String> changedPartitions = new ArrayList<String>();
            for (String clusterName : this.getClusterNames()) {
                int newNodePos;
                List<String> partitions = this.getOriginalServers(clusterName);
                if (partitions == null || (newNodePos = partitions.indexOf(NEW_NODE_TAG)) <= -1 || partitions.contains(iNode)) continue;
                partitions.add(newNodePos, iNode);
                changedPartitions.add(clusterName);
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterServer(String iClusterName, String iServerName) {
        if (iClusterName == null) {
            throw new IllegalArgumentException("cluster name cannot be null");
        }
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            List<String> serverList;
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            ODocument cluster = (ODocument)clusters.field(iClusterName);
            if (cluster == null) {
                cluster = this.createCluster(iClusterName);
            }
            if ((serverList = this.getOriginalServers(iClusterName)) == null) {
                serverList = this.initClusterServers(cluster);
            }
            if (!serverList.isEmpty() && serverList.get(0).equals(iServerName)) {
                return;
            }
            Iterator<String> it = serverList.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(iServerName)) continue;
                it.remove();
                break;
            }
            serverList.add(0, iServerName);
            this.incrementVersion();
        }
    }

    public ODocument createCluster(String iClusterName) {
        ODocument clusters = (ODocument)this.configuration.field("clusters");
        ODocument cluster = (ODocument)clusters.field(iClusterName);
        if (cluster != null) {
            return clusters;
        }
        cluster = new ODocument();
        ODocumentInternal.addOwner((ODocument)cluster, (ORecordElement)clusters);
        clusters.field(iClusterName, (Object)cluster, new OType[]{OType.EMBEDDED});
        this.initClusterServers(cluster);
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> removeNodeInServerList(String iNode, boolean iForce) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            if (!iForce && this.isHotAlignment()) {
                return null;
            }
            ArrayList<String> changedPartitions = new ArrayList<String>();
            block3: for (String clusterName : this.getClusterNames()) {
                List<String> nodes = this.getOriginalServers(clusterName);
                if (nodes == null) continue;
                for (String node : nodes) {
                    if (!node.equals(iNode)) continue;
                    nodes.remove(node);
                    changedPartitions.add(clusterName);
                    continue block3;
                }
            }
            if (!changedPartitions.isEmpty()) {
                this.incrementVersion();
                return changedPartitions;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> removeMasterServer(String iServerName) {
        ArrayList<String> changedPartitions = new ArrayList<String>();
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument clusters = (ODocument)this.configuration.field("clusters");
            for (String c : clusters.fieldNames()) {
                List<String> serverList = this.getOriginalServers(c);
                if (serverList == null || serverList.size() < 2 || !serverList.get(0).equals(iServerName)) continue;
                serverList.remove(0);
                serverList.add(iServerName);
                changedPartitions.add(c);
            }
        }
        if (!changedPartitions.isEmpty()) {
            this.incrementVersion();
            return changedPartitions;
        }
        return null;
    }

    protected List<String> initClusterServers(ODocument cluster) {
        ODocument any = this.getClusterConfiguration("*");
        List anyServers = (List)any.field("servers");
        ArrayList<String> servers = new ArrayList<String>(anyServers);
        cluster.field("servers", servers);
        return servers;
    }

    protected void incrementVersion() {
        Integer oldVersion = (Integer)this.configuration.field("version");
        if (oldVersion == null) {
            oldVersion = 0;
        }
        this.configuration.field("version", (Object)(oldVersion + 1));
    }
}

