/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.db.ODatabaseHelper;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClientSynch;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.io.IOException;
import java.util.Arrays;

public class OServerShutdownMain {
    public String networkAddress;
    public int[] networkPort;
    public OChannelBinaryAsynchClient channel;
    protected OServerConfigurationLoaderXml configurationLoader;
    protected OServerConfiguration configuration;
    private OContextConfiguration contextConfig;
    private String rootPassword;

    public OServerShutdownMain(String iServerAddress, String iServerPorts, String iRootPassword) {
        block9: {
            this.contextConfig = new OContextConfiguration();
            try {
                if (iRootPassword == null) {
                    this.loadConfiguration();
                    if (this.configuration.users != null && this.configuration.users.length > 0) {
                        for (OServerUserConfiguration u : this.configuration.users) {
                            if (!u.name.equals("root")) continue;
                            this.rootPassword = u.password;
                            break;
                        }
                    }
                } else {
                    this.rootPassword = iRootPassword;
                }
                if (iServerAddress == null) {
                    this.loadConfiguration();
                    for (OServerNetworkListenerConfiguration l : this.configuration.network.listeners) {
                        if (!l.protocol.equals("distributed") && !l.protocol.equals("binary")) continue;
                        this.networkAddress = l.ipAddress;
                        this.networkPort = OServerNetworkListener.getPorts(l.portRange);
                        break block9;
                    }
                    break block9;
                }
                this.networkAddress = iServerAddress;
                this.networkPort = OServerNetworkListener.getPorts(iServerPorts);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on reading server configuration.", OConfigurationException.class);
            }
        }
    }

    private void loadConfiguration() throws IOException {
        if (this.configurationLoader != null) {
            return;
        }
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, ODatabaseHelper.getConfigurationFile());
        this.configuration = this.configurationLoader.load();
    }

    public void connect(int iTimeout) throws IOException {
        for (int port : this.networkPort) {
            try {
                this.channel = new OChannelBinaryAsynchClientSynch(this.networkAddress, port, null, this.contextConfig);
                break;
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on connecting to %s:%d", (Throwable)e, new Object[]{this.networkAddress, port});
            }
        }
        if (this.channel == null) {
            throw new ONetworkProtocolException("Cannot connect to server host '" + this.networkAddress + "', ports: " + Arrays.toString(this.networkPort));
        }
        this.channel.writeByte((byte)1);
        this.channel.writeInt(0);
        this.channel.writeString("root");
        this.channel.writeString(this.rootPassword);
        this.channel.flush();
        if (this.channel.readByte() == 1) {
            this.channel.readInt();
            this.channel.readString();
            throw new ONetworkProtocolException(this.channel.readString());
        }
        this.channel.readInt();
    }

    public static void main(String[] iArgs) {
        String serverHost = iArgs.length > 0 ? iArgs[0] : null;
        String serverPorts = iArgs.length > 1 ? iArgs[1] : null;
        String rootPassword = iArgs.length > 2 ? iArgs[2] : null;
        System.out.println("Sending shutdown command to remote OrientDB Server instance...");
        try {
            new OServerShutdownMain(serverHost, serverPorts, rootPassword).connect(5000);
            System.out.println("Shutdown executed correctly");
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getLocalizedMessage());
        }
        System.out.println();
    }
}

