/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.ODistributedCommand;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.OAsynchDistributedOperation;
import com.orientechnologies.orient.server.distributed.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OLocalClusterStrategy;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.task.OScriptTask;
import com.orientechnologies.orient.server.distributed.task.OTxTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class ODistributedStorage
implements OStorage,
OFreezableStorage,
OAutoshardedStorage {
    protected final OServer serverInstance;
    protected final ODistributedServerManager dManager;
    protected final OAbstractPaginatedStorage wrapped;
    protected final TimerTask purgeDeletedRecordsTask;
    protected final ConcurrentHashMap<ORecordId, OPair<Long, ORecordVersion>> deletedRecords = new ConcurrentHashMap();
    protected final AtomicLong lastOperationId = new AtomicLong();
    protected final BlockingQueue<OAsynchDistributedOperation> asynchronousOperationsQueue;
    protected final Thread asynchWorker;
    protected volatile boolean running = true;

    public ODistributedStorage(OServer iServer, final OAbstractPaginatedStorage wrapped) {
        this.serverInstance = iServer;
        this.dManager = iServer.getDistributedManager();
        this.wrapped = wrapped;
        ODistributedServerLog.info((Object)this, this.dManager != null ? this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Installing distributed storage on database '%s'", wrapped.getName());
        this.purgeDeletedRecordsTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<ORecordId, OPair<Long, ORecordVersion>>> it = ODistributedStorage.this.deletedRecords.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<ORecordId, OPair<Long, ORecordVersion>> entry = it.next();
                    try {
                        OStorageOperationResult result;
                        ORecordId rid = entry.getKey();
                        long time = (Long)entry.getValue().getKey();
                        ORecordVersion version = (ORecordVersion)entry.getValue().getValue();
                        if (now - time <= OGlobalConfiguration.DISTRIBUTED_ASYNCH_RESPONSES_TIMEOUT.getValueAsLong() * 2L || (result = wrapped.deleteRecord(rid, version, 0, null)) != null && ((Boolean)result.getResult()).booleanValue()) continue;
                        OLogManager.instance().error((Object)this, "Error on deleting record %s v.%s", new Object[]{rid, version});
                    }
                    finally {
                        it.remove();
                    }
                }
            }
        };
        Orient.instance().scheduleTask(this.purgeDeletedRecordsTask, OGlobalConfiguration.DISTRIBUTED_PURGE_RESPONSES_TIMER_DELAY.getValueAsLong(), OGlobalConfiguration.DISTRIBUTED_PURGE_RESPONSES_TIMER_DELAY.getValueAsLong());
        int queueSize = OGlobalConfiguration.DISTRIBUTED_ASYNCH_QUEUE_SIZE.getValueAsInteger();
        this.asynchronousOperationsQueue = queueSize <= 0 ? new LinkedBlockingQueue<OAsynchDistributedOperation>() : new LinkedBlockingQueue<OAsynchDistributedOperation>(queueSize);
        this.asynchWorker = new Thread(){

            @Override
            public void run() {
                while (ODistributedStorage.this.running || !ODistributedStorage.this.asynchronousOperationsQueue.isEmpty()) {
                    try {
                        OAsynchDistributedOperation operation = ODistributedStorage.this.asynchronousOperationsQueue.take();
                        ODistributedStorage.this.dManager.sendRequest(operation.getDatabaseName(), operation.getClusterNames(), operation.getNodes(), operation.getTask(), ODistributedRequest.EXECUTION_MODE.NO_RESPONSE);
                    }
                    catch (InterruptedException e) {
                        int pendingMessages = ODistributedStorage.this.asynchronousOperationsQueue.size();
                        if (pendingMessages > 0) {
                            ODistributedServerLog.warn((Object)this, ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Received shutdown signal, waiting for asynchronous queue is empty (pending msgs=%d)...", pendingMessages);
                        }
                        Thread.interrupted();
                    }
                    catch (Throwable e) {
                        ODistributedServerLog.error((Object)this, ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.OUT, "Error on executing asynch operation", e, new Object[0]);
                    }
                }
                ODistributedServerLog.warn((Object)this, ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Shutdown asynchronous queue worker completed", new Object[0]);
            }
        };
        this.asynchWorker.setName("OrientDB Distributed asynch ops node=" + this.getNodeId() + " db=" + this.getName());
        this.asynchWorker.start();
    }

    public boolean isDistributed() {
        return true;
    }

    public boolean isAssigningClusterIds() {
        return true;
    }

    public Class<? extends OSBTreeCollectionManager> getCollectionManagerClass() {
        return this.wrapped.getCollectionManagerClass();
    }

    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor exec;
        ArrayList<String> servers = (ArrayList<String>)iCommand.getContext().getVariable("servers");
        if (servers == null) {
            servers = new ArrayList<String>();
            iCommand.getContext().setVariable("servers", servers);
        }
        String localNodeName = this.dManager.getLocalNodeName();
        servers.add(localNodeName);
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.command(iCommand);
        }
        ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
        if (!dbCfg.isReplicationActive(null, localNodeName)) {
            return this.wrapped.command(iCommand);
        }
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse((OCommandRequest)iCommand);
        Object object = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        if (!exec.isIdempotent()) {
            this.checkNodeIsMaster(localNodeName, dbCfg);
        }
        try {
            OAbstractCommandTask task = iCommand instanceof OCommandScript ? new OScriptTask(iCommand) : new OSQLCommandTask(iCommand);
            Object result = null;
            OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
            if (OScenarioThreadLocal.INSTANCE.get() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED && exec instanceof OCommandDistributedReplicateRequest) {
                executionMode = ((OCommandDistributedReplicateRequest)exec).getDistributedExecutionMode();
            }
            switch (executionMode) {
                case LOCAL: {
                    return this.wrapped.command(iCommand);
                }
                case REPLICATE: {
                    Set involvedClusters = exec.getInvolvedClusters();
                    task.setResultStrategy(OAbstractRemoteTask.RESULT_STRATEGY.ANY);
                    Set<String> nodes = dbCfg.getServers(involvedClusters);
                    if (iCommand instanceof ODistributedCommand) {
                        nodes.removeAll(((ODistributedCommand)iCommand).nodesToExclude());
                    }
                    if (nodes.isEmpty()) {
                        return null;
                    }
                    result = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, task, ODistributedRequest.EXECUTION_MODE.RESPONSE);
                    this.dManager.propagateSchemaChanges((ODatabaseInternal)ODatabaseRecordThreadLocal.INSTANCE.get());
                    break;
                }
                case SHARDED: {
                    Set involvedClusters = exec.getInvolvedClusters();
                    task.setResultStrategy(OAbstractRemoteTask.RESULT_STRATEGY.UNION);
                    Collection<String> nodes = dbCfg.getOneServerPerCluster(involvedClusters, localNodeName);
                    if (iCommand instanceof ODistributedCommand) {
                        nodes.removeAll(((ODistributedCommand)iCommand).nodesToExclude());
                    }
                    boolean executeLocally = false;
                    if (exec.isIdempotent()) {
                        int maxReadQuorum;
                        if (involvedClusters.isEmpty()) {
                            maxReadQuorum = dbCfg.getReadQuorum(null);
                        } else {
                            maxReadQuorum = 0;
                            for (String cl : involvedClusters) {
                                maxReadQuorum = Math.max(maxReadQuorum, dbCfg.getReadQuorum(cl));
                            }
                        }
                        if (nodes.size() == 1 && nodes.iterator().next().equals(localNodeName) && maxReadQuorum <= 1) {
                            executeLocally = true;
                        }
                    } else if (nodes.size() == 1 && nodes.iterator().next().equals(localNodeName)) {
                        executeLocally = true;
                    }
                    if (executeLocally) {
                        return this.wrapped.command(iCommand);
                    }
                    result = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, task, ODistributedRequest.EXECUTION_MODE.RESPONSE);
                    if (!(result instanceof Map) || !(executor instanceof OCommandExecutorSQLDelegate) || !(((OCommandExecutorSQLDelegate)executor).getDelegate() instanceof OCommandExecutorSQLSelect)) break;
                    OCommandExecutorSQLSelect cmd = (OCommandExecutorSQLSelect)((OCommandExecutorSQLDelegate)executor).getDelegate();
                    if (((Map)result).size() == 1) {
                        result = ((Map)result).values().iterator().next();
                        break;
                    }
                    if (cmd.isAnyFunctionAggregates()) {
                        Map proj = cmd.getProjections();
                        ArrayList<ODocument> list = new ArrayList<ODocument>();
                        ODocument doc = new ODocument();
                        list.add(doc);
                        boolean hasNonAggregates = false;
                        for (Map.Entry p : proj.entrySet()) {
                            if (p.getValue() instanceof OSQLFunctionRuntime) continue;
                            hasNonAggregates = true;
                            break;
                        }
                        if (hasNonAggregates) {
                            for (Map.Entry entry : ((Map)result).entrySet()) {
                                List resultSet = (List)entry.getValue();
                                for (Object r : resultSet) {
                                    if (!(r instanceof ODocument)) continue;
                                    ODocument d = (ODocument)r;
                                    for (Map.Entry p : proj.entrySet()) {
                                        if (p.getValue() instanceof OSQLFunctionRuntime) continue;
                                        doc.field((String)p.getKey(), p.getValue());
                                    }
                                }
                            }
                        }
                        ArrayList<Object> toMerge = new ArrayList<Object>();
                        for (Map.Entry p : proj.entrySet()) {
                            if (!(p.getValue() instanceof OSQLFunctionRuntime)) continue;
                            OSQLFunctionRuntime f = (OSQLFunctionRuntime)p.getValue();
                            toMerge.clear();
                            for (Map.Entry entry : ((Map)result).entrySet()) {
                                List resultSet = (List)entry.getValue();
                                for (Object r : resultSet) {
                                    if (!(r instanceof ODocument)) continue;
                                    ODocument d = (ODocument)r;
                                    toMerge.add(d.rawField((String)p.getKey()));
                                }
                            }
                            doc.field((String)p.getKey(), f.getFunction().mergeDistributedResult(toMerge));
                        }
                        result = list;
                        break;
                    }
                    HashSet set = new HashSet();
                    for (Map.Entry entry : ((Map)result).entrySet()) {
                        Object nodeResult = entry.getValue();
                        if (nodeResult instanceof Collection) {
                            set.addAll((Collection)nodeResult);
                            continue;
                        }
                        if (!(nodeResult instanceof Exception)) continue;
                        throw (Exception)nodeResult;
                    }
                    result = new ArrayList(set);
                    break;
                }
            }
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed COMMAND", (Throwable)result);
            }
            return result;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route COMMAND operation to the distributed node", e, new Object[0]);
            return null;
        }
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(final ORecordId iRecordId, final byte[] iContent, final ORecordVersion iRecordVersion, final byte iRecordType, final int iMode, final ORecordCallback<Long> iCallback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
        }
        try {
            Boolean executionModeSynch;
            String clusterName = this.getClusterNameByRID(iRecordId);
            int clusterId = iRecordId.getClusterId();
            if (clusterId == -1) {
                throw new IllegalArgumentException("Cluster not valid");
            }
            String localNodeName = this.dManager.getLocalNodeName();
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            this.checkNodeIsMaster(localNodeName, dbCfg);
            List<String> nodes = dbCfg.getServers(clusterName, null);
            if (nodes.isEmpty()) {
                return (OStorageOperationResult)ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
                    }
                });
            }
            String masterNode = nodes.get(0);
            if (!masterNode.equals(localNodeName)) {
                OCluster cl = this.getClusterByName(clusterName);
                ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
                OClass cls = db.getMetadata().getSchema().getClassByClusterId(cl.getId());
                String newClusterName = null;
                if (cls != null) {
                    OClusterSelectionStrategy clSel = cls.getClusterSelection();
                    if (!(clSel instanceof OLocalClusterStrategy)) {
                        this.dManager.propagateSchemaChanges((ODatabaseInternal)db);
                        clSel = cls.getClusterSelection();
                    }
                    newClusterName = this.getPhysicalClusterNameById(clSel.getCluster(cls, null));
                    nodes = dbCfg.getServers(newClusterName, null);
                    masterNode = nodes.get(0);
                }
                if (!masterNode.equals(localNodeName)) {
                    throw new ODistributedException("Error on inserting into cluster '" + clusterName + "' where local node '" + localNodeName + "' is not the master of it, but it's '" + masterNode + "'");
                }
                OLogManager.instance().warn((Object)this, "Local node '" + localNodeName + "' is not the master for cluster '" + clusterName + "' (it's '" + masterNode + "'). Switching to a valid cluster of the same class: '" + newClusterName + "'", new Object[0]);
                clusterName = newClusterName;
            }
            if ((executionModeSynch = dbCfg.isExecutionModeSynchronous(clusterName)) == null) {
                executionModeSynch = iMode == 0;
            }
            if (executionModeSynch.booleanValue()) {
                Object masterResult = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new OCreateRecordTask(iRecordId, iContent, iRecordVersion, iRecordType), ODistributedRequest.EXECUTION_MODE.RESPONSE);
                if (masterResult instanceof ONeedRetryException) {
                    throw (ONeedRetryException)((Object)masterResult);
                }
                if (masterResult instanceof Throwable) {
                    throw new ODistributedException("Error on execution distributed CREATE_RECORD", (Throwable)masterResult);
                }
                OPlaceholder masterPlaceholder = (OPlaceholder)masterResult;
                iRecordId.copyFrom(masterPlaceholder.getIdentity());
                return new OStorageOperationResult((Object)new OPhysicalPosition(masterPlaceholder.getIdentity().getClusterPosition(), masterPlaceholder.getRecordVersion()));
            }
            OStorageOperationResult localResult = (OStorageOperationResult)ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                public Object call() throws Exception {
                    return ODistributedStorage.this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
                }
            });
            nodes.remove(localNodeName);
            if (!nodes.isEmpty()) {
                this.asynchronousExecution(new OAsynchDistributedOperation(this.getName(), Collections.singleton(clusterName), nodes, new OCreateRecordTask(iRecordId, iContent, iRecordVersion, iRecordType)));
            }
            return localResult;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route CREATE_RECORD operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORawBuffer> readRecord(final ORecordId iRecordId, final String iFetchPlan, final boolean iIgnoreCache, final ORecordCallback<ORawBuffer> iCallback, final boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        if (this.deletedRecords.get(iRecordId) != null) {
            throw new ORecordNotFoundException("Record " + iRecordId + " was not found");
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            List<String> nodes = dbCfg.getServers(clusterName, null);
            if (nodes.isEmpty() || nodes.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName) <= 1) {
                return (OStorageOperationResult)ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones, OStorage.LOCKING_STRATEGY.DEFAULT);
                    }
                });
            }
            Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new OReadRecordTask(iRecordId), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed READ_RECORD", (Throwable)result);
            }
            return new OStorageOperationResult((Object)((ORawBuffer)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route READ_RECORD operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORecordVersion> updateRecord(final ORecordId iRecordId, final boolean updateContent, final byte[] iContent, final ORecordVersion iVersion, final byte iRecordType, final int iMode, final ORecordCallback<ORecordVersion> iCallback) {
        if (this.deletedRecords.get(iRecordId) != null) {
            throw new ORecordNotFoundException("Record " + iRecordId + " was not found");
        }
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.updateRecord(iRecordId, updateContent, iContent, iVersion, iRecordType, iMode, iCallback);
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            String localNodeName = this.dManager.getLocalNodeName();
            this.checkNodeIsMaster(localNodeName, dbCfg);
            List<String> nodes = dbCfg.getServers(clusterName, null);
            if (nodes.isEmpty()) {
                return (OStorageOperationResult)ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.updateRecord(iRecordId, updateContent, iContent, iVersion, iRecordType, iMode, iCallback);
                    }
                });
            }
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(clusterName);
            if (executionModeSynch == null) {
                executionModeSynch = iMode == 0;
            }
            if (executionModeSynch.booleanValue()) {
                OStorageOperationResult<ORawBuffer> previousContent = this.readRecord(iRecordId, null, false, null, false, OStorage.LOCKING_STRATEGY.DEFAULT);
                Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new OUpdateRecordTask(iRecordId, ((ORawBuffer)previousContent.getResult()).getBuffer(), ((ORawBuffer)previousContent.getResult()).version, iContent, iVersion, iRecordType), ODistributedRequest.EXECUTION_MODE.RESPONSE);
                if (result instanceof ONeedRetryException) {
                    throw (ONeedRetryException)((Object)result);
                }
                if (result instanceof Throwable) {
                    throw new ODistributedException("Error on execution distributed UPDATE_RECORD", (Throwable)result);
                }
                return new OStorageOperationResult((Object)((ORecordVersion)result));
            }
            OStorageOperationResult localResult = (OStorageOperationResult)ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                public Object call() throws Exception {
                    return ODistributedStorage.this.wrapped.updateRecord(iRecordId, updateContent, iContent, iVersion, iRecordType, iMode, iCallback);
                }
            });
            nodes.remove(localNodeName);
            if (!nodes.isEmpty()) {
                OStorageOperationResult<ORawBuffer> previousContent = this.readRecord(iRecordId, null, false, null, false, OStorage.LOCKING_STRATEGY.DEFAULT);
                this.asynchronousExecution(new OAsynchDistributedOperation(this.getName(), Collections.singleton(clusterName), nodes, new OUpdateRecordTask(iRecordId, ((ORawBuffer)previousContent.getResult()).getBuffer(), ((ORawBuffer)previousContent.getResult()).version, iContent, iVersion, iRecordType)));
            }
            return localResult;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route UPDATE_RECORD operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<Boolean> deleteRecord(final ORecordId iRecordId, final ORecordVersion iVersion, final int iMode, final ORecordCallback<Boolean> iCallback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
            String localNodeName = this.dManager.getLocalNodeName();
            this.checkNodeIsMaster(localNodeName, dbCfg);
            List<String> nodes = dbCfg.getServers(clusterName, null);
            if (nodes.isEmpty()) {
                return (OStorageOperationResult)ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
                    }
                });
            }
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(clusterName);
            if (executionModeSynch == null) {
                executionModeSynch = iMode == 0;
            }
            if (executionModeSynch.booleanValue()) {
                Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), nodes, new ODeleteRecordTask(iRecordId, iVersion), ODistributedRequest.EXECUTION_MODE.RESPONSE);
                if (result instanceof ONeedRetryException) {
                    throw (ONeedRetryException)((Object)result);
                }
                if (result instanceof Throwable) {
                    throw new ODistributedException("Error on execution distributed DELETE_RECORD", (Throwable)result);
                }
                return new OStorageOperationResult((Object)true);
            }
            OStorageOperationResult localResult = (OStorageOperationResult)ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                public Object call() throws Exception {
                    return ODistributedStorage.this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
                }
            });
            nodes.remove(localNodeName);
            if (!nodes.isEmpty()) {
                this.asynchronousExecution(new OAsynchDistributedOperation(this.getName(), Collections.singleton(clusterName), nodes, new ODeleteRecordTask(iRecordId, iVersion)));
            }
            return localResult;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route DELETE_RECORD operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        throw new UnsupportedOperationException();
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.wrapped.getRecordMetadata(rid);
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.wrapped.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    public OCluster getClusterByName(String iName) {
        return this.wrapped.getClusterByName(iName);
    }

    public ORecordConflictStrategy getConflictStrategy() {
        return this.getUnderlying().getConflictStrategy();
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.getUnderlying().setConflictStrategy(iResolver);
    }

    public <T> T removeResource(String iName) {
        return (T)this.wrapped.removeResource(iName);
    }

    public <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.wrapped.getResource(iName, iCallback);
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    public void create(Map<String, Object> iProperties) {
        this.wrapped.create(iProperties);
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public void reload() {
        this.wrapped.reload();
    }

    public void delete() {
        this.wrapped.delete();
    }

    public void close() {
        this.close(false, false);
    }

    public void close(boolean iForce, boolean onDelete) {
        this.wrapped.close(iForce, onDelete);
        if (this.isClosed()) {
            this.shutdownAsynchronousWorker();
        }
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public void commit(final OTransaction iTx, final Runnable callback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            this.wrapped.commit(iTx, callback);
            return;
        }
        ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.getName());
        String localNodeName = this.dManager.getLocalNodeName();
        this.checkNodeIsMaster(localNodeName, dbCfg);
        try {
            if (!dbCfg.isReplicationActive(null, localNodeName)) {
                ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                    public Object call() throws Exception {
                        ODistributedStorage.this.wrapped.commit(iTx, callback);
                        return null;
                    }
                });
                return;
            }
            OTransactionInternal.setStatus((OTransactionAbstract)((OTransactionAbstract)iTx), (OTransaction.TXSTATUS)OTransaction.TXSTATUS.BEGUN);
            OTxTask txTask = new OTxTask();
            HashSet<String> involvedClusters = new HashSet<String>();
            Set<String> nodes = dbCfg.getServers(involvedClusters);
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(null);
            if (executionModeSynch == null) {
                executionModeSynch = Boolean.TRUE;
            }
            ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
            while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                    tmpEntries.add(txEntry);
                }
                iTx.clearRecordEntries();
                block10: for (ORecordOperation op : tmpEntries) {
                    OAbstractRecordReplicatedTask task;
                    ORecord record = op.getRecord();
                    ORecordId rid = (ORecordId)record.getIdentity();
                    switch (op.type) {
                        case 3: {
                            if (rid.isNew()) {
                                ORecord rec = executionModeSynch != false ? record : record.copy();
                                task = new OCreateRecordTask(rec);
                                if (!(record instanceof ODocument)) break;
                                ((ODocument)record).validate();
                                break;
                            }
                        }
                        case 1: {
                            OStorageOperationResult previousContent;
                            if (record instanceof ODocument) {
                                ((ODocument)record).validate();
                            }
                            if ((previousContent = this.wrapped.readRecord(rid, null, false, null, false, OStorage.LOCKING_STRATEGY.DEFAULT)).getResult() == null) {
                                throw new OTransactionException("Cannot update record '" + rid + "' because has been deleted");
                            }
                            task = new OUpdateRecordTask(rid, ((ORawBuffer)previousContent.getResult()).getBuffer(), ((ORawBuffer)previousContent.getResult()).version, record.toStream(), record.getRecordVersion(), ORecordInternal.getRecordType((ORecord)record));
                            break;
                        }
                        case 2: {
                            task = new ODeleteRecordTask(rid, record.getRecordVersion());
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                    involvedClusters.add(this.getClusterNameByRID(rid));
                    txTask.add(task);
                }
            }
            OTransactionInternal.setStatus((OTransactionAbstract)((OTransactionAbstract)iTx), (OTransaction.TXSTATUS)OTransaction.TXSTATUS.COMMITTING);
            if (executionModeSynch.booleanValue()) {
                Object result = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, txTask, ODistributedRequest.EXECUTION_MODE.RESPONSE);
                if (result instanceof List) {
                    List list = (List)result;
                    for (int i = 0; i < txTask.getTasks().size(); ++i) {
                        OAbstractRecordReplicatedTask t;
                        Object o = list.get(i);
                        OAbstractRecordReplicatedTask task = txTask.getTasks().get(i);
                        if (task instanceof OCreateRecordTask) {
                            t = (OCreateRecordTask)task;
                            t.getRid().copyFrom(((OPlaceholder)o).getIdentity());
                            t.getVersion().copyFrom(((OPlaceholder)o).getRecordVersion());
                            continue;
                        }
                        if (task instanceof OUpdateRecordTask) {
                            t = (OUpdateRecordTask)task;
                            t.getVersion().copyFrom((ORecordVersion)o);
                            continue;
                        }
                        if (!(task instanceof ODeleteRecordTask)) continue;
                    }
                    for (ORecordOperation op : tmpEntries) {
                        ORecord record = op.getRecord();
                        if (record == null) continue;
                        ORecordInternal.unsetDirty((ORecord)record);
                    }
                } else {
                    if (result instanceof Throwable) {
                        if (ODistributedServerLog.isDebugEnabled()) {
                            ODistributedServerLog.debug((Object)this, localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "distributed transaction error: %s", result, result.toString());
                        }
                        if (result instanceof OTransactionException || result instanceof ONeedRetryException) {
                            throw (RuntimeException)result;
                        }
                        throw new OTransactionException("Error on committing distributed transaction", (Throwable)result);
                    }
                    if (ODistributedServerLog.isDebugEnabled()) {
                        ODistributedServerLog.debug((Object)this, localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "distributed transaction error, received unknown response type: %s", result);
                    }
                    throw new OTransactionException("Error on committing distributed transaction, received unknown response type " + result);
                }
                return;
            }
            ODistributedAbstractPlugin.runInDistributedMode(new Callable(){

                public Object call() throws Exception {
                    ((OTransactionRealAbstract)iTx).restore();
                    ODistributedStorage.this.wrapped.commit(iTx, callback);
                    return null;
                }
            });
            nodes.remove(localNodeName);
            if (!nodes.isEmpty()) {
                if (executionModeSynch.booleanValue()) {
                    this.dManager.sendRequest(this.getName(), involvedClusters, nodes, txTask, ODistributedRequest.EXECUTION_MODE.RESPONSE);
                } else {
                    this.asynchronousExecution(new OAsynchDistributedOperation(this.getName(), involvedClusters, nodes, txTask));
                }
            }
        }
        catch (OValidationException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
        }
    }

    public void rollback(OTransaction iTx) {
        this.wrapped.rollback(iTx);
    }

    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public int getClusters() {
        return this.wrapped.getClusters();
    }

    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addCluster(String iClusterName, boolean forceListBased, Object ... iParameters) {
        for (int retry = 0; retry < 10; ++retry) {
            int clId = this.wrapped.addCluster(iClusterName, false, iParameters);
            if (OScenarioThreadLocal.INSTANCE.get() != OScenarioThreadLocal.RUN_MODE.DEFAULT) return clId;
            StringBuilder cmd = new StringBuilder("create cluster ");
            cmd.append(iClusterName);
            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
            commandSQL.addExcludedNode(this.getNodeId());
            Object result = this.command((OCommandRequestText)commandSQL);
            if (result == null || (Integer)result == clId) return clId;
            OLogManager.instance().warn((Object)this, "Error on creating cluster on distributed nodes: ids are different (local=%d and remote=%d). Retrying %d/%d...", new Object[]{clId, (int)((Integer)result), retry, 10});
            this.wrapped.dropCluster(clId, false);
            cmd.setLength(0);
            cmd.append("drop cluster ");
            cmd.append(iClusterName);
            commandSQL = new OCommandSQL(cmd.toString());
            commandSQL.addExcludedNode(this.getNodeId());
            this.command((OCommandRequestText)commandSQL);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.wrapped.reload();
        }
        throw new ODistributedException("Error on creating cluster on distributed nodes: local and remote ids assigned are different");
    }

    public int addCluster(String iClusterName, int iRequestedId, boolean forceListBased, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterName, iRequestedId, forceListBased, iParameters);
    }

    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.wrapped.dropCluster(iClusterName, iTruncate);
    }

    public boolean dropCluster(int iId, boolean iTruncate) {
        return this.wrapped.dropCluster(iId, iTruncate);
    }

    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.wrapped.count(iClusterId, countTombstones);
    }

    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        return this.wrapped.count(iClusterIds, countTombstones);
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public long countRecords() {
        return this.wrapped.countRecords();
    }

    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String getURL() {
        return this.wrapped.getURL();
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public void synch() {
        this.wrapped.synch();
    }

    public int getUsers() {
        return this.wrapped.getUsers();
    }

    public int addUser() {
        return this.wrapped.addUser();
    }

    public int removeUser() {
        return this.wrapped.removeUser();
    }

    public long[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.wrapped.checkForClusterPermissions(iClusterName);
    }

    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.higherPhysicalPositions(currentClusterId, entry);
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.floorPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.lowerPhysicalPositions(currentClusterId, entry);
    }

    public OSharedResourceAdaptiveExternal getLock() {
        return this.wrapped.getLock();
    }

    public OStorage getUnderlying() {
        return this.wrapped;
    }

    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.wrapped.getComponentsFactory();
    }

    public String getType() {
        return "distributed";
    }

    public void freeze(boolean throwException) {
        this.getFreezableStorage().freeze(throwException);
    }

    public void release() {
        this.getFreezableStorage().release();
    }

    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        this.wrapped.backup(out, options, callable, iListener, compressionLevel, bufferSize);
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.wrapped.restore(in, options, callable, iListener);
    }

    public long getLastOperationId() {
        return this.lastOperationId.get();
    }

    public void setLastOperationId(long lastOperationId) {
        this.lastOperationId.set(lastOperationId);
    }

    public void pushDeletedRecord(ORecordId rid, ORecordVersion version) {
        this.deletedRecords.putIfAbsent(rid, (OPair<Long, ORecordVersion>)new OPair((Comparable)Long.valueOf(System.currentTimeMillis()), (Object)version));
    }

    public boolean resurrectDeletedRecord(ORecordId rid) {
        return this.deletedRecords.remove(rid) != null;
    }

    public String getClusterNameByRID(ORecordId iRid) {
        OCluster cluster = this.getClusterById(iRid.clusterId);
        return cluster != null ? cluster.getName() : "*";
    }

    public String getStorageId() {
        return this.dManager.getLocalNodeName() + "." + this.getName();
    }

    public String getNodeId() {
        return this.dManager != null ? this.dManager.getLocalNodeName() : "?";
    }

    public void shutdownAsynchronousWorker() {
        this.running = false;
        this.asynchWorker.interrupt();
        try {
            this.asynchWorker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.asynchronousOperationsQueue.clear();
    }

    protected void checkNodeIsMaster(String localNodeName, ODistributedConfiguration dbCfg) {
        ODistributedConfiguration.ROLES nodeRole = dbCfg.getServerRole(localNodeName);
        if (nodeRole != ODistributedConfiguration.ROLES.MASTER) {
            throw new ODistributedException("Cannot execute write operation on node '" + localNodeName + "' because is non master");
        }
    }

    protected void asynchronousExecution(OAsynchDistributedOperation iOperation) {
        this.asynchronousOperationsQueue.offer(iOperation);
    }

    protected void handleDistributedException(String iMessage, Exception e, Object ... iParams) {
        if (e != null) {
            if (e instanceof OException) {
                throw (OException)e;
            }
            if (e.getCause() instanceof OException) {
                throw (OException)e.getCause();
            }
            if (e.getCause() != null && e.getCause().getCause() instanceof OException) {
                throw (OException)e.getCause().getCause();
            }
        }
        OLogManager.instance().error((Object)this, iMessage, (Throwable)e, iParams);
        throw new OStorageException(String.format(iMessage, iParams), (Throwable)e);
    }

    private OFreezableStorage getFreezableStorage() {
        if (this.wrapped instanceof OFreezableStorage) {
            return (OFreezableStorage)this.wrapped;
        }
        throw new UnsupportedOperationException("Storage engine " + this.wrapped.getType() + " does not support freeze operation");
    }
}

