/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.util.List;

public class OServerCommandKillDbConnection
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"POST|dbconnection/*"};

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: dbconnection/<database>");
        this.doPost(iRequest, iResponse, urlParts[1], iRequest.content);
        return false;
    }

    private void doPost(OHttpRequest iRequest, OHttpResponse iResponse, String db, String command) throws IOException {
        List<OClientConnection> connections = OClientConnectionManager.instance().getConnections();
        for (OClientConnection connection : connections) {
            if (!this.checkDbSession(iRequest, db, command, connection)) continue;
            OClientConnectionManager.instance().kill(connection.id);
        }
        iResponse.send(204, "OK", "text/plain", null, null);
    }

    public boolean checkDbSession(OHttpRequest iRequest, String db, String command, OClientConnection connection) {
        boolean session = true;
        session = session && connection.protocol instanceof ONetworkProtocolHttpAbstract;
        session = session && db.equals(connection.data.lastDatabase);
        session = session && command.equals(connection.data.commandDetail);
        session = session && ((ONetworkProtocolHttpAbstract)connection.protocol).getSessionID().equals(iRequest.sessionId);
        return session;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

