/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionAbortedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.tx.OTransactionEntryProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OTransactionOptimisticProxy
extends OTransactionOptimistic {
    private final Map<ORID, ORecordOperation> tempEntries = new LinkedHashMap<ORID, ORecordOperation>();
    private final Map<ORecordId, ORecord> createdRecords = new HashMap<ORecordId, ORecord>();
    private final Map<ORecordId, ORecord> updatedRecords = new HashMap<ORecordId, ORecord>();
    @Deprecated
    private final int clientTxId;
    private final OChannelBinary channel;
    private final short protocolVersion;
    private ONetworkProtocolBinary oNetworkProtocolBinary;

    public OTransactionOptimisticProxy(ODatabaseDocumentTx iDatabase, OChannelBinary iChannel, short protocolVersion, ONetworkProtocolBinary oNetworkProtocolBinary) throws IOException {
        super(iDatabase);
        this.channel = iChannel;
        this.clientTxId = iChannel.readInt();
        this.protocolVersion = protocolVersion;
        this.oNetworkProtocolBinary = oNetworkProtocolBinary;
    }

    public void begin() {
        super.begin();
        try {
            this.setUsingLog(this.channel.readByte() == 1);
            byte lastTxStatus = this.channel.readByte();
            while (lastTxStatus == 1) {
                byte recordStatus = this.channel.readByte();
                ORecordId rid = this.channel.readRID();
                byte recordType = this.channel.readByte();
                OTransactionEntryProxy entry = new OTransactionEntryProxy(recordType);
                entry.type = recordStatus;
                switch (recordStatus) {
                    case 3: {
                        this.oNetworkProtocolBinary.fillRecord(rid, this.channel.readBytes(), OVersionFactory.instance().createVersion(), entry.getRecord(), (ODatabaseDocumentInternal)this.database);
                        this.createdRecords.put(rid.copy(), entry.getRecord());
                        break;
                    }
                    case 1: {
                        ORecordVersion version = this.channel.readVersion();
                        byte[] bytes = this.channel.readBytes();
                        this.oNetworkProtocolBinary.fillRecord(rid, bytes, version, entry.getRecord(), (ODatabaseDocumentInternal)this.database);
                        if (this.protocolVersion < 23) break;
                        ORecordInternal.setContentChanged((ORecord)entry.getRecord(), (boolean)this.channel.readBoolean());
                        break;
                    }
                    case 2: {
                        ORecordInternal.fill((ORecord)entry.getRecord(), (ORID)rid, (ORecordVersion)this.channel.readVersion(), null, (boolean)false);
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + recordStatus);
                    }
                }
                this.tempEntries.put(entry.getRecord().getIdentity(), entry);
                lastTxStatus = this.channel.readByte();
            }
            if (lastTxStatus == -1) {
                throw new OTransactionAbortedException("Transaction aborted by the client");
            }
            ODocument remoteIndexEntries = new ODocument(this.channel.readBytes());
            this.fillIndexOperations(remoteIndexEntries);
            for (Map.Entry<ORID, ORecordOperation> entry : this.tempEntries.entrySet()) {
                if (entry.getValue().type == 1) {
                    ORecord record = entry.getValue().record.getRecord();
                    ORecord loadedRecord = record.getIdentity().copy().getRecord();
                    if (loadedRecord == null) {
                        throw new ORecordNotFoundException(record.getIdentity().toString());
                    }
                    if (ORecordInternal.getRecordType((ORecord)loadedRecord) == 100 && ORecordInternal.getRecordType((ORecord)loadedRecord) == ORecordInternal.getRecordType((ORecord)record)) {
                        ((ODocument)loadedRecord).merge((ODocument)record, false, false);
                        loadedRecord.getRecordVersion().copyFrom(record.getRecordVersion());
                        entry.getValue().record = loadedRecord;
                        this.updatedRecords.put((ORecordId)entry.getKey(), entry.getValue().getRecord());
                    }
                }
                this.addRecord(entry.getValue().getRecord(), entry.getValue().type, null);
            }
            this.tempEntries.clear();
            for (ORecord record : this.createdRecords.values()) {
                this.unmarshallRecord(record);
            }
            for (ORecord record : this.updatedRecords.values()) {
                this.unmarshallRecord(record);
            }
        }
        catch (IOException e) {
            this.rollback();
            throw new OSerializationException("Cannot read transaction record from the network. Transaction aborted", (Throwable)e);
        }
    }

    public ORecord getRecord(ORID rid) {
        ORecord record = super.getRecord(rid);
        if (record == OTransactionRealAbstract.DELETED_RECORD) {
            return record;
        }
        if (record == null && rid.isNew()) {
            record = this.createdRecords.get(rid);
        }
        return record;
    }

    private void fillIndexOperations(ODocument remoteIndexEntries) {
        for (Map.Entry indexEntry : remoteIndexEntries) {
            Collection entries;
            Boolean clearAll;
            String indexName = (String)indexEntry.getKey();
            ODocument indexDoc = (ODocument)indexEntry.getValue();
            if (indexDoc == null) continue;
            OTransactionIndexChanges transactionIndexChanges = (OTransactionIndexChanges)this.indexEntries.get(indexEntry.getKey());
            if (transactionIndexChanges == null) {
                transactionIndexChanges = new OTransactionIndexChanges();
                this.indexEntries.put(indexEntry.getKey(), transactionIndexChanges);
            }
            if ((clearAll = (Boolean)indexDoc.field("clear")) != null && clearAll.booleanValue()) {
                transactionIndexChanges.setCleared();
            }
            if ((entries = (Collection)indexDoc.field("entries")) == null) continue;
            for (ODocument entry : entries) {
                Object key;
                List operations = (List)entry.field("ops");
                if (operations == null) continue;
                try {
                    Object storedKey;
                    ODocument keyContainer;
                    if (this.protocolVersion <= 24) {
                        String serializedKey = OStringSerializerHelper.decode((String)((String)entry.field("k")));
                        if (serializedKey.equals("*")) {
                            keyContainer = null;
                        } else {
                            keyContainer = new ODocument();
                            keyContainer.setLazyLoad(false);
                            ORecordSerializerSchemaAware2CSV.INSTANCE.fromString(serializedKey, (ORecord)keyContainer, null);
                        }
                    } else {
                        keyContainer = (ODocument)entry.field("k");
                    }
                    key = keyContainer != null ? ((storedKey = keyContainer.field("key")) instanceof List ? new OCompositeKey((List)storedKey) : (Boolean.TRUE.equals(keyContainer.field("binary")) ? OStreamSerializerAnyStreamable.INSTANCE.fromStream((byte[])storedKey) : storedKey)) : null;
                }
                catch (IOException ioe) {
                    throw new OTransactionException("Error during index changes deserialization. ", (Throwable)ioe);
                }
                for (ODocument op : operations) {
                    int operation = (Integer)op.rawField("o");
                    OTransactionIndexChanges.OPERATION indexOperation = OTransactionIndexChanges.OPERATION.values()[operation];
                    OIdentifiable value = (OIdentifiable)op.field("v");
                    transactionIndexChanges.getChangesPerKey(key).add(value, indexOperation);
                    if (value == null) continue;
                    ORID rid = value.getIdentity();
                    ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation> txIndexOperations = (ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation>)this.recordIndexOperations.get(rid);
                    if (txIndexOperations == null) {
                        txIndexOperations = new ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation>();
                        this.recordIndexOperations.put(rid, txIndexOperations);
                    }
                    txIndexOperations.add(new OTransactionRealAbstract.OTransactionRecordIndexOperation(indexName, key, indexOperation));
                }
            }
        }
    }

    public Map<ORecordId, ORecord> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord> getUpdatedRecords() {
        return this.updatedRecords;
    }

    private void unmarshallRecord(ORecord iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            for (Map.Entry field : (ODocument)iRecord) {
                Object value = field.getValue();
                if (value instanceof ORecordLazyList) {
                    ((ORecordLazyList)field.getValue()).lazyLoad(true);
                    continue;
                }
                if (!(value instanceof ORidBag)) continue;
                ((ORidBag)value).convertLinks2Records();
            }
        }
    }
}

