/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;
import java.util.Map;

public class OServerCommandPostAuthToken
extends OServerCommandAbstract {
    private static final String[] NAMES = new String[]{"POST|token/*"};
    private static final String RESPONSE_FORMAT = "indent:-1,attribSameRow";
    private volatile OTokenHandler tokenHandler;
    private volatile boolean hasToken = true;

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private void init() {
        if (this.hasToken && this.tokenHandler == null) {
            this.tokenHandler = (OTokenHandler)this.server.getPlugin("OTokenHandler");
            if (this.tokenHandler != null && !this.tokenHandler.isEnabled()) {
                this.tokenHandler = null;
                this.hasToken = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.init();
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: token/<database>");
        iRequest.databaseName = urlParts[1];
        iRequest.data.commandInfo = "Generate authentication token";
        Map<String, String> content = iRequest.getUrlEncodedContent();
        String signedToken = "";
        String grantType = content.get("grant_type").toLowerCase();
        String username = content.get("username");
        String password = content.get("password");
        if (grantType.equals("password")) {
            String authenticatedRid = this.authenticate(username, password, iRequest.databaseName);
            if (authenticatedRid == null) {
                this.sendAuthorizationRequest(iRequest, iResponse, iRequest.databaseName);
            } else {
                ODatabaseDocumentTx db = null;
                OSecurityUser user = null;
                try {
                    db = (ODatabaseDocumentTx)this.server.openDatabase("document", iRequest.databaseName, username, password);
                    user = db.getUser();
                    if (user != null) {
                        byte[] tokenBytes = this.tokenHandler.getSignedWebToken((ODatabaseDocumentInternal)db, user);
                        signedToken = new String(tokenBytes);
                    }
                }
                catch (OSecurityAccessException e) {
                }
                catch (OLockException e) {
                    OLogManager.instance().error((Object)this, "Cannot access to the database '" + iRequest.databaseName + "'", new Object[]{ODatabaseException.class, e});
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                }
                ODocument result = new ODocument().field("access_token", (Object)signedToken).field("expires_in", (Object)3600);
                iResponse.writeRecord((ORecord)result, RESPONSE_FORMAT, null);
            }
        } else {
            ODocument result = new ODocument().field("error", (Object)"unsupported_grant_type");
            this.sendError(iRequest, iResponse, result);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String authenticate(String username, String password, String iDatabaseName) throws IOException {
        ODatabaseDocumentTx db = null;
        String userRid = null;
        try {
            db = (ODatabaseDocumentTx)this.server.openDatabase("document", iDatabaseName, username, password);
            userRid = db.getUser() == null ? "<server user>" : db.getUser().getDocument().getIdentity().toString();
        }
        catch (OSecurityAccessException e) {
        }
        catch (OLockException e) {
            OLogManager.instance().error((Object)this, "Cannot access to the database '" + iDatabaseName + "'", new Object[]{ODatabaseException.class, e});
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return userRid;
    }

    protected void sendError(OHttpRequest iRequest, OHttpResponse iResponse, ODocument error) throws IOException {
        iResponse.send(400, "Bad request", "application/json", error.toJSON(), null);
    }

    protected void sendAuthorizationRequest(OHttpRequest iRequest, OHttpResponse iResponse, String iDatabaseName) throws IOException {
        String header = null;
        if (iRequest.authentication == null || iRequest.authentication.equalsIgnoreCase("basic")) {
            header = "WWW-Authenticate: Basic realm=\"OrientDB db-" + iDatabaseName + "\"";
        }
        if (this.isJsonResponse(iResponse)) {
            this.sendJsonError(iResponse, 400, "Bad request", "text/plain", "401 Unauthorized.", header);
        } else {
            iResponse.send(401, "Unauthorized", "text/plain", "401 Unauthorized.", header);
        }
    }
}

