/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OSQLCommandTask
extends OAbstractCommandTask {
    private static final long serialVersionUID = 1L;
    protected String text;
    protected Map<Object, Object> params;
    protected OAbstractRemoteTask.RESULT_STRATEGY resultStrategy;
    protected Collection<String> clusters;
    protected OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType;
    protected long timeout;

    public OSQLCommandTask() {
        this.clusters = new HashSet<String>();
    }

    public OSQLCommandTask(OCommandRequestText iCommand, Collection<String> iClusterNames) {
        this.clusters = iClusterNames;
        this.text = iCommand.getText();
        this.params = iCommand.getParameters();
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.parse((OCommandRequest)iCommand);
        this.quorumType = ((OCommandDistributedReplicateRequest)executor).getQuorumType();
        this.timeout = ((OCommandDistributedReplicateRequest)executor).getDistributedTimeout();
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        OCommandExecutor exec;
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "execute command=%s db=%s", this.text.toString(), database.getName());
        }
        OCommandRequest cmd = database.command((OCommandRequest)new OCommandSQL(this.text));
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)cmd);
        executor.parse(cmd);
        Object object = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        if (exec instanceof OCommandExecutorSQLSelect && this.clusters.size() > 0) {
            Iterator target = ((OCommandExecutorSQLSelect)exec).getTarget();
            int[] clusterIds = new int[this.clusters.size()];
            int i = 0;
            for (String c : this.clusters) {
                clusterIds[i++] = database.getClusterIdByName(c);
            }
            ORecordIteratorClusters filteredTarget = new ORecordIteratorClusters((ODatabaseDocumentInternal)database, (ODatabaseDocumentInternal)database, clusterIds);
            if (target instanceof ORecordIteratorClusters) {
                filteredTarget.setRange(((ORecordIteratorClusters)target).getBeginRange(), ((ORecordIteratorClusters)target).getEndRange());
            }
            ((OCommandExecutorSQLSelect)exec).setTarget((Iterator)filteredTarget);
        }
        Object res = this.params != null ? executor.execute(this.params) : executor.execute(null);
        return res;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return this.quorumType;
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return this.resultStrategy;
    }

    @Override
    public void setResultStrategy(OAbstractRemoteTask.RESULT_STRATEGY resultStrategy) {
        this.resultStrategy = resultStrategy;
    }

    @Override
    public long getDistributedTimeout() {
        return this.timeout;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.text);
        out.writeObject(this.params);
        out.writeInt(this.clusters.size());
        for (String c : this.clusters) {
            out.writeUTF(c);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.text = in.readUTF();
        this.params = (Map)in.readObject();
        int cSize = in.readInt();
        this.clusters = new HashSet<String>(cSize);
        for (int i = 0; i < cSize; ++i) {
            this.clusters.add(in.readUTF());
        }
    }

    @Override
    public String getName() {
        return "command_sql";
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.text + ")";
    }

    @Override
    public String getPayload() {
        return this.text;
    }
}

