/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.plugin.livequery;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.sql.OLiveCommandExecutorSQLFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;

public class OLiveQueryPlugin
extends OServerPluginAbstract
implements ODatabaseLifecycleListener {
    private boolean enabled = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        super.config(iServer, iParams);
        for (OServerParameterConfiguration param : iParams) {
            if (!param.name.equalsIgnoreCase("enabled") || !Boolean.parseBoolean(param.value)) continue;
            this.enabled = true;
        }
    }

    public String getName() {
        return "LiveQueryPlugin";
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.LATE;
    }

    @Override
    public void startup() {
        super.startup();
        if (this.enabled) {
            OLiveCommandExecutorSQLFactory.init();
            Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
    }

    public void onCreate(ODatabaseInternal iDatabase) {
    }

    public void onOpen(ODatabaseInternal iDatabase) {
        if (this.enabled && iDatabase instanceof ODatabaseDocumentTx) {
            iDatabase.registerHook((ORecordHook)new OLiveQueryHook((ODatabaseDocumentTx)iDatabase), ORecordHook.HOOK_POSITION.LAST);
        }
    }

    public void onClose(ODatabaseInternal iDatabase) {
        if (this.enabled && iDatabase.getHooks() != null) {
            OLiveQueryHook toUnregister = null;
            for (Object hook : iDatabase.getHooks().keySet()) {
                if (!(hook instanceof OLiveQueryHook)) continue;
                toUnregister = (OLiveQueryHook)hook;
                break;
            }
            if (toUnregister != null) {
                iDatabase.unregisterHook(toUnregister);
            }
        }
    }

    public void onDrop(ODatabaseInternal iDatabase) {
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }
}

