/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.version.OSimpleVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.OFixTxTask;
import com.orientechnologies.orient.server.distributed.task.OTxTaskResult;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OTxTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    private List<OAbstractRecordReplicatedTask> tasks = new ArrayList<OAbstractRecordReplicatedTask>();
    private transient OTxTaskResult result;
    private transient boolean lockRecord = true;

    public void add(OAbstractRecordReplicatedTask iTask) {
        iTask.setInTx(true);
        this.tasks.add(iTask);
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "committing transaction against db=%s...", database.getName());
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)database);
        try {
            database.begin();
            OTransactionOptimistic tx = (OTransactionOptimistic)database.getTransaction();
            this.result = new OTxTaskResult();
            ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
            try {
                for (OAbstractRecordReplicatedTask task : this.tasks) {
                    if (task instanceof OCreateRecordTask) {
                        OCreateRecordTask createRT = (OCreateRecordTask)task;
                        int clId = createRT.clusterId > -1 ? createRT.clusterId : (createRT.getRid().isValid() ? createRT.getRid().getClusterId() : -1);
                        String clusterName = clId > -1 ? database.getClusterNameById(clId) : null;
                        tx.addRecord(createRT.getRecord(), (byte)3, clusterName);
                        continue;
                    }
                    ORecordId rid = task.getRid();
                    if (this.lockRecord && !ddb.lockRecord((ORID)rid, this.nodeSource)) {
                        throw new ODistributedRecordLockedException((ORID)rid);
                    }
                    this.result.locks.add((ORID)rid);
                }
                for (OAbstractRecordReplicatedTask task : this.tasks) {
                    ORecord record = task.getRecord();
                    if (!(record instanceof ODocument)) continue;
                    for (String f : ((ODocument)record).fieldNames()) {
                        Object fValue = ((ODocument)record).field(f);
                        if (fValue instanceof ORecordLazyMultiValue) {
                            ((ORecordLazyMultiValue)fValue).convertLinks2Records();
                            continue;
                        }
                        if (!(fValue instanceof ORecordId)) continue;
                        ((ODocument)record).field(f, (Object)((ORecordId)fValue).getRecord());
                    }
                }
                for (OAbstractRecordReplicatedTask task : this.tasks) {
                    Object taskResult = task.execute(iServer, iManager, database);
                    this.result.results.add(taskResult);
                }
                database.commit();
                for (int i = 0; i < this.result.results.size(); ++i) {
                    Object o = this.result.results.get(i);
                    OAbstractRecordReplicatedTask task = this.tasks.get(i);
                    if (task instanceof OCreateRecordTask) {
                        OCreateRecordTask t = (OCreateRecordTask)task;
                        this.result.results.set(i, new OPlaceholder(t.getRecord()));
                        continue;
                    }
                    if (!(task instanceof OUpdateRecordTask)) continue;
                    if (((OSimpleVersion)o).getCounter() < 0) {
                        this.result.results.set(i, task.getRid().getRecord().reload().getRecordVersion());
                        continue;
                    }
                    this.result.results.set(i, o);
                }
            }
            catch (Exception t) {
                for (ORID r : this.result.locks) {
                    ddb.unlockRecord(r);
                }
                for (OAbstractRecordReplicatedTask task : this.tasks) {
                    if (!(task instanceof OCreateRecordTask)) continue;
                    OCreateRecordTask createRT = (OCreateRecordTask)task;
                    createRT.resetRecord();
                }
                throw t;
            }
            return this.result;
        }
        catch (ONeedRetryException e) {
            database.rollback();
            return e;
        }
        catch (OTransactionException e) {
            database.rollback();
            return e;
        }
        catch (ORecordDuplicatedException e) {
            database.rollback();
            return e;
        }
        catch (ORecordNotFoundException e) {
            database.rollback();
            return e;
        }
        catch (Exception e) {
            database.rollback();
            OLogManager.instance().error((Object)this, "Error on distributed transaction commit", (Throwable)e, new Object[0]);
            return e;
        }
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public Set<ORID> getRidsToLock() {
        HashSet<ORID> locks = new HashSet<ORID>();
        for (OAbstractRecordReplicatedTask task : this.tasks) {
            if (task instanceof OCreateRecordTask) continue;
            locks.add((ORID)task.getRid());
        }
        return locks;
    }

    @Override
    public OFixTxTask getFixTask(ODistributedRequest iRequest, OAbstractRemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse) {
        if (!(iBadResponse instanceof OTxTaskResult)) {
            ODistributedServerLog.debug((Object)this, this.getNodeSource(), null, ODistributedServerLog.DIRECTION.NONE, "error on creating fix-task for request: '%s' because bad response is not expected type: %s", iRequest, iBadResponse);
            return null;
        }
        if (!(iGoodResponse instanceof OTxTaskResult)) {
            ODistributedServerLog.debug((Object)this, this.getNodeSource(), null, ODistributedServerLog.DIRECTION.NONE, "error on creating fix-task for request: '%s' because good response is not expected type: %s", iRequest, iBadResponse);
            return null;
        }
        OFixTxTask fixTask = new OFixTxTask(((OTxTaskResult)iBadResponse).locks);
        for (int i = 0; i < this.tasks.size(); ++i) {
            OAbstractRecordReplicatedTask t = this.tasks.get(i);
            OAbstractRemoteTask task = t.getFixTask(iRequest, t, ((OTxTaskResult)iBadResponse).results.get(i), ((OTxTaskResult)iGoodResponse).results.get(i));
            if (task == null) continue;
            fixTask.add(task);
        }
        return fixTask;
    }

    @Override
    public OAbstractRemoteTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        if (this.result == null) {
            return null;
        }
        return this.getUndoTaskForLocalStorage(iBadResponse);
    }

    public OAbstractRemoteTask getUndoTaskForLocalStorage(Object iBadResponse) {
        OFixTxTask fixTask = new OFixTxTask(this.result != null ? this.result.locks : new HashSet());
        for (int i = 0; i < this.tasks.size(); ++i) {
            OAbstractRecordReplicatedTask t = this.tasks.get(i);
            OAbstractRemoteTask undoTask = iBadResponse instanceof List ? t.getUndoTask(null, ((List)iBadResponse).get(i)) : t.getUndoTask(null, iBadResponse);
            if (undoTask == null) continue;
            fixTask.add(undoTask);
        }
        return fixTask;
    }

    public boolean isLockRecord() {
        return this.lockRecord;
    }

    public void setLockRecord(boolean lockRecord) {
        this.lockRecord = lockRecord;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.tasks.size());
        for (OAbstractRecordReplicatedTask task : this.tasks) {
            out.writeObject(task);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.tasks.add((OAbstractRecordReplicatedTask)in.readObject());
        }
    }

    @Override
    public long getDistributedTimeout() {
        long to = OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
        return to + to / 2L * (long)this.tasks.size();
    }

    @Override
    public String getName() {
        return "tx";
    }

    @Override
    public String getPayload() {
        return null;
    }

    public List<OAbstractRecordReplicatedTask> getTasks() {
        return this.tasks;
    }
}

