/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionAbortedException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.OFetchPlan;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchContext;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.ONetworkThreadLocalSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.memory.ODirectMemoryStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.ShutdownHelper;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OAsyncCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OBinaryNetworkProtocolAbstract;
import com.orientechnologies.orient.server.network.protocol.binary.OLiveCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OSyncCommandResultListener;
import com.orientechnologies.orient.server.plugin.OServerPluginHelper;
import com.orientechnologies.orient.server.security.OSecurityServerUser;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticProxy;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ONetworkProtocolBinary
extends OBinaryNetworkProtocolAbstract {
    protected OClientConnection connection;
    protected Boolean tokenBased;

    public ONetworkProtocolBinary() {
        super("OrientDB <- BinaryClient/?");
    }

    public ONetworkProtocolBinary(String iThreadName) {
        super(iThreadName);
    }

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super.config(iListener, iServer, iSocket, iConfig);
        this.channel.writeShort((short)this.getVersion());
        this.channel.flush();
        this.start();
        this.setName("OrientDB <- BinaryClient (" + iSocket.getRemoteSocketAddress() + ")");
    }

    public void startup() {
        super.startup();
        OServerPluginHelper.invokeHandlerCallbackOnClientConnection(this.server, this.connection);
    }

    @Override
    public void shutdown() {
        this.sendShutdown();
        super.shutdown();
        if (this.connection == null) {
            return;
        }
        OServerPluginHelper.invokeHandlerCallbackOnClientDisconnection(this.server, this.connection);
        this.server.getClientConnectionManager().disconnect(this.connection);
    }

    @Override
    protected void onBeforeRequest() throws IOException {
        this.waitNodeIsOnline();
        this.connection = this.server.getClientConnectionManager().getConnection(this.clientTxId, this);
        if (this.connection == null || !Boolean.TRUE.equals(this.connection.tokenBased) || this.requestType == 2 || this.requestType == 3 || this.tokenHandler == null) {
            if (this.clientTxId < 0) {
                short protocolId = 0;
                if (this.connection != null) {
                    protocolId = this.connection.data.protocolVersion;
                }
                this.connection = this.server.getClientConnectionManager().connect(this);
                if (this.connection != null) {
                    this.connection.data.protocolVersion = protocolId;
                }
            }
        } else if (this.requestType != 2 && this.requestType != 3) {
            byte[] tokenBytes = this.channel.readBytes();
            try {
                this.token = this.tokenHandler.parseBinaryToken(tokenBytes);
            }
            catch (Exception e) {
                throw new OException("error on token parse", (Throwable)e);
            }
            if (this.token == null || !this.token.getIsVerified()) {
                throw new OSecurityException("The token provided is not a valid token, signature doesn't match");
            }
            if (this.token != null) {
                ONetworkProtocolData data;
                if (!this.tokenHandler.validateBinaryToken(this.token)) {
                    throw new OSecurityException("The token provided is expired");
                }
                this.connection = new OClientConnection(this.clientTxId, this);
                if (this.connection.tokenBased == null) {
                    this.connection.tokenBased = Boolean.TRUE;
                }
                if (this.tokenHandler != null && (data = this.tokenHandler.getProtocolDataFromToken(this.token)) != null) {
                    this.connection.data = data;
                }
                String db = this.token.getDatabase();
                String type = this.token.getDatabaseType();
                if (db != null && type != null) {
                    ODatabaseDocumentTx database = new ODatabaseDocumentTx(type + ":" + db);
                    if (this.connection.data.serverUser) {
                        database.resetInitialization();
                        database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityServerUser.class);
                        database.open(this.connection.data.serverUsername, null);
                    } else {
                        database.open(this.token);
                    }
                    this.connection.database = database;
                }
                if (this.connection.data.serverUser) {
                    this.connection.serverUser = this.server.getUser(this.connection.data.serverUsername);
                }
            }
        }
        if (this.connection != null) {
            this.connection.acquire();
            if (this.connection.database != null) {
                this.connection.database.activateOnCurrentThread();
                this.connection.data.lastDatabase = this.connection.database.getName();
                this.connection.data.lastUser = this.connection.database.getUser() != null ? this.connection.database.getUser().getName() : null;
            } else {
                this.connection.data.lastDatabase = null;
                this.connection.data.lastUser = null;
            }
            ++this.connection.data.totalRequests;
            this.setDataCommandInfo("Listening");
            this.connection.data.commandDetail = "-";
            this.connection.data.lastCommandReceived = System.currentTimeMillis();
        } else {
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            if (this.requestType != 5 && this.requestType != 1) {
                OLogManager.instance().debug((Object)this, "Found unknown session %d, shutdown current connection", new Object[]{this.clientTxId});
                this.shutdown();
                throw new OIOException("Found unknown session " + this.clientTxId);
            }
        }
        OServerPluginHelper.invokeHandlerCallbackOnBeforeClientRequest(this.server, this.connection, (byte)this.requestType);
    }

    @Override
    protected void onAfterRequest() throws IOException {
        OServerPluginHelper.invokeHandlerCallbackOnAfterClientRequest(this.server, this.connection, (byte)this.requestType);
        if (this.connection != null) {
            if (!Boolean.TRUE.equals(this.connection.tokenBased)) {
                if (this.connection.database != null && !this.connection.database.isClosed() && this.connection.database.getLocalCache() != null) {
                    this.connection.database.getLocalCache().clear();
                }
            } else {
                if (this.connection.database != null && !this.connection.database.isClosed()) {
                    this.connection.database.close();
                }
                this.connection.database = null;
            }
            this.connection.data.lastCommandExecutionTime = System.currentTimeMillis() - this.connection.data.lastCommandReceived;
            this.connection.data.totalCommandExecutionTime += this.connection.data.lastCommandExecutionTime;
            this.connection.data.lastCommandInfo = this.connection.data.commandInfo;
            this.connection.data.lastCommandDetail = this.connection.data.commandDetail;
            this.setDataCommandInfo("Listening");
            this.connection.data.commandDetail = "-";
            this.connection.release();
        }
    }

    @Override
    protected boolean executeRequest() throws IOException {
        try {
            switch (this.requestType) {
                case 1: {
                    this.shutdownConnection();
                    break;
                }
                case 2: {
                    this.connect();
                    break;
                }
                case 74: {
                    this.listDatabases();
                    break;
                }
                case 3: {
                    this.openDatabase();
                    break;
                }
                case 73: {
                    this.reloadDatabase();
                    break;
                }
                case 4: {
                    this.createDatabase();
                    break;
                }
                case 5: {
                    this.closeDatabase();
                    break;
                }
                case 6: {
                    this.existsDatabase();
                    break;
                }
                case 7: {
                    this.dropDatabase();
                    break;
                }
                case 8: {
                    this.sizeDatabase();
                    break;
                }
                case 9: {
                    this.countDatabaseRecords();
                    break;
                }
                case 90: {
                    this.copyDatabase();
                    break;
                }
                case 91: {
                    this.replicationDatabase();
                    break;
                }
                case 92: {
                    this.distributedCluster();
                    break;
                }
                case 12: {
                    this.countClusters();
                    break;
                }
                case 13: {
                    this.rangeCluster();
                    break;
                }
                case 10: {
                    this.addCluster();
                    break;
                }
                case 11: {
                    this.removeCluster();
                    break;
                }
                case 29: {
                    this.readRecordMetadata();
                    break;
                }
                case 30: {
                    this.readRecord();
                    break;
                }
                case 44: {
                    this.readRecordIfVersionIsNotLatest();
                    break;
                }
                case 31: {
                    this.createRecord();
                    break;
                }
                case 32: {
                    this.updateRecord();
                    break;
                }
                case 33: {
                    this.deleteRecord();
                    break;
                }
                case 43: {
                    this.hideRecord();
                    break;
                }
                case 36: {
                    this.higherPositions();
                    break;
                }
                case 42: {
                    this.ceilingPositions();
                    break;
                }
                case 37: {
                    this.lowerPositions();
                    break;
                }
                case 39: {
                    this.floorPositions();
                    break;
                }
                case 40: {
                    throw new UnsupportedOperationException("Operation OChannelBinaryProtocol.REQUEST_COUNT has been deprecated");
                }
                case 41: {
                    this.command();
                    break;
                }
                case 60: {
                    this.commit();
                    break;
                }
                case 70: {
                    this.configGet();
                    break;
                }
                case 71: {
                    this.configSet();
                    break;
                }
                case 72: {
                    this.configList();
                    break;
                }
                case 94: {
                    this.freezeDatabase();
                    break;
                }
                case 95: {
                    this.releaseDatabase();
                    break;
                }
                case 38: {
                    this.cleanOutRecord();
                    break;
                }
                case 110: {
                    this.createSBTreeBonsai();
                    break;
                }
                case 111: {
                    this.sbTreeBonsaiGet();
                    break;
                }
                case 112: {
                    this.sbTreeBonsaiFirstKey();
                    break;
                }
                case 113: {
                    this.sbTreeBonsaiGetEntriesMajor();
                    break;
                }
                case 114: {
                    this.ridBagSize();
                    break;
                }
                case 120: {
                    this.indexGet();
                    break;
                }
                case 121: {
                    this.indexPut();
                    break;
                }
                case 122: {
                    this.indexRemove();
                    break;
                }
                default: {
                    this.setDataCommandInfo("Command not supported");
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            OSBTreeCollectionManager collectionManager;
            if (this.connection != null && this.connection.database != null && (collectionManager = this.connection.database.getSbTreeCollectionManager()) != null) {
                collectionManager.clearChangedIds();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexPut() throws IOException {
        this.setDataCommandInfo("Put an entry in an index");
        if (!this.isConnectionAlive()) {
            return;
        }
        String indexName = this.channel.readString();
        Object key = new ODocument().fromStream(this.channel.readBytes()).field("key");
        ORecordId value = this.channel.readRID();
        OIndex index = this.connection.database.getMetadata().getIndexManager().getIndex(indexName);
        if (index == null) {
            throw new OException("index with name '" + indexName + "' was not found");
        }
        key = index.getDefinition().createValue(new Object[]{key});
        if (!this.isConnectionAlive()) {
            return;
        }
        this.beginResponse();
        try {
            try {
                index.put(key, (OIdentifiable)value);
                this.sendOk(this.clientTxId);
            }
            catch (ORecordDuplicatedException ex) {
                this.sendError(this.clientTxId, ex);
            }
        }
        finally {
            this.connection.data.command = null;
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexRemove() throws IOException {
        this.setDataCommandInfo("Remove an entry from index");
        if (!this.isConnectionAlive()) {
            return;
        }
        String indexName = this.channel.readString();
        Object key = new ODocument().fromStream(this.channel.readBytes()).field("key");
        OIndex index = this.connection.database.getMetadata().getIndexManager().getIndex(indexName);
        if (index == null) {
            throw new OException("index with name '" + indexName + "' not found");
        }
        key = index.getDefinition().createValue(new Object[]{key});
        if (!this.isConnectionAlive()) {
            return;
        }
        boolean res = index.remove(key);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeBoolean(res);
        }
        finally {
            this.connection.data.command = null;
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexGet() throws IOException {
        this.setDataCommandInfo("Retrieve an entry from index");
        if (!this.isConnectionAlive()) {
            return;
        }
        String indexName = this.channel.readString();
        ODocument document = new ODocument();
        this.fillRecord(new ORecordId(), this.channel.readBytes(), OVersionFactory.instance().createVersion(), (ORecord)document, (ODatabaseDocumentInternal)this.connection.database);
        Object key = document.field("key");
        String fetchPlan = this.channel.readString();
        OIndex index = this.connection.database.getMetadata().getIndexManager().getIndex(indexName);
        if (index == null) {
            throw new OException("index with name '" + indexName + "' not found");
        }
        key = index.getDefinition().createValue(new Object[]{key});
        OSyncCommandResultListener listener = new OSyncCommandResultListener();
        if (!this.isConnectionAlive()) {
            return;
        }
        listener.setFetchPlan(fetchPlan);
        Object result = index.get(key);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.serializeValue(listener, result, true, false);
            if (this.connection.data.protocolVersion >= 17 && listener instanceof OSyncCommandResultListener) {
                for (ORecord rec : listener.getFetchedRecordsToSend()) {
                    this.channel.writeByte((byte)2);
                    this.writeIdentifiable((OIdentifiable)rec);
                }
                this.channel.writeByte((byte)0);
            }
        }
        finally {
            this.connection.data.command = null;
            this.endResponse();
        }
    }

    protected void checkServerAccess(String iResource) {
        if (this.connection.data.protocolVersion <= 26) {
            if (this.connection.serverUser == null) {
                throw new OSecurityAccessException("Server user not authenticated.");
            }
            if (!this.server.isAllowed(this.connection.serverUser.name, iResource)) {
                throw new OSecurityAccessException("User '" + this.connection.serverUser.name + "' cannot access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
            }
        } else {
            if (!this.connection.data.serverUser) {
                throw new OSecurityAccessException("Server user not authenticated.");
            }
            if (!this.server.isAllowed(this.connection.data.serverUsername, iResource)) {
                throw new OSecurityAccessException("User '" + this.connection.data.serverUsername + "' cannot access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
            }
        }
    }

    protected ODatabase<?> openDatabase(ODatabaseInternal<?> database, String iUser, String iPassword) {
        if (database.isClosed()) {
            if (database.getStorage() instanceof ODirectMemoryStorage && !database.exists()) {
                database.create();
            } else {
                try {
                    database.open(iUser, iPassword);
                }
                catch (OSecurityException e) {
                    try {
                        this.connection.serverUser = this.server.serverLogin(iUser, iPassword, "database.passthrough");
                    }
                    catch (OSecurityException ex) {
                        throw e;
                    }
                    database.activateOnCurrentThread();
                    database.resetInitialization();
                    database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityServerUser.class);
                    database.open(iUser, iPassword);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCluster() throws IOException {
        this.setDataCommandInfo("Remove cluster");
        if (!this.isConnectionAlive()) {
            return;
        }
        short id = this.channel.readShort();
        String clusterName = this.connection.database.getClusterNameById((int)id);
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster " + id + " doesn't exist anymore. Refresh the db structure or just reconnect to the database");
        }
        boolean result = this.connection.database.dropCluster(clusterName, true);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeByte((byte)(result ? 1 : 0));
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCluster() throws IOException {
        this.setDataCommandInfo("Add cluster");
        if (!this.isConnectionAlive()) {
            return;
        }
        String type = "";
        if (this.connection.data.protocolVersion < 24) {
            type = this.channel.readString();
        }
        String name = this.channel.readString();
        int clusterId = -1;
        if (this.connection.data.protocolVersion >= 10 && this.connection.data.protocolVersion < 24 || type.equalsIgnoreCase("PHYSICAL")) {
            String location = this.channel.readString();
        } else {
            Object location = null;
        }
        if (this.connection.data.protocolVersion < 24) {
            String dataSegmentName;
            if (this.connection.data.protocolVersion >= 10) {
                dataSegmentName = this.channel.readString();
            } else {
                this.channel.readInt();
                dataSegmentName = null;
            }
        }
        if (this.connection.data.protocolVersion >= 18) {
            clusterId = this.channel.readShort();
        }
        int num = clusterId < 0 ? this.connection.database.addCluster(name, new Object[0]) : this.connection.database.addCluster(name, clusterId, null);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeShort((short)num);
        }
        finally {
            this.endResponse();
        }
    }

    protected void rangeCluster() throws IOException {
        this.setDataCommandInfo("Get the begin/end range of data in cluster");
        if (!this.isConnectionAlive()) {
            return;
        }
        long[] pos = this.connection.database.getStorage().getClusterDataRange((int)this.channel.readShort());
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(pos[0]);
            this.channel.writeLong(pos[1]);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void countClusters() throws IOException {
        this.setDataCommandInfo("Count cluster elements");
        if (!this.isConnectionAlive()) {
            return;
        }
        int[] clusterIds = new int[this.channel.readShort()];
        for (int i = 0; i < clusterIds.length; ++i) {
            clusterIds[i] = this.channel.readShort();
        }
        boolean countTombstones = false;
        if (this.connection.data.protocolVersion >= 13) {
            countTombstones = this.channel.readByte() > 0;
        }
        long count = this.connection.database.countClusterElements(clusterIds, countTombstones);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(count);
        }
        finally {
            this.endResponse();
        }
    }

    protected void reloadDatabase() throws IOException {
        this.setDataCommandInfo("Reload database information");
        if (!this.isConnectionAlive()) {
            return;
        }
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.sendDatabaseInformation();
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openDatabase() throws IOException {
        this.setDataCommandInfo("Open database");
        this.readConnectionData();
        String dbURL = this.channel.readString();
        String dbType = "document";
        if (this.connection.data.protocolVersion >= 8) {
            dbType = this.channel.readString();
        }
        String user = this.channel.readString();
        String passwd = this.channel.readString();
        try {
            this.connection.database = (ODatabaseDocumentTx)this.server.openDatabase(dbType, dbURL, user, passwd, this.connection.data);
        }
        catch (OException e) {
            this.server.getClientConnectionManager().disconnect(this.connection);
            throw e;
        }
        if (this.connection.database.getStorage() instanceof OStorageProxy && !this.loadUserFromSchema(user, passwd)) {
            this.sendErrorOrDropConnection(this.clientTxId, new OSecurityAccessException(this.connection.database.getName(), "User or password not valid for database: '" + this.connection.database.getName() + "'"));
        } else {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeInt(this.connection.id);
                if (this.connection.data.protocolVersion > 26) {
                    if (Boolean.TRUE.equals(this.connection.tokenBased)) {
                        byte[] token = this.tokenHandler.getSignedBinaryToken((ODatabaseDocumentInternal)this.connection.database, this.connection.database.getUser(), this.connection.data);
                        this.channel.writeBytes(token);
                    } else {
                        this.channel.writeBytes(OCommonConst.EMPTY_BYTE_ARRAY);
                    }
                }
                this.sendDatabaseInformation();
                Object plugin = this.server.getPlugin("cluster");
                ODocument distributedCfg = null;
                if (plugin != null && plugin instanceof ODistributedServerManager) {
                    distributedCfg = ((ODistributedServerManager)plugin).getClusterConfiguration();
                }
                this.channel.writeBytes(distributedCfg != null ? this.getRecordBytes((ORecord)distributedCfg) : null);
                if (this.connection.data.protocolVersion >= 14) {
                    this.channel.writeString(OConstants.getVersion());
                }
            }
            finally {
                this.endResponse();
            }
        }
    }

    protected void connect() throws IOException {
        this.setDataCommandInfo("Connect");
        this.readConnectionData();
        this.connection.serverUser = this.server.serverLogin(this.channel.readString(), this.channel.readString(), "connect");
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeInt(this.connection.id);
            if (this.connection.data.protocolVersion > 26) {
                this.connection.data.serverUsername = this.connection.serverUser.name;
                this.connection.data.serverUser = true;
                byte[] token = Boolean.TRUE.equals(this.connection.tokenBased) ? this.tokenHandler.getSignedBinaryToken(null, null, this.connection.data) : OCommonConst.EMPTY_BYTE_ARRAY;
                this.channel.writeBytes(token);
            }
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendError(int iClientTxId, Throwable t) throws IOException {
        this.channel.acquireWriteLock();
        try {
            this.channel.writeByte((byte)1);
            this.channel.writeInt(iClientTxId);
            if ((this.connection == null || Boolean.TRUE.equals(this.connection.tokenBased)) && this.tokenHandler != null && this.token != null) {
                byte[] renewedToken = this.tokenHandler.renewIfNeeded(this.token);
                this.channel.writeBytes(renewedToken);
            }
            Throwable current = t instanceof OLockException && t.getCause() instanceof ODatabaseException ? t.getCause() : t;
            this.sendErrorDetails(current);
            if (this.connection != null && this.connection.data.protocolVersion >= 19) {
                this.serializeExceptionObject(current);
            }
            this.channel.flush();
            if (OLogManager.instance().isLevelEnabled(this.logClientExceptions)) {
                if (this.logClientFullStackTrace) {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", t, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                } else {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", null, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SocketException) {
                this.shutdown();
            } else {
                OLogManager.instance().error((Object)this, "Error during sending an error to client", (Throwable)e, new Object[0]);
            }
        }
        finally {
            if (this.channel.getLockWrite().isHeldByCurrentThread()) {
                this.channel.releaseWriteLock();
            }
        }
    }

    protected void shutdownConnection() throws IOException {
        this.setDataCommandInfo("Shutdowning");
        OLogManager.instance().info((Object)this, "Received shutdown command from the remote client %s:%d", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
        String user = this.channel.readString();
        String passwd = this.channel.readString();
        if (this.server.authenticate(user, passwd, "shutdown")) {
            OLogManager.instance().info((Object)this, "Remote client %s:%d authenticated. Starting shutdown of server...", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
            }
            finally {
                this.endResponse();
            }
            this.runShutdownInNonDaemonThread();
            return;
        }
        OLogManager.instance().error((Object)this, "Authentication error of remote client %s:%d: shutdown is aborted.", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
        this.sendErrorOrDropConnection(this.clientTxId, new OSecurityAccessException("Invalid user/password to shutdown the server"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDatabase() throws IOException {
        this.setDataCommandInfo("Copy the database to a remote server");
        String dbUrl = this.channel.readString();
        String dbUser = this.channel.readString();
        String dbPassword = this.channel.readString();
        String remoteServerName = this.channel.readString();
        String remoteServerEngine = this.channel.readString();
        this.checkServerAccess("database.copy");
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)this.server.openDatabase("document", dbUrl, dbUser, dbPassword);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    protected void replicationDatabase() throws IOException {
        this.setDataCommandInfo("Replication command");
        ODocument request = new ODocument(this.channel.readBytes());
        ODistributedServerManager dManager = this.server.getDistributedManager();
        if (dManager == null) {
            throw new OConfigurationException("No distributed manager configured");
        }
        String operation = (String)request.field("operation");
        ODocument response = null;
        if (operation.equals("start")) {
            this.checkServerAccess("server.replication.start");
        } else if (operation.equals("stop")) {
            this.checkServerAccess("server.replication.stop");
        } else if (operation.equals("config")) {
            this.checkServerAccess("server.replication.config");
            response = new ODocument().fromJSON(dManager.getDatabaseConfiguration((String)request.field("db")).serialize().toJSON("prettyPrint"));
        }
        this.sendResponse(response);
    }

    protected void distributedCluster() throws IOException {
        this.setDataCommandInfo("Cluster status");
        ODocument req = new ODocument(this.channel.readBytes());
        ODocument response = null;
        String operation = (String)req.field("operation");
        if (operation == null) {
            throw new IllegalArgumentException("Cluster operation is null");
        }
        if (operation.equals("status")) {
            Object plugin = this.server.getPlugin("cluster");
            if (plugin != null && plugin instanceof ODistributedServerManager) {
                response = ((ODistributedServerManager)plugin).getClusterConfiguration();
            }
        } else {
            throw new IllegalArgumentException("Cluster operation '" + operation + "' is not supported");
        }
        this.sendResponse(response);
    }

    protected void countDatabaseRecords() throws IOException {
        this.setDataCommandInfo("Database count records");
        if (!this.isConnectionAlive()) {
            return;
        }
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(this.connection.database.getStorage().countRecords());
        }
        finally {
            this.endResponse();
        }
    }

    protected void sizeDatabase() throws IOException {
        this.setDataCommandInfo("Database size");
        if (!this.isConnectionAlive()) {
            return;
        }
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(this.connection.database.getStorage().getSize());
        }
        finally {
            this.endResponse();
        }
    }

    protected void dropDatabase() throws IOException {
        this.setDataCommandInfo("Drop database");
        String dbName = this.channel.readString();
        String storageType = this.connection.data.protocolVersion >= 16 ? this.channel.readString() : "local";
        if (storageType == null) {
            storageType = "plocal";
        }
        this.checkServerAccess("database.delete");
        this.connection.database = this.getDatabaseInstance(dbName, "document", storageType);
        if (this.connection.database.exists()) {
            OLogManager.instance().info((Object)this, "Dropped database '%s'", new Object[]{this.connection.database.getName()});
            if (this.connection.database.isClosed()) {
                this.openDatabase((ODatabaseInternal<?>)this.connection.database, this.connection.serverUser.name, this.connection.serverUser.password);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' does not exist");
        }
        this.connection.database.drop();
        this.connection.close();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void existsDatabase() throws IOException {
        this.setDataCommandInfo("Exists database");
        String dbName = this.channel.readString();
        String storageType = this.connection.data.protocolVersion >= 16 ? this.channel.readString() : "local";
        this.checkServerAccess("database.exists");
        if (storageType != null) {
            this.connection.database = this.getDatabaseInstance(dbName, "document", storageType);
        } else {
            for (String engine : Orient.instance().getEngines()) {
                if (engine.equalsIgnoreCase("remote")) continue;
                this.connection.database = this.getDatabaseInstance(dbName, "document", engine);
                if (this.connection.database.exists()) break;
                Orient.instance().unregisterStorage(this.connection.database.getStorage());
            }
        }
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeByte((byte)(this.connection.database.exists() ? 1 : 0));
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDatabase() throws IOException {
        this.setDataCommandInfo("Create database");
        String dbName = this.channel.readString();
        String dbType = "document";
        if (this.connection.data.protocolVersion >= 8) {
            dbType = this.channel.readString();
        }
        String storageType = this.channel.readString();
        this.checkServerAccess("database.create");
        this.checkStorageExistence(dbName);
        this.connection.database = this.getDatabaseInstance(dbName, dbType, storageType);
        this.createDatabase(this.connection.database, null, null);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    protected void closeDatabase() throws IOException {
        this.setDataCommandInfo("Close Database");
        if (this.connection != null) {
            if (this.connection.data.protocolVersion > 0 && this.connection.data.protocolVersion < 9) {
                this.sendOk(this.clientTxId);
            }
            this.server.getClientConnectionManager().disconnect(this.connection.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configList() throws IOException {
        this.setDataCommandInfo("List config");
        this.checkServerAccess("server.config.get");
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeShort((short)OGlobalConfiguration.values().length);
            for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
                String value;
                String key;
                try {
                    key = cfg.getKey();
                }
                catch (Exception e) {
                    key = "?";
                }
                try {
                    value = cfg.getValueAsString() != null ? cfg.getValueAsString() : "";
                }
                catch (Exception e) {
                    value = "";
                }
                this.channel.writeString(key);
                this.channel.writeString(value);
            }
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configSet() throws IOException {
        this.setDataCommandInfo("Set config");
        this.checkServerAccess("server.config.set");
        String key = this.channel.readString();
        String value = this.channel.readString();
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)key);
        if (cfg != null) {
            cfg.setValue((Object)value);
            if (!cfg.isChangeableAtRuntime().booleanValue()) {
                throw new OConfigurationException("Property '" + key + "' cannot be changed at runtime. Change the setting at startup");
            }
        } else {
            throw new OConfigurationException("Property '" + key + "' was not found in global configuration");
        }
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configGet() throws IOException {
        this.setDataCommandInfo("Get config");
        this.checkServerAccess("server.config.get");
        String key = this.channel.readString();
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)key);
        String cfgValue = cfg != null ? cfg.getValueAsString() : "";
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeString(cfgValue);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit() throws IOException {
        this.setDataCommandInfo("Transaction commit");
        if (!this.isConnectionAlive()) {
            return;
        }
        OTransactionOptimisticProxy tx = new OTransactionOptimisticProxy(this.connection.database, (OChannelBinary)this.channel, this.connection.data.protocolVersion, this);
        try {
            this.connection.database.begin((OTransaction)tx);
            try {
                this.connection.database.commit();
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    this.channel.writeInt(tx.getCreatedRecords().size());
                    for (Map.Entry<ORecordId, ORecord> entry : tx.getCreatedRecords().entrySet()) {
                        this.channel.writeRID((ORID)entry.getKey());
                        this.channel.writeRID(entry.getValue().getIdentity());
                        if (entry.getValue().getRecordVersion().getCounter() <= 0) continue;
                        tx.getUpdatedRecords().put((ORecordId)entry.getValue().getIdentity(), entry.getValue());
                    }
                    this.channel.writeInt(tx.getUpdatedRecords().size());
                    for (Map.Entry<ORecordId, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
                        this.channel.writeRID((ORID)entry.getKey());
                        this.channel.writeVersion(entry.getValue().getRecordVersion());
                    }
                    if (this.connection.data.protocolVersion >= 20) {
                        this.sendCollectionChanges();
                    }
                }
                finally {
                    this.endResponse();
                }
            }
            catch (Exception e) {
                if (this.connection != null && this.connection.database != null) {
                    OSBTreeCollectionManager collectionManager;
                    if (this.connection.database.getTransaction().isActive()) {
                        this.connection.database.rollback(true);
                    }
                    if ((collectionManager = this.connection.database.getSbTreeCollectionManager()) != null) {
                        collectionManager.clearChangedIds();
                    }
                }
                this.sendErrorOrDropConnection(this.clientTxId, e);
            }
        }
        catch (OTransactionAbortedException e) {
        }
        catch (Exception e) {
            if (tx.isActive()) {
                tx.rollback(true, -1);
            }
            this.sendErrorOrDropConnection(this.clientTxId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void command() throws IOException {
        block18: {
            this.setDataCommandInfo("Execute remote command");
            byte type = this.channel.readByte();
            boolean live = type == 108;
            boolean asynch = type == 97;
            String dbSerializerName = this.connection.database.getSerializer().toString();
            String name = this.getRecordSerializerName();
            if (!dbSerializerName.equals(name)) {
                ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
                ONetworkThreadLocalSerializer.setNetworkSerializer((ORecordSerializer)ser);
            }
            OCommandRequestText command = (OCommandRequestText)OStreamSerializerAnyStreamable.INSTANCE.fromStream(this.channel.readBytes());
            ONetworkThreadLocalSerializer.setNetworkSerializer(null);
            this.connection.data.commandDetail = command.getText();
            this.beginResponse();
            try {
                this.connection.data.command = command;
                OAbstractCommandResultListener listener = null;
                OLiveCommandResultListener liveListener = null;
                if (live) {
                    liveListener = new OLiveCommandResultListener(this, this.clientTxId, command.getResultListener());
                    listener = new OSyncCommandResultListener();
                    command.setResultListener((OCommandResultListener)liveListener);
                } else if (asynch) {
                    listener = new OAsyncCommandResultListener(this, this.clientTxId, command.getResultListener());
                    command.setResultListener((OCommandResultListener)listener);
                } else {
                    listener = new OSyncCommandResultListener();
                }
                long serverTimeout = OGlobalConfiguration.COMMAND_TIMEOUT.getValueAsLong();
                if (serverTimeout > 0L && command.getTimeoutTime() > serverTimeout) {
                    command.setTimeout(serverTimeout, command.getTimeoutStrategy());
                }
                if (!this.isConnectionAlive()) {
                    return;
                }
                listener.setFetchPlan(this.connection.database.command((OCommandRequest)command).getFetchPlan());
                Object result = this.connection.database.command((OCommandRequest)command).execute(new Object[0]);
                listener.setFetchPlan(command.getFetchPlan());
                if (asynch) {
                    if (listener.isEmpty()) {
                        try {
                            this.sendOk(this.clientTxId);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.channel.writeByte((byte)0);
                    break block18;
                }
                this.sendOk(this.clientTxId);
                boolean isRecordResultSet = true;
                if (command instanceof OCommandRequestInternal) {
                    isRecordResultSet = command.isRecordResultSet();
                }
                this.serializeValue(listener, result, false, isRecordResultSet);
                if (this.connection.data.protocolVersion >= 17 && listener instanceof OSyncCommandResultListener) {
                    for (ORecord rec : ((OSyncCommandResultListener)listener).getFetchedRecordsToSend()) {
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable((OIdentifiable)rec);
                    }
                    this.channel.writeByte((byte)0);
                }
            }
            finally {
                this.connection.data.command = null;
                this.endResponse();
            }
        }
    }

    public void serializeValue(OAbstractCommandResultListener listener, Object result, boolean load, boolean isRecordResultSet) throws IOException {
        if (result == null) {
            this.channel.writeByte((byte)110);
        } else if (result instanceof OIdentifiable) {
            this.channel.writeByte((byte)114);
            if (load && result instanceof ORecordId) {
                result = ((ORecordId)result).getRecord();
            }
            if (listener != null) {
                listener.result(result);
            }
            this.writeIdentifiable((OIdentifiable)result);
        } else if (result instanceof ODocumentWrapper) {
            this.channel.writeByte((byte)114);
            ODocument doc = ((ODocumentWrapper)result).getDocument();
            if (listener != null) {
                listener.result(doc);
            }
            this.writeIdentifiable((OIdentifiable)doc);
        } else if (!isRecordResultSet) {
            this.channel.writeByte((byte)97);
            StringBuilder value = new StringBuilder(64);
            if (listener != null) {
                listener.result(result);
            }
            ORecordSerializerStringAbstract.fieldTypeToString((StringBuilder)value, (OType)OType.getTypeByClass(result.getClass()), (Object)result);
            this.channel.writeString(value.toString());
        } else if (OMultiValue.isMultiValue((Object)result)) {
            byte collectionType = result instanceof Set ? (byte)115 : 108;
            this.channel.writeByte(collectionType);
            this.channel.writeInt(OMultiValue.getSize((Object)result));
            for (Object o : OMultiValue.getMultiValueIterable((Object)result)) {
                try {
                    if (load && o instanceof ORecordId) {
                        o = ((ORecordId)o).getRecord();
                    }
                    if (listener != null) {
                        listener.result(o);
                    }
                    this.writeIdentifiable((OIdentifiable)o);
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    this.writeIdentifiable(null);
                }
            }
        } else if (OMultiValue.isIterable((Object)result)) {
            if (this.connection.data.protocolVersion >= 32) {
                this.channel.writeByte((byte)105);
                for (Object o : OMultiValue.getMultiValueIterable((Object)result)) {
                    try {
                        if (load && o instanceof ORecordId) {
                            o = ((ORecordId)o).getRecord();
                        }
                        if (listener != null) {
                            listener.result(o);
                        }
                        this.channel.writeByte((byte)1);
                        this.writeIdentifiable((OIdentifiable)o);
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    }
                }
                this.channel.writeByte((byte)0);
            } else {
                byte collectionType = result instanceof Set ? (byte)115 : 108;
                this.channel.writeByte(collectionType);
                this.channel.writeInt(OMultiValue.getSize((Object)result));
                for (Object o : OMultiValue.getMultiValueIterable((Object)result)) {
                    try {
                        if (load && o instanceof ORecordId) {
                            o = ((ORecordId)o).getRecord();
                        }
                        if (listener != null) {
                            listener.result(o);
                        }
                        this.writeIdentifiable((OIdentifiable)o);
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    }
                }
            }
        } else {
            this.channel.writeByte((byte)97);
            StringBuilder value = new StringBuilder(64);
            if (listener != null) {
                listener.result(result);
            }
            ORecordSerializerStringAbstract.fieldTypeToString((StringBuilder)value, (OType)OType.getTypeByClass(result.getClass()), (Object)result);
            this.channel.writeString(value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRecord() throws IOException {
        this.setDataCommandInfo("Delete record");
        if (!this.isConnectionAlive()) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        ORecordVersion version = this.channel.readVersion();
        byte mode = this.channel.readByte();
        int result = this.deleteRecord((ODatabaseDocument)this.connection.database, (ORID)rid, version);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeByte((byte)result);
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideRecord() throws IOException {
        this.setDataCommandInfo("Hide record");
        if (!this.isConnectionAlive()) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        byte mode = this.channel.readByte();
        int result = this.hideRecord((ODatabaseDocument)this.connection.database, (ORID)rid);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeByte((byte)result);
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanOutRecord() throws IOException {
        this.setDataCommandInfo("Clean out record");
        if (!this.isConnectionAlive()) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        ORecordVersion version = this.channel.readVersion();
        byte mode = this.channel.readByte();
        int result = this.cleanOutRecord((ODatabaseDocument)this.connection.database, (ORID)rid, version);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeByte((byte)result);
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecord() throws IOException {
        this.setDataCommandInfo("Update record");
        if (!this.isConnectionAlive()) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        boolean updateContent = true;
        if (this.connection.data.protocolVersion >= 23) {
            updateContent = this.channel.readBoolean();
        }
        byte[] buffer = this.channel.readBytes();
        ORecordVersion version = this.channel.readVersion();
        byte recordType = this.channel.readByte();
        byte mode = this.channel.readByte();
        ORecordVersion newVersion = this.updateRecord((ODatabaseDocumentInternal)this.connection.database, rid, buffer, version, recordType, updateContent);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeVersion(newVersion);
                if (this.connection.data.protocolVersion >= 20) {
                    this.sendCollectionChanges();
                }
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRecord() throws IOException {
        this.setDataCommandInfo("Create record");
        if (!this.isConnectionAlive()) {
            return;
        }
        int dataSegmentId = this.connection.data.protocolVersion >= 10 && this.connection.data.protocolVersion < 24 ? this.channel.readInt() : 0;
        ORecordId rid = new ORecordId((int)this.channel.readShort(), -1L);
        byte[] buffer = this.channel.readBytes();
        byte recordType = this.channel.readByte();
        byte mode = this.channel.readByte();
        ORecord record = this.createRecord((ODatabaseDocumentInternal)this.connection.database, rid, buffer, recordType);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                if (this.connection.data.protocolVersion > 25) {
                    this.channel.writeShort((short)record.getIdentity().getClusterId());
                }
                this.channel.writeLong(record.getIdentity().getClusterPosition());
                if (this.connection.data.protocolVersion >= 11) {
                    this.channel.writeVersion(record.getRecordVersion());
                }
                if (this.connection.data.protocolVersion >= 20) {
                    this.sendCollectionChanges();
                }
            }
            finally {
                this.endResponse();
            }
        }
    }

    protected void readRecordMetadata() throws IOException {
        block4: {
            this.setDataCommandInfo("Record metadata");
            ORecordId rid = this.channel.readRID();
            this.beginResponse();
            try {
                ORecordMetadata metadata = this.connection.database.getRecordMetadata((ORID)rid);
                if (metadata != null) {
                    this.sendOk(this.clientTxId);
                    this.channel.writeRID(metadata.getRecordId());
                    this.channel.writeVersion(metadata.getRecordVersion());
                    break block4;
                }
                throw new ODatabaseException(String.format("Record metadata for RID: %s, Not found", rid));
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecord() throws IOException {
        this.setDataCommandInfo("Load record");
        if (!this.isConnectionAlive()) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        String fetchPlanString = this.channel.readString();
        boolean ignoreCache = false;
        if (this.connection.data.protocolVersion >= 9) {
            ignoreCache = this.channel.readByte() == 1;
        }
        boolean loadTombstones = false;
        if (this.connection.data.protocolVersion >= 13) {
            boolean bl = loadTombstones = this.channel.readByte() > 0;
        }
        if (rid.clusterId == 0 && rid.clusterPosition == 0L) {
            OFetchHelper.checkFetchPlanValid((String)fetchPlanString);
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeByte((byte)1);
                if (this.connection.data.protocolVersion <= 27) {
                    this.channel.writeBytes(this.connection.database.getStorage().getConfiguration().toStream((int)this.connection.data.protocolVersion));
                    this.channel.writeVersion(OVersionFactory.instance().createVersion());
                    this.channel.writeByte((byte)98);
                } else {
                    this.channel.writeByte((byte)98);
                    this.channel.writeVersion(OVersionFactory.instance().createVersion());
                    this.channel.writeBytes(this.connection.database.getStorage().getConfiguration().toStream((int)this.connection.data.protocolVersion));
                }
                this.channel.writeByte((byte)0);
            }
            finally {
                this.endResponse();
            }
        }
        ORecord record = this.connection.database.load((ORID)rid, fetchPlanString, ignoreCache, loadTombstones, OStorage.LOCKING_STRATEGY.NONE);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            if (record != null) {
                this.channel.writeByte((byte)1);
                byte[] bytes = this.getRecordBytes(record);
                int length = this.trimCsvSerializedContent(bytes);
                if (this.connection.data.protocolVersion <= 27) {
                    this.channel.writeBytes(bytes, length);
                    this.channel.writeVersion(record.getRecordVersion());
                    this.channel.writeByte(ORecordInternal.getRecordType((ORecord)record));
                } else {
                    this.channel.writeByte(ORecordInternal.getRecordType((ORecord)record));
                    this.channel.writeVersion(record.getRecordVersion());
                    this.channel.writeBytes(bytes, length);
                }
                if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan((String)fetchPlanString);
                    final HashSet recordsToSend = new HashSet();
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch((ORecord)doc, (Object)doc, (OFetchPlan)fetchPlan, (OFetchListener)listener, (OFetchContext)context, (String)"");
                    for (ORecord d : recordsToSend) {
                        if (!d.getIdentity().isValid()) continue;
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable((OIdentifiable)d);
                    }
                }
            }
            this.channel.writeByte((byte)0);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecordIfVersionIsNotLatest() throws IOException {
        boolean ignoreCache;
        this.setDataCommandInfo("Load record if version is not latest");
        if (!this.isConnectionAlive()) {
            return;
        }
        ORecordId rid = this.channel.readRID();
        ORecordVersion recordVersion = this.channel.readVersion();
        String fetchPlanString = this.channel.readString();
        boolean bl = ignoreCache = this.channel.readByte() == 1;
        if (rid.clusterId == 0 && rid.clusterPosition == 0L) {
            OFetchHelper.checkFetchPlanValid((String)fetchPlanString);
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeByte((byte)1);
                if (this.connection.data.protocolVersion <= 27) {
                    this.channel.writeBytes(this.connection.database.getStorage().getConfiguration().toStream((int)this.connection.data.protocolVersion));
                    this.channel.writeVersion(OVersionFactory.instance().createVersion());
                    this.channel.writeByte((byte)98);
                } else {
                    this.channel.writeByte((byte)98);
                    this.channel.writeVersion(OVersionFactory.instance().createVersion());
                    this.channel.writeBytes(this.connection.database.getStorage().getConfiguration().toStream((int)this.connection.data.protocolVersion));
                }
                this.channel.writeByte((byte)0);
            }
            finally {
                this.endResponse();
            }
        }
        ORecord record = this.connection.database.loadIfVersionIsNotLatest((ORID)rid, recordVersion, fetchPlanString, ignoreCache);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            if (record != null) {
                this.channel.writeByte((byte)1);
                byte[] bytes = this.getRecordBytes(record);
                int length = this.trimCsvSerializedContent(bytes);
                this.channel.writeByte(ORecordInternal.getRecordType((ORecord)record));
                this.channel.writeVersion(record.getRecordVersion());
                this.channel.writeBytes(bytes, length);
                if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan((String)fetchPlanString);
                    final HashSet recordsToSend = new HashSet();
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch((ORecord)doc, (Object)doc, (OFetchPlan)fetchPlan, (OFetchListener)listener, (OFetchContext)context, (String)"");
                    for (ORecord d : recordsToSend) {
                        if (!d.getIdentity().isValid()) continue;
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable((OIdentifiable)d);
                    }
                }
            }
            this.channel.writeByte((byte)0);
        }
        finally {
            this.endResponse();
        }
    }

    protected void beginResponse() {
        this.channel.acquireWriteLock();
    }

    protected void endResponse() throws IOException {
        if (this.connection != null && this.connection.database != null && this.connection.database.activateOnCurrentThread().getTransaction() != null) {
            this.connection.database.activateOnCurrentThread();
            this.connection.database.getTransaction().rollback();
        }
        this.channel.flush();
        this.channel.releaseWriteLock();
    }

    protected void setDataCommandInfo(String iCommandInfo) {
        if (this.connection != null) {
            this.connection.data.commandInfo = iCommandInfo;
        }
    }

    protected void readConnectionData() throws IOException {
        this.connection.data.driverName = this.channel.readString();
        this.connection.data.driverVersion = this.channel.readString();
        this.connection.data.protocolVersion = this.channel.readShort();
        this.connection.data.clientId = this.channel.readString();
        this.connection.data.serializationImpl = this.connection.data.protocolVersion > 21 ? this.channel.readString() : "ORecordDocument2csv";
        if (this.connection.tokenBased == null) {
            this.connection.tokenBased = this.connection.data.protocolVersion > 26 ? Boolean.valueOf(this.channel.readBoolean()) : Boolean.valueOf(false);
        } else if (this.connection.data.protocolVersion <= 26 || this.channel.readBoolean() != this.connection.tokenBased.booleanValue()) {
            // empty if block
        }
        if (this.connection.tokenBased.booleanValue() && this.tokenHandler == null) {
            this.connection.tokenBased = false;
        }
    }

    @Override
    protected void sendOk(int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
        if (this.connection == null || Boolean.TRUE.equals(this.connection.tokenBased) && this.token != null && this.requestType != 2 && this.requestType != 3) {
            byte[] renewedToken = this.tokenHandler.renewIfNeeded(this.token);
            this.channel.writeBytes(renewedToken);
        }
    }

    @Override
    protected void handleConnectionError(OChannelBinaryServer iChannel, Throwable e) {
        super.handleConnectionError(this.channel, e);
        OServerPluginHelper.invokeHandlerCallbackOnClientError(this.server, this.connection, e);
    }

    protected void sendResponse(ODocument iResponse) throws IOException {
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeBytes(iResponse != null ? iResponse.toStream() : null);
        }
        finally {
            this.endResponse();
        }
    }

    protected void freezeDatabase() throws IOException {
        this.setDataCommandInfo("Freeze database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.freeze");
        String storageType = this.connection.data.protocolVersion >= 16 ? this.channel.readString() : "local";
        this.connection.database = this.getDatabaseInstance(dbName, "document", storageType);
        if (this.connection.database.exists()) {
            OLogManager.instance().info((Object)this, "Freezing database '%s'", new Object[]{this.connection.database.getURL()});
            if (this.connection.database.isClosed()) {
                this.openDatabase((ODatabaseInternal<?>)this.connection.database, this.connection.serverUser.name, this.connection.serverUser.password);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' does not exist");
        }
        this.connection.database.freeze(true);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    protected void releaseDatabase() throws IOException {
        this.setDataCommandInfo("Release database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.release");
        String storageType = this.connection.data.protocolVersion >= 16 ? this.channel.readString() : "local";
        this.connection.database = this.getDatabaseInstance(dbName, "document", storageType);
        if (this.connection.database.exists()) {
            OLogManager.instance().info((Object)this, "Releasing database '%s'", new Object[]{this.connection.database.getURL()});
            if (this.connection.database.isClosed()) {
                this.openDatabase((ODatabaseInternal<?>)this.connection.database, this.connection.serverUser.name, this.connection.serverUser.password);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' does not exist");
        }
        this.connection.database.release();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    @Override
    protected String getRecordSerializerName() {
        return this.connection.data.serializationImpl;
    }

    private void sendErrorDetails(Throwable current) throws IOException {
        while (current != null) {
            this.channel.writeByte((byte)1);
            this.channel.writeString(current.getClass().getName());
            this.channel.writeString(current.getMessage());
            current = current.getCause();
        }
        this.channel.writeByte((byte)0);
    }

    private void serializeExceptionObject(Throwable original) throws IOException {
        try {
            ODistributedServerManager srvMgr = this.server.getDistributedManager();
            if (srvMgr != null) {
                original = srvMgr.convertException(original);
            }
            OMemoryStream memoryStream = new OMemoryStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)memoryStream);
            objectOutputStream.writeObject(original);
            objectOutputStream.flush();
            byte[] result = memoryStream.toByteArray();
            objectOutputStream.close();
            this.channel.writeBytes(result);
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Cannot serialize an exception object", (Throwable)e, new Object[0]);
            this.channel.writeBytes(OCommonConst.EMPTY_BYTE_ARRAY);
        }
    }

    private void runShutdownInNonDaemonThread() {
        Thread shutdownThread = new Thread("OrientDB server shutdown thread"){

            @Override
            public void run() {
                ONetworkProtocolBinary.this.server.shutdown();
                ShutdownHelper.shutdown(1);
            }
        };
        shutdownThread.setDaemon(false);
        shutdownThread.start();
        try {
            shutdownThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ridBagSize() throws IOException {
        this.setDataCommandInfo("RidBag get size");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer((OChannelBinary)this.channel);
        byte[] changeStream = this.channel.readBytes();
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.database.getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            Map changes = OSBTreeRidBag.ChangeSerializationHelper.INSTANCE.deserializeChanges(changeStream, 0);
            int realSize = tree.getRealBagSize(changes);
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeInt(realSize);
            }
            finally {
                this.endResponse();
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sbTreeBonsaiGetEntriesMajor() throws IOException {
        this.setDataCommandInfo("SB-Tree bonsai get values major");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer((OChannelBinary)this.channel);
        byte[] keyStream = this.channel.readBytes();
        boolean inclusive = this.channel.readBoolean();
        int pageSize = 128;
        if (this.connection.data.protocolVersion >= 21) {
            pageSize = this.channel.readInt();
        }
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.database.getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            OBinarySerializer keySerializer = tree.getKeySerializer();
            OIdentifiable key = (OIdentifiable)keySerializer.deserialize(keyStream, 0);
            OBinarySerializer valueSerializer = tree.getValueSerializer();
            OTreeInternal.AccumulativeListener listener = new OTreeInternal.AccumulativeListener(pageSize);
            tree.loadEntriesMajor((Object)key, inclusive, true, (OTreeInternal.RangeResultListener)listener);
            List result = listener.getResult();
            byte[] stream = this.serializeSBTreeEntryCollection(result, (OBinarySerializer<OIdentifiable>)keySerializer, (OBinarySerializer<Integer>)valueSerializer);
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeBytes(stream);
            }
            finally {
                this.endResponse();
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    private byte[] serializeSBTreeEntryCollection(List<Map.Entry<OIdentifiable, Integer>> collection, OBinarySerializer<OIdentifiable> keySerializer, OBinarySerializer<Integer> valueSerializer) {
        byte[] stream = new byte[4 + collection.size() * (keySerializer.getFixedLength() + valueSerializer.getFixedLength())];
        int offset = 0;
        OIntegerSerializer.INSTANCE.serializeLiteral(collection.size(), stream, offset);
        offset += 4;
        for (Map.Entry<OIdentifiable, Integer> entry : collection) {
            keySerializer.serialize((Object)entry.getKey(), stream, offset, new Object[0]);
            valueSerializer.serialize((Object)entry.getValue(), stream, offset += keySerializer.getObjectSize((Object)entry.getKey(), new Object[0]), new Object[0]);
            offset += valueSerializer.getObjectSize((Object)entry.getValue(), new Object[0]);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sbTreeBonsaiFirstKey() throws IOException {
        this.setDataCommandInfo("SB-Tree bonsai get first key");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer((OChannelBinary)this.channel);
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.database.getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            OIdentifiable result = (OIdentifiable)tree.firstKey();
            Object keySerializer = result == null ? ONullSerializer.INSTANCE : tree.getKeySerializer();
            byte[] stream = new byte[1 + keySerializer.getObjectSize((Object)result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(Byte.valueOf(keySerializer.getId()), stream, 0, new Object[0]);
            keySerializer.serialize((Object)result, stream, 1, new Object[0]);
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeBytes(stream);
            }
            finally {
                this.endResponse();
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sbTreeBonsaiGet() throws IOException {
        this.setDataCommandInfo("SB-Tree bonsai get");
        OBonsaiCollectionPointer collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer((OChannelBinary)this.channel);
        byte[] keyStream = this.channel.readBytes();
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.database.getSbTreeCollectionManager();
        OSBTreeBonsai tree = sbTreeCollectionManager.loadSBTree(collectionPointer);
        try {
            OIdentifiable key = (OIdentifiable)tree.getKeySerializer().deserialize(keyStream, 0);
            Integer result = (Integer)tree.get((Object)key);
            Object valueSerializer = result == null ? ONullSerializer.INSTANCE : tree.getValueSerializer();
            byte[] stream = new byte[1 + valueSerializer.getObjectSize((Object)result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(Byte.valueOf(valueSerializer.getId()), stream, 0, new Object[0]);
            valueSerializer.serialize((Object)result, stream, 1, new Object[0]);
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeBytes(stream);
            }
            finally {
                this.endResponse();
            }
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(collectionPointer);
        }
    }

    private void createSBTreeBonsai() throws IOException {
        this.setDataCommandInfo("Create SB-Tree bonsai instance");
        int clusterId = this.channel.readInt();
        OBonsaiCollectionPointer collectionPointer = this.connection.database.getSbTreeCollectionManager().createSBTree(clusterId, null);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer((OChannelBinary)this.channel, collectionPointer);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerPositions() throws IOException {
        this.setDataCommandInfo("Retrieve lower positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            OPhysicalPosition[] previousPositions = this.connection.database.getStorage().lowerPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (previousPositions != null) {
                this.channel.writeInt(previousPositions.length);
                for (OPhysicalPosition physicalPosition : previousPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void floorPositions() throws IOException {
        this.setDataCommandInfo("Retrieve floor positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            OPhysicalPosition[] previousPositions = this.connection.database.getStorage().floorPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (previousPositions != null) {
                this.channel.writeInt(previousPositions.length);
                for (OPhysicalPosition physicalPosition : previousPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void higherPositions() throws IOException {
        this.setDataCommandInfo("Retrieve higher positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            OPhysicalPosition[] nextPositions = this.connection.database.getStorage().higherPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (nextPositions != null) {
                this.channel.writeInt(nextPositions.length);
                for (OPhysicalPosition physicalPosition : nextPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ceilingPositions() throws IOException {
        this.setDataCommandInfo("Retrieve ceiling positions");
        int clusterId = this.channel.readInt();
        long clusterPosition = this.channel.readLong();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            OPhysicalPosition[] previousPositions = this.connection.database.getStorage().ceilingPhysicalPositions(clusterId, new OPhysicalPosition(clusterPosition));
            if (previousPositions != null) {
                this.channel.writeInt(previousPositions.length);
                for (OPhysicalPosition physicalPosition : previousPositions) {
                    this.channel.writeLong(physicalPosition.clusterPosition);
                    this.channel.writeInt(physicalPosition.recordSize);
                    this.channel.writeVersion(physicalPosition.recordVersion);
                }
            } else {
                this.channel.writeInt(0);
            }
        }
        finally {
            this.endResponse();
        }
    }

    private boolean isConnectionAlive() {
        if (this.connection == null || this.connection.database == null) {
            this.server.getClientConnectionManager().kill(this.connection);
            return false;
        }
        return true;
    }

    private void sendCollectionChanges() throws IOException {
        OSBTreeCollectionManager collectionManager = this.connection.database.getSbTreeCollectionManager();
        if (collectionManager != null) {
            Map changedIds = collectionManager.changedIds();
            this.channel.writeInt(changedIds.size());
            for (Map.Entry entry : changedIds.entrySet()) {
                UUID id = (UUID)entry.getKey();
                this.channel.writeLong(id.getMostSignificantBits());
                this.channel.writeLong(id.getLeastSignificantBits());
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer((OChannelBinary)this.channel, (OBonsaiCollectionPointer)entry.getValue());
            }
            collectionManager.clearChangedIds();
        }
    }

    private void sendDatabaseInformation() throws IOException {
        Collection clusters = this.connection.database.getStorage().getClusterInstances();
        int clusterCount = 0;
        for (OCluster c : clusters) {
            if (c == null) continue;
            ++clusterCount;
        }
        if (this.connection.data.protocolVersion >= 7) {
            this.channel.writeShort((short)clusterCount);
        } else {
            this.channel.writeInt(clusterCount);
        }
        for (OCluster c : clusters) {
            if (c == null) continue;
            this.channel.writeString(c.getName());
            this.channel.writeShort((short)c.getId());
            if (this.connection.data.protocolVersion < 12 || this.connection.data.protocolVersion >= 24) continue;
            this.channel.writeString("none");
            this.channel.writeShort((short)-1);
        }
    }

    private void listDatabases() throws IOException {
        this.checkServerAccess("server.dblist");
        ODocument result = new ODocument();
        result.field("databases", this.server.getAvailableStorageNames());
        this.setDataCommandInfo("List databases");
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            byte[] stream = this.getRecordBytes((ORecord)result);
            this.channel.writeBytes(stream);
        }
        finally {
            this.endResponse();
        }
    }

    private boolean loadUserFromSchema(String iUserName, String iUserPassword) {
        this.connection.database.getMetadata().getSecurity().authenticate(iUserName, iUserPassword);
        return true;
    }
}

