/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class OJMXPlugin
extends OServerPluginAbstract {
    private ObjectName onProfiler;
    private boolean profilerManaged;

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                return;
            }
            if (!param.name.equalsIgnoreCase("profilerManaged")) continue;
            this.profilerManaged = Boolean.parseBoolean(param.value);
        }
        OLogManager.instance().info((Object)this, "JMX plugin installed and active: profilerManaged=%s", new Object[]{this.profilerManaged});
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            if (this.profilerManaged) {
                this.onProfiler = new ObjectName("com.orientechnologies.common.profiler:type=OProfilerMXBean");
                if (mBeanServer.isRegistered(this.onProfiler)) {
                    mBeanServer.unregisterMBean(this.onProfiler);
                }
                mBeanServer.registerMBean(Orient.instance().getProfiler(), this.onProfiler);
            }
        }
        catch (Exception e) {
            throw new OConfigurationException("Cannot initialize JMX server", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (this.onProfiler != null && mBeanServer.isRegistered(this.onProfiler)) {
                mBeanServer.unregisterMBean(this.onProfiler);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "OrientDB Server v2.1.18 unregisterMBean error.", (Throwable)e, new Object[0]);
        }
    }

    public String getName() {
        return "jmx";
    }
}

