/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.ONetworkThreadLocalSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import java.io.IOException;
import java.net.Socket;
import java.util.Set;
import java.util.logging.Level;

public abstract class OBinaryNetworkProtocolAbstract
extends ONetworkProtocol {
    protected final Level logClientExceptions = Level.parse(OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL.getValueAsString());
    protected final boolean logClientFullStackTrace = OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE.getValueAsBoolean();
    protected OChannelBinaryServer channel;
    protected volatile int requestType;
    protected int clientTxId;
    protected OToken token;
    protected boolean okSent;
    protected OTokenHandler tokenHandler;

    public OBinaryNetworkProtocolAbstract(String iThreadName) {
        super(Orient.instance().getThreadGroup(), iThreadName);
    }

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        this.server = iServer;
        this.channel = new OChannelBinaryServer(iSocket, iConfig);
        try {
            this.tokenHandler = (OTokenHandler)this.server.getPlugin("OTokenHandler");
            if (this.tokenHandler != null && !this.tokenHandler.isEnabled()) {
                this.tokenHandler = null;
            }
        }
        catch (ODatabaseException e) {
            OLogManager.instance().debug((Object)this, "Error on retrieving plugin '%s'", (Throwable)e, new Object[]{"OTokenHandler"});
        }
    }

    @Override
    public int getVersion() {
        return 32;
    }

    public void shutdown() {
        this.channel.close();
    }

    @Override
    public OChannel getChannel() {
        return this.channel;
    }

    public void writeIdentifiable(OIdentifiable o) throws IOException {
        if (o == null) {
            this.channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            this.channel.writeShort((short)-3);
            this.channel.writeRID((ORID)o);
        } else {
            this.writeRecord(o.getRecord());
        }
    }

    @Override
    public String getType() {
        return "binary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRecord(ORecordId rid, byte[] buffer, ORecordVersion version, ORecord record, ODatabaseDocumentInternal iDatabase) {
        String dbSerializerName = "";
        if (iDatabase != null) {
            dbSerializerName = iDatabase.getSerializer().toString();
        }
        String name = this.getRecordSerializerName();
        if (ORecordInternal.getRecordType((ORecord)record) == 100 && !dbSerializerName.equals(name)) {
            ORecordInternal.fill((ORecord)record, (ORID)rid, (ORecordVersion)version, null, (boolean)true);
            try {
                ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
                ONetworkThreadLocalSerializer.setNetworkSerializer((ORecordSerializer)ser);
                record.fromStream(buffer);
            }
            finally {
                ONetworkThreadLocalSerializer.setNetworkSerializer(null);
            }
            record.setDirty();
        } else {
            ORecordInternal.fill((ORecord)record, (ORID)rid, (ORecordVersion)version, (byte[])buffer, (boolean)true);
        }
    }

    protected abstract boolean executeRequest() throws IOException;

    protected abstract void sendError(int var1, Throwable var2) throws IOException;

    protected void onBeforeRequest() throws IOException {
    }

    protected void onAfterRequest() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        this.requestType = -1;
        if (this.isShutdownFlag()) {
            return;
        }
        this.clientTxId = 0;
        this.okSent = false;
        long timer = 0L;
        try {
            this.requestType = this.channel.readByte();
            this.clientTxId = this.channel.readInt();
            timer = Orient.instance().getProfiler().startChrono();
            try {
                this.onBeforeRequest();
            }
            catch (Exception e) {
                this.sendError(this.clientTxId, e);
                try {
                    this.channel.flush();
                }
                catch (IOException e1) {
                    OLogManager.instance().debug((Object)this, "Error during channel flush", (Throwable)e1, new Object[0]);
                }
                this.sendShutdown();
                Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
                ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
                return;
            }
            try {
                if (!this.executeRequest()) {
                    OLogManager.instance().error((Object)this, "Request not supported. Code: " + this.requestType, new Object[0]);
                    this.channel.clearInput();
                    this.sendErrorOrDropConnection(this.clientTxId, (Throwable)new ONetworkProtocolException("Request not supported. Code: " + this.requestType));
                }
            }
            finally {
                this.onAfterRequest();
            }
        }
        catch (IOException e) {
            OLogManager.instance().debug((Object)this, "Exception executing request", (Throwable)e, new Object[0]);
            this.sendShutdown();
        }
        catch (OException e) {
            this.sendErrorOrDropConnection(this.clientTxId, e);
        }
        catch (RuntimeException e) {
            this.sendErrorOrDropConnection(this.clientTxId, e);
        }
        catch (Throwable t) {
            this.sendErrorOrDropConnection(this.clientTxId, t);
        }
        finally {
            Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", timer, "server.network.requests");
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        }
    }

    protected void sendOk(int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
        this.okSent = true;
    }

    protected void sendErrorOrDropConnection(int iClientTxId, Throwable t) throws IOException {
        if (this.okSent || this.requestType == 5) {
            this.handleConnectionError(this.channel, t);
            this.sendShutdown();
        } else {
            this.okSent = true;
            this.sendError(iClientTxId, t);
        }
    }

    protected void checkStorageExistence(String iDatabaseName) {
        for (OStorage stg : Orient.instance().getStorages()) {
            if (stg instanceof OStorageProxy || !stg.getName().equalsIgnoreCase(iDatabaseName) || !stg.exists()) continue;
            throw new ODatabaseException("Database named '" + iDatabaseName + "' already exists: " + stg);
        }
    }

    protected ODatabaseDocumentTx createDatabase(ODatabaseDocumentTx iDatabase, String dbUser, String dbPasswd) {
        if (iDatabase.exists()) {
            throw new ODatabaseException("Database '" + iDatabase.getURL() + "' already exists");
        }
        iDatabase.create();
        if (dbUser != null) {
            OUser oUser = iDatabase.getMetadata().getSecurity().getUser(dbUser);
            if (oUser == null) {
                iDatabase.getMetadata().getSecurity().createUser(dbUser, dbPasswd, new String[]{"admin"});
            } else {
                oUser.setPassword(dbPasswd);
                oUser.save();
            }
        }
        OLogManager.instance().info((Object)this, "Created database '%s' of type '%s'", new Object[]{iDatabase.getName(), iDatabase.getStorage().getUnderlying() instanceof OAbstractPaginatedStorage ? iDatabase.getStorage().getUnderlying().getType() : "memory"});
        return iDatabase;
    }

    protected ODatabaseDocumentTx getDatabaseInstance(String dbName, String dbType, String storageType) {
        String path;
        OStorage stg = Orient.instance().getStorage(dbName);
        if (stg != null) {
            path = stg.getURL();
        } else if (storageType.equals("plocal")) {
            path = this.server.getConfiguration().getStoragePath(dbName);
            if (path == null) {
                path = storageType + ":" + this.server.getDatabaseDirectory() + "/" + dbName;
            }
        } else if (storageType.equals("memory")) {
            path = storageType + ":" + dbName;
        } else {
            throw new IllegalArgumentException("Cannot create database: storage mode '" + storageType + "' is not supported.");
        }
        return Orient.instance().getDatabaseFactory().createDatabase(dbType, path);
    }

    protected int deleteRecord(ODatabaseDocument iDatabase, ORID rid, ORecordVersion version) {
        try {
            ORecord record = rid.getRecord();
            if (record == null) {
                return 0;
            }
            iDatabase.delete(rid, version);
            return 1;
        }
        catch (ORecordNotFoundException e) {
            if (e.getCause() instanceof OOfflineClusterException) {
                throw (OOfflineClusterException)e.getCause();
            }
        }
        catch (OOfflineClusterException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected int hideRecord(ODatabaseDocument iDatabase, ORID rid) {
        try {
            iDatabase.hide(rid);
            return 1;
        }
        catch (ORecordNotFoundException e) {
            return 0;
        }
    }

    protected int cleanOutRecord(ODatabaseDocument iDatabase, ORID rid, ORecordVersion version) {
        iDatabase.delete(rid, version);
        return 1;
    }

    protected ORecord createRecord(ODatabaseDocumentInternal iDatabase, ORecordId rid, byte[] buffer, byte recordType) {
        ORecord record = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        this.fillRecord(rid, buffer, OVersionFactory.instance().createVersion(), record, iDatabase);
        iDatabase.save((Object)record);
        return record;
    }

    protected ORecordVersion updateRecord(ODatabaseDocumentInternal iDatabase, ORecordId rid, byte[] buffer, ORecordVersion version, byte recordType, boolean updateContent) {
        ORecord newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        this.fillRecord(rid, buffer, version, newRecord, null);
        ORecordInternal.setContentChanged((ORecord)newRecord, (boolean)updateContent);
        ORecord currentRecord = null;
        if (newRecord instanceof ODocument) {
            block6: {
                try {
                    currentRecord = (ORecord)iDatabase.load((ORID)rid);
                }
                catch (ORecordNotFoundException e) {
                    if (!(e.getCause() instanceof OOfflineClusterException)) break block6;
                    throw (OOfflineClusterException)e.getCause();
                }
            }
            if (currentRecord == null) {
                throw new ORecordNotFoundException(rid.toString());
            }
            ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
        } else {
            currentRecord = newRecord;
        }
        currentRecord.getRecordVersion().copyFrom(version);
        iDatabase.save((Object)currentRecord);
        if (currentRecord.getIdentity().toString().equals(iDatabase.getStorage().getConfiguration().indexMgrRecordId) && !iDatabase.getStatus().equals((Object)ODatabase.STATUS.IMPORTING)) {
            iDatabase.getMetadata().getIndexManager().reload();
        }
        return currentRecord.getRecordVersion();
    }

    protected void handleConnectionError(OChannelBinaryServer channel, Throwable e) {
        try {
            channel.flush();
        }
        catch (IOException e1) {
            OLogManager.instance().debug((Object)this, "Error during channel flush", (Throwable)e1, new Object[0]);
        }
        OLogManager.instance().error((Object)this, "Error executing request", e, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecordBytes(ORecord iRecord) {
        byte[] stream;
        try {
            String dbSerializerName = null;
            if (ODatabaseRecordThreadLocal.INSTANCE.getIfDefined() != null) {
                dbSerializerName = ((ODatabaseDocumentInternal)iRecord.getDatabase()).getSerializer().toString();
            }
            String name = this.getRecordSerializerName();
            if (!(ORecordInternal.getRecordType((ORecord)iRecord) != 100 || dbSerializerName != null && dbSerializerName.equals(name))) {
                ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(dbSerializerName);
                ONetworkThreadLocalSerializer.setNetworkSerializer((ORecordSerializer)ser);
                ((ODocument)iRecord).deserializeFields(new String[0]);
                ser = ORecordSerializerFactory.instance().getFormat(name);
                ONetworkThreadLocalSerializer.setNetworkSerializer((ORecordSerializer)ser);
            }
            stream = iRecord.toStream();
        }
        finally {
            ONetworkThreadLocalSerializer.setNetworkSerializer(null);
        }
        return stream;
    }

    protected abstract String getRecordSerializerName();

    private void writeRecord(ORecord iRecord) throws IOException {
        if (iRecord.isDirty()) {
            ORecordInternal.unsetDirty((ORecord)iRecord);
        }
        this.channel.writeShort((short)0);
        this.channel.writeByte(ORecordInternal.getRecordType((ORecord)iRecord));
        this.channel.writeRID(iRecord.getIdentity());
        this.channel.writeVersion(iRecord.getRecordVersion());
        try {
            byte[] stream = this.getRecordBytes(iRecord);
            int realLength = this.trimCsvSerializedContent(stream);
            this.channel.writeBytes(stream, realLength);
        }
        catch (Exception e) {
            this.channel.writeBytes(null);
            String message = "Error on unmarshalling record " + iRecord.getIdentity().toString() + " (" + e + ")";
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw new OSerializationException(message, (Throwable)e);
        }
    }

    protected int trimCsvSerializedContent(byte[] stream) {
        int realLength = stream.length;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db instanceof ODatabaseDocument && "ORecordDocument2csv".equals(this.getRecordSerializerName())) {
            for (int i = stream.length - 1; i > -1 && stream[i] == 32; --i) {
                --realLength;
            }
        }
        return realLength;
    }

    public int getRequestType() {
        return this.requestType;
    }
}

