/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class OServerInfo {
    public static String getServerInfo(OServer server) throws IOException {
        StringWriter jsonBuffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)jsonBuffer);
        json.beginObject();
        OServerInfo.getConnections(server, json, null);
        OServerInfo.getDatabases(server, json);
        OServerInfo.getStorages(server, json);
        OServerInfo.getProperties(server, json);
        OServerInfo.getGlobalProperties(server, json);
        json.endObject();
        return jsonBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getConnections(OServer server, OJSONWriter json, String databaseName) throws IOException {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        json.beginCollection(1, true, "connections");
        List<OClientConnection> conns = server.getClientConnectionManager().getConnections();
        for (OClientConnection c : conns) {
            String connectedOn;
            String lastCommandOn;
            ONetworkProtocolData data = c.data;
            if (databaseName != null && !databaseName.equals(data.lastDatabase)) continue;
            SimpleDateFormat simpleDateFormat = dateTimeFormat;
            synchronized (simpleDateFormat) {
                lastCommandOn = dateTimeFormat.format(new Date(data.lastCommandReceived));
                connectedOn = dateTimeFormat.format(new Date(c.since));
            }
            json.beginObject(2);
            OServerInfo.writeField(json, 2, "connectionId", c.id);
            OServerInfo.writeField(json, 2, "remoteAddress", c.protocol.getChannel() != null ? c.protocol.getChannel().toString() : "Disconnected");
            OServerInfo.writeField(json, 2, "db", data.lastDatabase != null ? data.lastDatabase : "-");
            OServerInfo.writeField(json, 2, "user", data.lastUser != null ? data.lastUser : "-");
            OServerInfo.writeField(json, 2, "totalRequests", data.totalRequests);
            OServerInfo.writeField(json, 2, "commandInfo", data.commandInfo);
            OServerInfo.writeField(json, 2, "commandDetail", data.commandDetail);
            OServerInfo.writeField(json, 2, "lastCommandOn", lastCommandOn);
            OServerInfo.writeField(json, 2, "lastCommandInfo", data.lastCommandInfo);
            OServerInfo.writeField(json, 2, "lastCommandDetail", data.lastCommandDetail);
            OServerInfo.writeField(json, 2, "lastExecutionTime", data.lastCommandExecutionTime);
            OServerInfo.writeField(json, 2, "totalWorkingTime", data.totalCommandExecutionTime);
            OServerInfo.writeField(json, 2, "connectedOn", connectedOn);
            OServerInfo.writeField(json, 2, "protocol", c.protocol.getType());
            OServerInfo.writeField(json, 2, "sessionId", data.sessionId);
            OServerInfo.writeField(json, 2, "clientId", data.clientId);
            StringBuilder driver = new StringBuilder(128);
            if (data.driverName != null) {
                driver.append(data.driverName);
                driver.append(" v");
                driver.append(data.driverVersion);
                driver.append(" Protocol v");
                driver.append(data.protocolVersion);
            }
            OServerInfo.writeField(json, 2, "driver", driver.toString());
            json.endObject(2);
        }
        json.endCollection(1, false);
    }

    public static void getGlobalProperties(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(2, true, "globalProperties");
        for (OGlobalConfiguration c : OGlobalConfiguration.values()) {
            json.beginObject(3, true, null);
            json.writeAttribute(4, false, "key", (Object)c.getKey());
            json.writeAttribute(4, false, "description", (Object)c.getDescription());
            json.writeAttribute(4, false, "value", c.isHidden() ? "<hidden>" : c.getValue());
            json.writeAttribute(4, false, "defaultValue", c.getDefValue());
            json.writeAttribute(4, false, "canChange", (Object)c.isChangeableAtRuntime());
            json.endObject(3, true);
        }
        json.endCollection(2, true);
    }

    public static void getProperties(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(2, true, "properties");
        OServerEntryConfiguration[] confProperties = server.getConfiguration().properties;
        if (confProperties != null) {
            for (OServerEntryConfiguration entry : confProperties) {
                json.beginObject(3, true, null);
                json.writeAttribute(4, false, "name", (Object)entry.name);
                json.writeAttribute(4, false, "value", (Object)entry.value);
                json.endObject(3, true);
            }
        }
        json.endCollection(2, true);
    }

    public static void getStorages(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(1, true, "storages");
        Collection storages = Orient.instance().getStorages();
        for (OStorage s : storages) {
            json.beginObject(2);
            OServerInfo.writeField(json, 2, "name", s.getName());
            OServerInfo.writeField(json, 2, "type", s.getClass().getSimpleName());
            OServerInfo.writeField(json, 2, "path", s instanceof OLocalPaginatedStorage ? ((OLocalPaginatedStorage)s).getStoragePath().replace('\\', '/') : "");
            OServerInfo.writeField(json, 2, "activeUsers", "n.a.");
            json.endObject(2);
        }
        json.endCollection(1, false);
    }

    public static void getDatabases(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(1, true, "dbs");
        if (!server.getDatabasePoolFactory().isClosed()) {
            Collection dbPools = server.getDatabasePoolFactory().getPools();
            for (OPartitionedDatabasePool pool : dbPools) {
                OServerInfo.writeField(json, 2, "db", pool.getUrl());
                OServerInfo.writeField(json, 2, "user", pool.getUserName());
                json.endObject(2);
            }
        }
        json.endCollection(1, false);
    }

    private static void writeField(OJSONWriter json, int iLevel, String iAttributeName, Object iAttributeValue) throws IOException {
        json.writeAttribute(iLevel, true, iAttributeName, (Object)(iAttributeValue != null ? iAttributeValue.toString() : "-"));
    }
}

