/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ODistributedSyncConfiguration {
    private ODocument configuration = new ODocument();
    private File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedSyncConfiguration(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            return;
        }
        FileInputStream is = new FileInputStream(file);
        try {
            this.configuration.fromJSON((InputStream)is);
        }
        catch (OSerializationException e) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber getLSN(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument embedded = (ODocument)this.configuration.field(iNode);
            if (embedded == null) {
                return null;
            }
            return new OLogSequenceNumber(((Long)embedded.field("segment")).longValue(), ((Long)embedded.field("position")).longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLSN(String iNode, OLogSequenceNumber iLSN) throws IOException {
        ODocument embedded = new ODocument();
        embedded.field("segment", (Object)iLSN.getSegment(), new OType[]{OType.LONG});
        embedded.field("position", (Object)iLSN.getPosition(), new OType[]{OType.LONG});
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        FileOutputStream os = new FileOutputStream(this.file, false);
        try {
            ODocument oDocument = this.configuration;
            synchronized (oDocument) {
                this.configuration.field(iNode, (Object)embedded, new OType[]{OType.EMBEDDED});
                this.incrementVersion();
                this.configuration.toJSON((OutputStream)os);
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return this.configuration.isEmpty();
        }
    }

    private void incrementVersion() {
        Integer oldVersion = (Integer)this.configuration.field("version");
        if (oldVersion == null) {
            oldVersion = 0;
        }
        this.configuration.field("version", (Object)(oldVersion + 1));
    }
}

