/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class OCreateRecordTask
extends OAbstractRecordReplicatedTask {
    public static final String SUFFIX_QUEUE_NAME = ".insert";
    private static final long serialVersionUID = 1L;
    protected byte[] content;
    protected byte recordType;
    protected int clusterId = -1;
    private transient ORecord record;

    public OCreateRecordTask() {
    }

    public OCreateRecordTask(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        super(iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public OCreateRecordTask(ORecord record) {
        this((ORecordId)record.getIdentity(), record.toStream(), record.getVersion(), ORecordInternal.getRecordType((ORecord)record));
        if (this.rid.getClusterId() == -1) {
            OImmutableClass clazz;
            if (record instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)((ODocument)record))) != null) {
                this.clusterId = clazz.getClusterSelection().getCluster((OClass)clazz, (ODocument)record);
            } else {
                ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
                this.clusterId = db.getDefaultClusterId();
            }
        }
    }

    @Override
    public ORecord getRecord() {
        if (this.record == null) {
            this.record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
            ORecordInternal.fill((ORecord)this.record, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
        }
        return this.record;
    }

    public void resetRecord() {
        this.record = null;
    }

    @Override
    void setLockRecord(boolean lockRecord) {
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "creating record %s/%s v.%d...", database.getName(), this.rid.toString(), this.version);
        this.getRecord();
        long clusterPosToReach = this.rid.getClusterPosition();
        if (ORecordId.isPersistent((long)clusterPosToReach)) {
            ORecordInternal.setIdentity((ORecord)this.record, (int)this.rid.getClusterId(), (long)-1L);
        }
        while (true) {
            if (this.clusterId > -1) {
                this.record.save(database.getClusterNameById(this.clusterId), true);
            } else if (this.rid.getClusterId() != -1) {
                this.record.save(database.getClusterNameById(this.rid.getClusterId()), true);
            } else {
                this.record.save();
            }
            this.rid = (ORecordId)this.record.getIdentity();
            if (clusterPosToReach <= 0L || this.rid.clusterPosition >= clusterPosToReach) break;
            this.rid.getRecord().delete();
        }
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> assigned new rid %s/%s v.%d", database.getName(), this.rid.toString(), this.record.getVersion());
        return new OPlaceholder(this.record);
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public List<OAbstractRemoteTask> getFixTask(ODistributedRequest iRequest, OAbstractRemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNode, ODistributedServerManager dManager) {
        if (iBadResponse instanceof Throwable) {
            return null;
        }
        OPlaceholder badResult = (OPlaceholder)iBadResponse;
        OPlaceholder goodResult = (OPlaceholder)iGoodResponse;
        ArrayList<OAbstractRemoteTask> result = new ArrayList<OAbstractRemoteTask>(2);
        if (!badResult.equals((Object)goodResult)) {
            if (badResult.getIdentity().getClusterId() == goodResult.getIdentity().getClusterId() && badResult.getIdentity().getClusterPosition() < goodResult.getIdentity().getClusterPosition()) {
                long minPos;
                for (long pos = minPos = Math.max(badResult.getIdentity().getClusterPosition() - 1L, 0L); pos < goodResult.getIdentity().getClusterPosition(); ++pos) {
                    ORecord toUpdateRecord;
                    ORecordId toUpdateRid = new ORecordId(goodResult.getIdentity().getClusterId(), pos);
                    if (dManager.getLocalNodeName().equals(executorNode)) {
                        ODistributedConfiguration dCfg = dManager.getDatabaseConfiguration(iRequest.getDatabaseName());
                        List<String> nodes = dCfg.getServers(ODatabaseRecordThreadLocal.INSTANCE.get().getClusterNameById(this.clusterId), dManager.getLocalNodeName());
                        ORawBuffer remoteReadRecord = (ORawBuffer)dManager.sendRequest(iRequest.getDatabaseName(), null, nodes, new OReadRecordTask(toUpdateRid), ODistributedRequest.EXECUTION_MODE.RESPONSE);
                        if (remoteReadRecord != null) {
                            toUpdateRecord = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
                            ORecordInternal.fill((ORecord)toUpdateRecord, (ORID)toUpdateRid, (int)remoteReadRecord.version, (byte[])remoteReadRecord.buffer, (boolean)false);
                        } else {
                            toUpdateRecord = null;
                        }
                    } else {
                        toUpdateRecord = toUpdateRid.getRecord();
                    }
                    if (toUpdateRecord == null) continue;
                    result.add(new OUpdateRecordTask(toUpdateRid, toUpdateRecord.toStream(), toUpdateRecord.getVersion(), toUpdateRecord.toStream(), toUpdateRecord.getVersion(), ORecordInternal.getRecordType((ORecord)toUpdateRecord)));
                }
                result.add(new OCreateRecordTask((ORecordId)goodResult.getIdentity(), this.content, this.version, this.recordType));
            } else if (badResult.getIdentity().getClusterId() != goodResult.getIdentity().getClusterId() || badResult.getIdentity().getClusterPosition() <= goodResult.getIdentity().getClusterPosition()) {
                result.add(new ODeleteRecordTask(new ORecordId(badResult.getIdentity()), badResult.getVersion()).setDelayed(false));
            }
        }
        return result;
    }

    @Override
    public ODeleteRecordTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        if (iBadResponse instanceof Throwable) {
            return null;
        }
        OPlaceholder badResult = (OPlaceholder)iBadResponse;
        return new ODeleteRecordTask(new ORecordId(badResult.getIdentity()), badResult.getVersion()).setDelayed(false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.content == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.content.length);
            out.write(this.content);
        }
        out.write(this.recordType);
        out.writeInt(this.clusterId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int contentSize = in.readInt();
        if (contentSize == 0) {
            this.content = null;
        } else {
            this.content = new byte[contentSize];
            in.readFully(this.content);
        }
        this.recordType = in.readByte();
        this.clusterId = in.readInt();
    }

    @Override
    public String getName() {
        return "record_create";
    }
}

