/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class OFixTxTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    private List<OAbstractRemoteTask> tasks = new ArrayList<OAbstractRemoteTask>();
    private Set<ORID> locks;

    public OFixTxTask() {
    }

    public OFixTxTask(Set<ORID> iLocks) {
        this.locks = iLocks;
    }

    public List<OAbstractRemoteTask> getTasks() {
        return this.tasks;
    }

    public void add(OAbstractRemoteTask iTask) {
        this.tasks.add(iTask);
    }

    public void addAll(Collection<OAbstractRemoteTask> iTasks) {
        this.tasks.addAll(iTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(final OServer iServer, final ODistributedServerManager iManager, final ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "fixing %d conflicts found during committing transaction against db=%s...", this.tasks.size(), database.getName());
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)database);
        try {
            OScenarioThreadLocal.executeAsDistributed((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    for (OAbstractRemoteTask task : OFixTxTask.this.tasks) {
                        if (task instanceof OAbstractRecordReplicatedTask) {
                            ((OAbstractRecordReplicatedTask)task).setLockRecord(false);
                        }
                        task.execute(iServer, iManager, database);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Exception during attempt to fix inconsistency between nodes", (Throwable)e, new Object[0]);
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
            if (this.locks != null) {
                for (ORID r : this.locks) {
                    ddb.unlockRecord(r);
                }
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.tasks.size());
        for (OAbstractRemoteTask task : this.tasks) {
            out.writeObject(task);
        }
        out.writeInt(this.locks.size());
        for (ORID r : this.locks) {
            out.writeObject(r);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.tasks.add((OAbstractRemoteTask)in.readObject());
        }
        int lockSize = in.readInt();
        for (int i = 0; i < lockSize; ++i) {
            this.locks.add((ORID)in.readObject());
        }
    }

    @Override
    public String getName() {
        return "fix_tx";
    }
}

