/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class OSyncDatabaseDeltaTask
extends OAbstractReplicatedTask {
    public static final int CHUNK_MAX_SIZE = 0x400000;
    public static final String DEPLOYDB = "deploydb.";
    protected OLogSequenceNumber startLSN;
    protected long random;

    public OSyncDatabaseDeltaTask() {
    }

    public OSyncDatabaseDeltaTask(OLogSequenceNumber iFirstLSN) {
        this.startLSN = iFirstLSN;
        this.random = UUID.randomUUID().getLeastSignificantBits();
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        if (!this.getNodeSource().equals(iManager.getLocalNodeName())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            String databaseName = database.getName();
            Object chunk = this.deltaBackup(iManager, database, databaseName);
            if (chunk != null) {
                return chunk;
            }
        } else {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database from the same node", new Object[0]);
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object deltaBackup(ODistributedServerManager iManager, ODatabaseDocumentTx database, String databaseName) throws IOException, InterruptedException {
        try {
            AtomicReference<ODistributedDatabaseDeltaSyncException> exception;
            AtomicReference<OLogSequenceNumber> endLSN;
            File backupFile;
            AtomicLong lastOperationId;
            block28: {
                OStorage storage;
                Long lastDeployment = (Long)iManager.getConfigurationMap().get(DEPLOYDB + databaseName);
                if (lastDeployment != null && lastDeployment == this.random) {
                    ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying delta database '%s' because already executed", databaseName);
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                iManager.getConfigurationMap().put(DEPLOYDB + databaseName, this.random);
                iManager.setDatabaseStatus(this.getNodeSource(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploying database %s with delta of changes...", databaseName);
                lastOperationId = new AtomicLong(-1L);
                backupFile = new File(Orient.getTempPath() + "/backup_" + this.getNodeSource() + "_" + database.getName() + ".zip");
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "creating delta backup of database '%s' (startLSN=%s) in directory: %s...", databaseName, this.startLSN, backupFile.getAbsolutePath());
                if (backupFile.exists()) {
                    backupFile.delete();
                } else {
                    backupFile.getParentFile().mkdirs();
                }
                backupFile.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(backupFile);
                File completedFile = new File(backupFile.getAbsolutePath() + ".completed");
                if (completedFile.exists()) {
                    completedFile.delete();
                }
                if (!((storage = database.getStorage().getUnderlying()) instanceof OAbstractPaginatedStorage)) {
                    throw new UnsupportedOperationException("Storage '" + storage.getName() + "' does not support distributed delta backup");
                }
                endLSN = new AtomicReference<OLogSequenceNumber>();
                exception = new AtomicReference<ODistributedDatabaseDeltaSyncException>();
                endLSN.set(((OAbstractPaginatedStorage)storage).recordsChangedAfterLSN(this.startLSN, (OutputStream)fileOutputStream));
                lastOperationId.set(database.getStorage().getLastOperationId());
                if (endLSN.get() == null) {
                    exception.set(new ODistributedDatabaseDeltaSyncException(this.startLSN));
                }
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "delta backup of database '%s' completed. range=%s-=%s...", databaseName, this.startLSN, endLSN);
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    completedFile.createNewFile();
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Cannot create file of delta backup completed: %s", (Throwable)e, new Object[]{completedFile});
                }
                break block28;
                catch (Exception e3222222222) {
                    try {
                        exception.set((ODistributedDatabaseDeltaSyncException)((Object)OException.wrapException((OException)((Object)new ODistributedDatabaseDeltaSyncException(this.startLSN)), (Throwable)e3222222222)));
                    }
                    catch (Throwable throwable) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            completedFile.createNewFile();
                        }
                        catch (IOException e2) {
                            OLogManager.instance().error((Object)this, "Cannot create file of delta backup completed: %s", (Throwable)e2, new Object[]{completedFile});
                        }
                        throw throwable;
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e3222222222) {
                        // empty catch block
                    }
                    try {
                        completedFile.createNewFile();
                    }
                    catch (IOException e4) {
                        OLogManager.instance().error((Object)this, "Cannot create file of delta backup completed: %s", (Throwable)e4, new Object[]{completedFile});
                    }
                }
            }
            if (exception.get() instanceof ODistributedDatabaseDeltaSyncException) {
                throw (ODistributedDatabaseDeltaSyncException)((Object)exception.get());
            }
            ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk(lastOperationId.get(), backupFile, 0L, 0x400000, (OLogSequenceNumber)endLSN.get(), false);
            ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "- transferring chunk #%d offset=%d size=%s...", 1, 0, OFileUtils.getSizeAsNumber((Object)chunk.buffer.length));
            if (chunk.last) {
                iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
            }
            ODistributedDatabaseChunk oDistributedDatabaseChunk = chunk;
            return oDistributedDatabaseChunk;
        }
        finally {
            ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploy delta database task completed", new Object[0]);
        }
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return OAbstractRemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public boolean isRequireNodeOnline() {
        return false;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public String getName() {
        return "deploy_delta_db";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.startLSN.writeExternal(out);
        out.writeLong(this.random);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startLSN = new OLogSequenceNumber(in);
        this.random = in.readLong();
    }

    @Override
    public boolean isRequiredOpenDatabase() {
        return true;
    }
}

