/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public class OSyncDatabaseTask
extends OAbstractReplicatedTask
implements OCommandOutputListener {
    public static final int CHUNK_MAX_SIZE = 0x400000;
    public static final String DEPLOYDB = "deploydb.";
    protected long random = UUID.randomUUID().getLeastSignificantBits();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OServer iServer, final ODistributedServerManager iManager, final ODatabaseDocumentTx database) throws Exception {
        if (!this.getNodeSource().equals(iManager.getLocalNodeName())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            final String databaseName = database.getName();
            Lock lock = iManager.getLock("sync." + databaseName);
            if (lock.tryLock()) {
                try {
                    Long lastDeployment = (Long)iManager.getConfigurationMap().get(DEPLOYDB + databaseName);
                    if (lastDeployment != null && lastDeployment == this.random) {
                        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database '%s' because already executed", databaseName);
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    iManager.getConfigurationMap().put(DEPLOYDB + databaseName, this.random);
                    iManager.setDatabaseStatus(this.getNodeSource(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                    iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploying database %s...", databaseName);
                    final AtomicLong lastOperationId = new AtomicLong(-1L);
                    final AtomicReference endLSN = new AtomicReference();
                    File backupFile = ((ODistributedStorage)database.getStorage()).getLastValidBackup();
                    if (backupFile == null || !backupFile.exists()) {
                        backupFile = new File(Orient.getTempPath() + "/backup_" + database.getName() + ".zip");
                        int compressionRate = OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger();
                        ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "creating backup of database '%s' (compressionRate=%d) in directory: %s...", databaseName, compressionRate, backupFile.getAbsolutePath());
                        if (backupFile.exists()) {
                            backupFile.delete();
                        } else {
                            backupFile.getParentFile().mkdirs();
                        }
                        backupFile.createNewFile();
                        final FileOutputStream fileOutputStream = new FileOutputStream(backupFile);
                        final File completedFile = new File(backupFile.getAbsolutePath() + ".completed");
                        if (completedFile.exists()) {
                            completedFile.delete();
                        }
                        new Thread(new Runnable(){

                            /*
                             * Loose catch block
                             */
                            @Override
                            public void run() {
                                block16: {
                                    Thread.currentThread().setName("OrientDB SyncDatabase node=" + iManager.getLocalNodeName() + " db=" + databaseName);
                                    database.backup((OutputStream)fileOutputStream, null, (Callable)new Callable<Object>(){

                                        @Override
                                        public Object call() throws Exception {
                                            lastOperationId.set(database.getStorage().getLastOperationId());
                                            endLSN.set(((OAbstractPaginatedStorage)database.getStorage().getUnderlying()).getLSN());
                                            return null;
                                        }
                                    }, new OCommandOutputListener(){

                                        public void onMessage(String iText) {
                                            if (iText.startsWith("\n")) {
                                                iText = iText.substring(1);
                                            }
                                            OLogManager.instance().info((Object)this, iText, new Object[0]);
                                        }
                                    }, OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger(), 0x400000);
                                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), OSyncDatabaseTask.this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "backup of database '%s' completed. lastOperationId=%d...", databaseName, lastOperationId.get());
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    try {
                                        completedFile.createNewFile();
                                    }
                                    catch (IOException e) {
                                        OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e, new Object[]{completedFile});
                                    }
                                    break block16;
                                    catch (IOException e3222222222) {
                                        try {
                                            OLogManager.instance().error((Object)this, "Cannot execute backup of database '%s' for deploy database", (Throwable)e3222222222, new Object[]{databaseName});
                                        }
                                        catch (Throwable throwable) {
                                            try {
                                                fileOutputStream.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            try {
                                                completedFile.createNewFile();
                                            }
                                            catch (IOException e2) {
                                                OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e2, new Object[]{completedFile});
                                            }
                                            throw throwable;
                                        }
                                        try {
                                            fileOutputStream.close();
                                        }
                                        catch (IOException e3222222222) {
                                            // empty catch block
                                        }
                                        try {
                                            completedFile.createNewFile();
                                        }
                                        catch (IOException e4) {
                                            OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e4, new Object[]{completedFile});
                                        }
                                    }
                                }
                            }
                        }).start();
                        ((ODistributedStorage)database.getStorage()).setLastValidBackup(backupFile);
                        while (lastOperationId.get() < 0L) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    } else {
                        lastOperationId.set(database.getStorage().getLastOperationId());
                        ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "reusing last backup of database '%s' in directory: %s...", databaseName, backupFile.getAbsolutePath());
                    }
                    ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk(lastOperationId.get(), backupFile, 0L, 0x400000, (OLogSequenceNumber)endLSN.get(), false);
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "- transferring chunk #%d offset=%d size=%s...", 1, 0, OFileUtils.getSizeAsNumber((Object)chunk.buffer.length));
                    if (chunk.last) {
                        iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                    }
                    ODistributedDatabaseChunk oDistributedDatabaseChunk = chunk;
                    return oDistributedDatabaseChunk;
                }
                finally {
                    lock.unlock();
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploy database task completed", new Object[0]);
                }
            }
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database %s because another node is doing it", databaseName);
        } else {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database from the same node", new Object[0]);
        }
        return Boolean.FALSE;
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return OAbstractRemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public boolean isRequireNodeOnline() {
        return false;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public String getName() {
        return "deploy_db";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.random);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.random = in.readLong();
    }

    public void onMessage(String iText) {
        if (iText.startsWith("\r\n")) {
            iText = iText.substring(2);
        }
        if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().info((Object)this, iText, new Object[0]);
    }

    @Override
    public boolean isRequiredOpenDatabase() {
        return true;
    }
}

