/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class OUpdateRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    protected byte[] previousContent;
    protected int previousVersion;
    protected byte recordType;
    protected byte[] content;
    private transient ORecord record;
    private transient boolean lockRecord = true;

    public OUpdateRecordTask() {
    }

    public OUpdateRecordTask(ORecordId iRid, byte[] iPreviousContent, int iPreviousVersion, byte[] iContent, int iVersion, byte iRecordType) {
        super(iRid, iVersion);
        this.previousContent = iPreviousContent;
        this.previousVersion = iPreviousVersion;
        this.content = iContent;
        this.recordType = iRecordType;
    }

    @Override
    public ORecord getRecord() {
        if (this.record == null) {
            this.record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
            ORecordInternal.fill((ORecord)this.record, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
        }
        return this.record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "updating record %s/%s v.%d", database.getName(), this.rid.toString(), this.version);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        if (!this.inTx && this.lockRecord && !ddb.lockRecord((ORID)this.rid, this.nodeSource)) {
            throw new ODistributedRecordLockedException((ORID)this.rid);
        }
        try {
            Object object;
            ORecord loadedRecord = this.rid.getRecord();
            if (loadedRecord == null) {
                throw new ORecordNotFoundException("Record " + this.rid + " was not found on update");
            }
            if (loadedRecord instanceof ODocument) {
                ODocument loadedDocument = (ODocument)loadedRecord;
                ODocument newDocument = (ODocument)this.getRecord();
                int loadedRecordVersion = loadedDocument.merge(newDocument, false, false).getVersion();
                if (loadedRecordVersion != this.version) {
                    loadedDocument.setDirty();
                }
                ORecordInternal.setVersion((ORecord)loadedDocument, (int)this.version);
            } else {
                ORecordInternal.fill((ORecord)loadedRecord, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
            }
            loadedRecord = database.save(loadedRecord);
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> updated record %s/%s v.%d", database.getName(), this.rid.toString(), loadedRecord.getVersion());
            if (database.getTransaction().isActive()) {
                object = new VersionPlaceholder(loadedRecord);
                return object;
            }
            object = loadedRecord.getVersion();
            return object;
        }
        finally {
            if (!this.inTx) {
                ddb.unlockRecord((ORID)this.rid);
            }
        }
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public List<OAbstractRemoteTask> getFixTask(ODistributedRequest iRequest, OAbstractRemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        int versionCopy = ORecordVersionHelper.setRollbackMode((int)this.previousVersion);
        ArrayList<OAbstractRemoteTask> fixTasks = new ArrayList<OAbstractRemoteTask>(1);
        fixTasks.add(new OUpdateRecordTask(this.rid, null, -1, ((OUpdateRecordTask)iOriginalTask).content, versionCopy, this.recordType));
        return fixTasks;
    }

    @Override
    public OAbstractRemoteTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        int versionCopy = ORecordVersionHelper.setRollbackMode((int)this.previousVersion);
        return new OUpdateRecordTask(this.rid, null, -1, this.previousContent, versionCopy, this.recordType);
    }

    public boolean isLockRecord() {
        return this.lockRecord;
    }

    @Override
    public void setLockRecord(boolean lockRecord) {
        this.lockRecord = lockRecord;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.content.length);
        out.write(this.content);
        out.write(this.recordType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        this.recordType = in.readByte();
    }

    public byte[] getPreviousContent() {
        return this.previousContent;
    }

    public int getPreviousVersion() {
        return this.previousVersion;
    }

    @Override
    public String getName() {
        return "record_update";
    }

    @Override
    public String toString() {
        if (ORecordVersionHelper.isTemporary((int)this.version)) {
            return this.getName() + "(" + this.rid + " v." + (this.version - Integer.MIN_VALUE) + " realV." + this.version + ")";
        }
        return super.toString();
    }

    public byte[] getContent() {
        return this.content;
    }

    public class VersionPlaceholder {
        protected ORecord record;

        public VersionPlaceholder(ORecord record) {
            this.record = record;
        }

        public int getVersion() {
            return this.record.getVersion();
        }
    }
}

