/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.ShutdownHelper;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerSocketFactory;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class OServerNetworkListener
extends Thread {
    private OServerSocketFactory socketFactory;
    private ServerSocket serverSocket;
    private InetSocketAddress inboundAddr;
    private Class<? extends ONetworkProtocol> protocolType;
    private volatile boolean active = true;
    private List<OServerCommandConfiguration> statefulCommands = new ArrayList<OServerCommandConfiguration>();
    private List<OServerCommand> statelessCommands = new ArrayList<OServerCommand>();
    private int socketBufferSize;
    private OContextConfiguration configuration;
    private OServer server;
    private int protocolVersion = -1;

    public OServerNetworkListener(OServer iServer, OServerSocketFactory iSocketFactory, String iHostName, String iHostPortRange, String iProtocolName, Class<? extends ONetworkProtocol> iProtocol, OServerParameterConfiguration[] iParameters, OServerCommandConfiguration[] iCommands) {
        super(Orient.instance().getThreadGroup(), "OrientDB " + iProtocol.getSimpleName() + " listen at " + iHostName + ":" + iHostPortRange);
        this.server = iServer;
        this.socketFactory = iSocketFactory == null ? OServerSocketFactory.getDefault() : iSocketFactory;
        try {
            this.protocolVersion = iProtocol.newInstance().getVersion();
        }
        catch (Exception e) {
            String message = "Error on reading protocol version for " + iProtocol;
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new ONetworkProtocolException(message), (Throwable)e);
        }
        this.listen(iHostName, iHostPortRange, iProtocolName, iProtocol);
        this.protocolType = iProtocol;
        this.readParameters(iServer.getContextConfiguration(), iParameters);
        if (iCommands != null) {
            for (int i = 0; i < iCommands.length; ++i) {
                if (iCommands[i].stateful) {
                    this.registerStatefulCommand(iCommands[i]);
                    continue;
                }
                this.registerStatelessCommand(OServerNetworkListener.createCommand(this.server, iCommands[i]));
            }
        }
        this.start();
    }

    public static int[] getPorts(String iHostPortRange) {
        int[] ports;
        if (OStringSerializerHelper.contains((String)iHostPortRange, (char)',')) {
            String[] portValues = iHostPortRange.split(",");
            ports = new int[portValues.length];
            for (int i = 0; i < portValues.length; ++i) {
                ports[i] = Integer.parseInt(portValues[i]);
            }
        } else if (OStringSerializerHelper.contains((String)iHostPortRange, (char)'-')) {
            String[] limits = iHostPortRange.split("-");
            int lowerLimit = Integer.parseInt(limits[0]);
            int upperLimit = Integer.parseInt(limits[1]);
            ports = new int[upperLimit - lowerLimit + 1];
            for (int i = 0; i < upperLimit - lowerLimit + 1; ++i) {
                ports[i] = lowerLimit + i;
            }
        } else {
            ports = new int[]{Integer.parseInt(iHostPortRange)};
        }
        return ports;
    }

    public static OServerCommand createCommand(OServer server, OServerCommandConfiguration iCommand) {
        try {
            Constructor<?> c = Class.forName(iCommand.implementation).getConstructor(OServerCommandConfiguration.class);
            OServerCommand cmd = (OServerCommand)c.newInstance(iCommand);
            cmd.configure(server);
            return cmd;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create custom command invoking the constructor: " + iCommand.implementation + "(" + iCommand + ")", e);
        }
    }

    public List<OServerCommandConfiguration> getStatefulCommands() {
        return this.statefulCommands;
    }

    public List<OServerCommand> getStatelessCommands() {
        return this.statelessCommands;
    }

    public OServerNetworkListener registerStatelessCommand(OServerCommand iCommand) {
        this.statelessCommands.add(iCommand);
        return this;
    }

    public OServerNetworkListener unregisterStatelessCommand(Class<? extends OServerCommand> iCommandClass) {
        for (OServerCommand c : this.statelessCommands) {
            if (!c.getClass().equals(iCommandClass)) continue;
            this.statelessCommands.remove(c);
            break;
        }
        return this;
    }

    public OServerNetworkListener registerStatefulCommand(OServerCommandConfiguration iCommand) {
        this.statefulCommands.add(iCommand);
        return this;
    }

    public OServerNetworkListener unregisterStatefulCommand(OServerCommandConfiguration iCommand) {
        this.statefulCommands.remove(iCommand);
        return this;
    }

    public void shutdown() {
        this.active = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block11: while (true) {
            while (this.active) {
                try {
                    try {
                        ODistributedServerManager.NODE_STATUS nodeStatus;
                        Socket socket = this.serverSocket.accept();
                        if (this.server.getDistributedManager() != null && (nodeStatus = this.server.getDistributedManager().getNodeStatus()) != ODistributedServerManager.NODE_STATUS.ONLINE) {
                            OLogManager.instance().warn((Object)this, "Distributed server is not yet ONLINE (status=%s), reject incoming connection from %s. If you are trying to shutdown the server, please kill the process", new Object[]{nodeStatus, socket.getRemoteSocketAddress()});
                            socket.close();
                            Thread.sleep(100L);
                            continue;
                        }
                        int max = OGlobalConfiguration.NETWORK_MAX_CONCURRENT_SESSIONS.getValueAsInteger();
                        int conns = this.server.getClientConnectionManager().getTotal();
                        if (conns >= max) {
                            this.server.getClientConnectionManager().cleanExpiredConnections();
                            conns = this.server.getClientConnectionManager().getTotal();
                            if (conns >= max) {
                                OLogManager.instance().warn((Object)this, "Reached maximum number of concurrent connections (max=%d, current=%d), reject incoming connection from %s", new Object[]{max, conns, socket.getRemoteSocketAddress()});
                                socket.close();
                                Thread.sleep(100L);
                                continue;
                            }
                        }
                        socket.setPerformancePreferences(0, 2, 1);
                        socket.setSendBufferSize(this.socketBufferSize);
                        socket.setReceiveBufferSize(this.socketBufferSize);
                        ONetworkProtocol protocol = this.protocolType.newInstance();
                        protocol.config(this, this.server, socket, this.configuration);
                    }
                    catch (Throwable e) {
                        if (!this.active) continue block11;
                        OLogManager.instance().error((Object)this, "Error on client connection", e, new Object[0]);
                    }
                    continue block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                    return;
                }
            }
        }
        finally {
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Class<? extends ONetworkProtocol> getProtocolType() {
        return this.protocolType;
    }

    public InetSocketAddress getInboundAddr() {
        return this.inboundAddr;
    }

    public String getListeningAddress(boolean resolveMultiIfcWithLocal) {
        String address = this.serverSocket.getInetAddress().getHostAddress().toString();
        if (resolveMultiIfcWithLocal && address.equals("0.0.0.0")) {
            try {
                address = InetAddress.getLocalHost().getHostAddress().toString();
            }
            catch (UnknownHostException e) {
                try {
                    address = OChannel.getLocalIpAddress((boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return address + ":" + this.serverSocket.getLocalPort();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.protocolType.getSimpleName()).append(" ").append(this.serverSocket.getLocalSocketAddress()).append(":");
        return builder.toString();
    }

    public Object getCommand(Class<?> iCommandClass) {
        for (OServerCommand oServerCommand : this.statelessCommands) {
            if (!oServerCommand.getClass().equals(iCommandClass)) continue;
            return oServerCommand;
        }
        for (OServerCommandConfiguration oServerCommandConfiguration : this.statefulCommands) {
            if (!oServerCommandConfiguration.implementation.equals(iCommandClass.getName())) continue;
            return oServerCommandConfiguration;
        }
        return null;
    }

    private void listen(String iHostName, String iHostPortRange, String iProtocolName, Class<? extends ONetworkProtocol> protocolClass) {
        for (int port : OServerNetworkListener.getPorts(iHostPortRange)) {
            this.inboundAddr = new InetSocketAddress(iHostName, port);
            try {
                this.serverSocket = this.socketFactory.createServerSocket(port, 0, InetAddress.getByName(iHostName));
                if (!this.serverSocket.isBound()) continue;
                OLogManager.instance().info((Object)this, "Listening $ANSI{green " + iProtocolName + "} connections on $ANSI{green " + this.inboundAddr.getAddress().getHostAddress() + ":" + this.inboundAddr.getPort() + "} (protocol v." + this.protocolVersion + ", socket=" + this.socketFactory.getName() + ")", new Object[0]);
                return;
            }
            catch (BindException be) {
                OLogManager.instance().warn((Object)this, "Port %s:%d busy, trying the next available...", new Object[]{iHostName, port});
            }
            catch (SocketException se) {
                OLogManager.instance().error((Object)this, "Unable to create socket", (Throwable)se, new Object[0]);
                ShutdownHelper.shutdown(1);
            }
            catch (IOException ioe) {
                OLogManager.instance().error((Object)this, "Unable to read data from an open socket", (Throwable)ioe, new Object[0]);
                System.err.println("Unable to read data from an open socket.");
                ShutdownHelper.shutdown(1);
            }
        }
        OLogManager.instance().error((Object)this, "Unable to listen for connections using the configured ports '%s' on host '%s'", new Object[]{iHostPortRange, iHostName});
        ShutdownHelper.shutdown(1);
    }

    private void readParameters(OContextConfiguration iServerConfig, OServerParameterConfiguration[] iParameters) {
        this.configuration = new OContextConfiguration(iServerConfig);
        if (iParameters != null && iParameters.length > 0) {
            for (OServerParameterConfiguration param : iParameters) {
                this.configuration.setValue(param.name, (Object)param.value);
            }
        }
        this.socketBufferSize = this.configuration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_BUFFER_SIZE);
    }
}

