/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.io.IOException;
import java.net.Socket;

public abstract class ONetworkProtocol
extends OSoftThread {
    private static final int MAX_RETRIES = 20;
    protected OServer server;

    public ONetworkProtocol(ThreadGroup group, String name) {
        super(group, name);
        this.setDumpExceptions(false);
    }

    public abstract void config(OServerNetworkListener var1, OServer var2, Socket var3, OContextConfiguration var4) throws IOException;

    public abstract String getType();

    public abstract int getVersion();

    public abstract OChannel getChannel();

    public String getListeningAddress() {
        OChannel c = this.getChannel();
        if (c != null) {
            return c.socket.getLocalAddress().getHostAddress();
        }
        return null;
    }

    public OServer getServer() {
        return this.server;
    }

    public void waitNodeIsOnline() throws OTimeoutException {
        ODistributedServerManager mgr = this.server.getDistributedManager();
        if (mgr != null && mgr.isEnabled() && mgr.isOffline()) {
            for (int retry = 0; retry < 20; ++retry) {
                if (mgr == null || !mgr.isOffline()) {
                    return;
                }
                OLogManager.instance().info((Object)this, "Node is not online yet (status=%s), blocking the command until it's online %d/%d", new Object[]{mgr.getNodeStatus(), retry + 1, 20});
                ONetworkProtocol.pauseCurrentThread((long)300L);
            }
            throw new OOfflineNodeException("Cannot execute operation while the node is not online (status=" + (Object)((Object)mgr.getNodeStatus()) + ")");
        }
    }
}

